/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.future.pricedepth.data;

import ilog.views.chart.data.IlvDataSet;
import leaseLineQuote.candle.graph.indicator.IndicatorData;
import leaseLineQuote.future.pricedepth.data.PeriodDataSet;

public class SumDataSet
extends PeriodDataSet {
    private final String name;

    public SumDataSet(int period) {
        this((IlvDataSet)null, period);
    }

    public SumDataSet(IlvDataSet dataSet, int period) {
        IlvDataSet[] ilvDataSetArray;
        if (dataSet == null) {
            ilvDataSetArray = null;
        } else {
            IlvDataSet[] ilvDataSetArray2 = new IlvDataSet[1];
            ilvDataSetArray = ilvDataSetArray2;
            ilvDataSetArray2[0] = dataSet;
        }
        super(ilvDataSetArray, period);
        this.name = dataSet == null ? "Sum" : dataSet.getName();
        this.setMaxDataSetCount(1);
    }

    @Override
    protected String getIndicatorName() {
        String name = this.name + "(";
        return name + this.getPeriod() + ")";
    }

    @Override
    protected double[] computeIndicatorData() {
        if (this.getPeriod() == 0 || this.getDataSetCount() == 0) {
            return null;
        }
        IndicatorData data = IndicatorData.get(this.getDataSet(0));
        if (data == null) {
            return null;
        }
        return SumDataSet.computeSum(data, this.getPeriod());
    }

    public static double[] computeSum(IndicatorData data, int period) {
        int j2;
        int i2;
        int start = period - data.headerLength - 1;
        int count = data.dataCount;
        if (start >= count) {
            return null;
        }
        double[] vals = data.data;
        double[] res = new double[count];
        double sum = 0.0;
        for (i2 = 0; i2 < start; ++i2) {
            res[i2] = UNDEF_VALUE;
        }
        int c2 = j2 + period;
        for (j2 = start < -1 ? -start : 0; j2 < c2; ++j2) {
            sum += vals[j2];
        }
        res[i2++] = sum;
        int skip = period;
        while (i2 < count) {
            sum = sum - vals[j2 - period] + vals[j2];
            if (--skip > 0) {
                res[i2] = UNDEF_VALUE;
            } else {
                skip = period;
                res[i2] = sum;
            }
            ++i2;
            ++j2;
        }
        return res;
    }

    public static double[] computeSMA(IndicatorData data, int period) {
        int j2;
        int i2;
        int start = period - data.headerLength - 1;
        int count = data.dataCount;
        if (start >= count) {
            return null;
        }
        double[] vals = data.data;
        double[] res = new double[count];
        double sum = 0.0;
        for (i2 = 0; i2 < start; ++i2) {
            res[i2] = UNDEF_VALUE;
        }
        int c2 = j2 + period;
        for (j2 = start < -1 ? -start : 0; j2 < c2; ++j2) {
            sum += vals[j2];
        }
        res[i2++] = sum / (double)period;
        while (i2 < count) {
            sum = sum - vals[j2 - period] + vals[j2];
            res[i2] = sum / (double)period;
            ++i2;
            ++j2;
        }
        return res;
    }
}

