/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.future.pricedepth.data;

import ilog.views.chart.data.IlvCombinedDataSet;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.event.DataSetContentsEvent;
import ilog.views.chart.event.DataSetPropertyEvent;

public abstract class IndicatorDataSet
extends IlvCombinedDataSet {
    public static final Double UNDEF_VALUE = new Double(Double.MIN_VALUE);
    private boolean computeData = false;
    private double[] indicatorData = new double[0];
    private boolean xValuesSorted = false;

    public IndicatorDataSet(IlvDataSet[] dataSets) {
        this(dataSets, true);
    }

    public IndicatorDataSet(IlvDataSet[] dataSets, boolean computeData) {
        this.setUndefValue(UNDEF_VALUE);
        this.computeData = computeData;
        this.setDataSets(dataSets);
    }

    @Override
    public void setUndefValue(Double undefValue) {
        if (undefValue != UNDEF_VALUE) {
            throw new IllegalArgumentException();
        }
        super.setUndefValue(undefValue);
    }

    @Override
    public String getName() {
        String name = super.getName();
        return name != null ? name : this.getIndicatorName();
    }

    protected String getIndicatorName() {
        return null;
    }

    @Override
    protected void dataSetsChanged() {
        super.dataSetsChanged();
        int count = this.getDataSetCount();
        this.xValuesSorted = true;
        for (int i2 = 0; i2 < count; ++i2) {
            if (this.getDataSet(i2).isXValuesSorted()) continue;
            this.xValuesSorted = false;
            break;
        }
        this.updateIndicatorData();
    }

    @Override
    public boolean isXValuesSorted() {
        return this.xValuesSorted;
    }

    @Override
    public double getYData(int idx) {
        return this.indicatorData[idx];
    }

    @Override
    public double getXData(int idx) {
        return this.getDataSet(0).getXData(idx);
    }

    @Override
    protected void dataSetContentsChanged(DataSetContentsEvent evt) {
        super.dataSetContentsChanged(evt);
        if (evt.getType() != 1 && evt.getType() != 5) {
            this.updateIndicatorData();
            this.fireDataSetContentsEvent(new DataSetContentsEvent(this));
        }
    }

    @Override
    protected void dataSetPropertyChanged(DataSetPropertyEvent evt) {
        this.fireDataSetPropertyEvent(new DataSetPropertyEvent(this, evt));
    }

    protected void updateIndicatorData() {
        if (!this.computeData) {
            this.computeData = true;
            return;
        }
        this.indicatorData = this.computeIndicatorData();
        if (this.indicatorData == null) {
            this.indicatorData = new double[0];
        }
        this.setLimitsValid(false);
        this.updateDataCount();
    }

    protected abstract double[] computeIndicatorData();

    @Override
    protected int computeDataCount() {
        return this.indicatorData.length;
    }
}

