/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.testpart;

import hk.com.realink.chart.dto.minChart.access.AccessStockMinChart;
import hk.com.realink.chart.dto.minChart.access.StockMinChartMessage;
import hk.com.realink.feed.toolkit.RKDebug;
import hk.com.realink.login.Message;
import hk.com.realink.login.client.Handler;
import hk.com.realink.quot.typeimple.MessageReq;
import hk.com.realink.quot.typeimple.MessageRes;
import hk.com.realink.socketagent.AccessModeType;
import hk.com.realink.socketagent.AgentContent;
import hk.com.realink.socketagent.AgentMessage;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import leaseLineQuote.UserProfile;

public class LoginAgentHandler {
    private static LoginAgentHandler loginAgentHandler;
    private String name = "";
    private int headId = 2;
    private String agentIP;
    private int agentPort;
    private Handler myHandler;
    private int msgSeq = 0;
    private DataReceiveListener dataReceiveListener;

    private LoginAgentHandler() {
    }

    public static LoginAgentHandler getInstance() {
        if (loginAgentHandler == null) {
            loginAgentHandler = new LoginAgentHandler();
        }
        return loginAgentHandler;
    }

    public static void main(String[] args) {
        LoginAgentHandler logonTest = LoginAgentHandler.getInstance();
        logonTest.connect("128.0.0.246", 9000, "news", 2);
    }

    public void setDataReceiveListence(DataReceiveListener dataReceiveListener) {
        this.dataReceiveListener = dataReceiveListener;
    }

    public void connect(String agentIP, int agentPort, String name, int headId) {
        RKDebug.warning(null, "connecting login agent ...");
        this.agentIP = agentIP;
        this.agentPort = agentPort;
        this.headId = headId;
        this.name = name;
        if (this.myHandler != null) {
            this.myHandler.handleStop();
        }
        String login = JOptionPane.showInputDialog("login name");
        String pass = JOptionPane.showInputDialog("password");
        if (login == null || login.length() == 0) {
            login = "50009";
        }
        if (pass == null || pass.length() == 0) {
            pass = "123456";
        }
        this.myHandler = new Handler(this.agentIP, this.agentPort, login, pass, headId, 5, false){

            public void handle(Message msg) {
                switch (msg.type) {
                    case 12: {
                        System.out.println("User Profile received, restore now");
                        if (!(msg.details instanceof Hashtable)) break;
                        Hashtable userProfile = (Hashtable)msg.details;
                        String[] keys = userProfile.keySet().toArray(new String[0]);
                        UserProfile.setProfiles((Hashtable)userProfile);
                        break;
                    }
                    case 6: {
                        if (msg.details instanceof AgentMessage) {
                            System.out.println("LoginAgentHandler -- Type.REPLY instanceof AgentMessage");
                            LoginAgentHandler.this.dataReceiveListener.receiveAgentMessage(msg);
                            break;
                        }
                        if (msg.details instanceof MessageRes) {
                            System.out.println("LoginAgentHandler -- connect() -- handler() -- Type.REPLY");
                            LoginAgentHandler.this.dataReceiveListener.receive(msg);
                            break;
                        }
                        if (msg.details instanceof String) {
                            RKDebug.warning(null, msg.details.toString());
                            break;
                        }
                        if (msg.details instanceof MessageReq) {
                            RKDebug.warning(null, "<system> server not exist");
                            break;
                        }
                        RKDebug.warning(null, "<system> unknown message instance");
                    }
                }
            }
        };
        this.myHandler.connect();
        int newsSuccess = this.myHandler.connectStatus();
        if (newsSuccess == 2) {
            RKDebug.warning(null, "connection login agent successful.");
            this.myHandler.start();
            this.myHandler.send(name, 2, 12, 1000, 0, (Object)"");
        } else {
            RKDebug.warning(null, "connection login agent failed.");
        }
    }

    public void reqMessage(String stockCode, int period, int monthIndex, long date) {
        AccessStockMinChart asmc = new AccessStockMinChart();
        asmc.create();
        asmc.setStockCode(stockCode);
        asmc.setPeriod(period);
        asmc.setMonthIndex(monthIndex);
        asmc.setDate(date);
        StockMinChartMessage smcm = new StockMinChartMessage();
        smcm.addAccessMode((AccessModeType)asmc);
        AgentMessage agentMessage = new AgentMessage((AgentContent)smcm, 1);
        this.send(agentMessage);
    }

    public void send(Object message) {
        this.send(this.name, 2, 5, 0, 0, message, -1, true);
    }

    private void send(String name, int head, int type, int option, int seq, Object message, int desc, boolean log) {
        if (this.myHandler != null) {
            if (log) {
                ++this.msgSeq;
            }
            this.myHandler.cSend(name, head, type, option, this.msgSeq, message, null);
        }
    }

    public static interface DataReceiveListener {
        public void receive(Message var1);

        public void receiveAgentMessage(Message var1);
    }
}

