/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.indicator;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.graphic.IlvDataIndicator;
import ilog.views.chart.renderer.IlvPolylineChartRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import leaseLineQuote.candle.datasource.StockDataSource;
import leaseLineQuote.candle.graph.indicator.StochasticDataSource;
import leaseLineQuote.candle.graph.indicator.TechnicalIndicator;

public class StochasticIndicator
extends TechnicalIndicator {
    IlvChartRenderer renderer;
    StochasticDataSource stoDS;
    String desc;
    IlvDataIndicator[] indicators;
    Color[] colors;
    int[] cfgs;

    public StochasticIndicator(StockDataSource stockDS, int period1, int period2, int period3, Color[] colors, String desc) {
        super(stockDS);
        this.stoDS = new StochasticDataSource(period1, period2, period3);
        this.desc = desc;
        this.colors = colors;
        this.cfgs = new int[]{period1, period2, period3};
    }

    @Override
    public void setColor(Color[] colors) {
        this.colors = colors;
        this.renderer.setStyles(new IlvStyle[]{new IlvStyle(2.0f, (Paint)this.colors[0]), new IlvStyle(1.0f, (Paint)this.colors[1])});
    }

    @Override
    public void setCfg(Object cfg) {
        this.cfgs = (int[])cfg;
        this.stoDS.period1 = this.cfgs[0];
        this.stoDS.period2 = this.cfgs[1];
        this.stoDS.period3 = this.cfgs[2];
        this.refresh();
    }

    @Override
    public void attach(IlvChart chart) {
        super.attach(chart);
        this.renderer = new IlvPolylineChartRenderer();
        this.renderer.setDataSource(this.stoDS);
        BasicStroke stroke = new BasicStroke(1.0f, 0, 2, 10.0f, new float[]{4.0f}, 0.0f);
        IlvStyle style1 = new IlvStyle(stroke, (Paint)Color.RED.darker());
        stroke = new BasicStroke(1.0f, 0, 2, 10.0f, new float[]{4.0f}, 0.0f);
        IlvStyle style2 = new IlvStyle(stroke, (Paint)Color.RED.darker());
        this.indicators = new IlvDataIndicator[3];
        this.indicators[0] = new IlvDataIndicator(0, 20.0, null);
        this.indicators[0].setStyle(style2);
        this.indicators[1] = new IlvDataIndicator(0, 50.0, null);
        this.indicators[1].setStyle(style1);
        this.indicators[2] = new IlvDataIndicator(0, 80.0, null);
        this.indicators[2].setStyle(style2);
        for (int i2 = 0; i2 < this.indicators.length; ++i2) {
            this.indicators[i2].setDrawOrder(1);
            chart.addDecoration(this.indicators[i2]);
        }
        this.refresh();
        chart.addRenderer(this.renderer);
    }

    @Override
    public void detach() {
        if (this.chart != null && this.chart.getRendererCount() > 0) {
            this.chart.removeRenderer(this.renderer);
            for (int i2 = 0; i2 < this.indicators.length; ++i2) {
                this.chart.removeDecoration(this.indicators[i2]);
            }
        }
        this.renderer = null;
        super.detach();
    }

    @Override
    public void refresh() {
        IlvDataSet hids = this.stockDS.getHighDataSet();
        IlvDataSet lods = this.stockDS.getLowDataSet();
        IlvDataSet closeds = this.stockDS.getCloseDataSet();
        IlvDataSet[] dataSets = null;
        if (hids != null && lods != null && closeds != null) {
            dataSets = new IlvDataSet[]{hids, lods, closeds};
        }
        this.stoDS.setHLCDataSets(dataSets);
        if (this.renderer.getChildCount() == 2) {
            this.renderer.setStyles(new IlvStyle[]{new IlvStyle(2.0f, (Paint)this.colors[0]), new IlvStyle(1.0f, (Paint)this.colors[1])});
        }
    }

    @Override
    public IlvDisplayPoint getHighlightedPoint(int dataIdx) {
        IlvDataSet dataSet = this.getMainDataSet();
        if (this.renderer != null && dataSet != null && dataSet.getDataCount() > 0) {
            return this.renderer.getDisplayPoint(dataSet, dataIdx);
        }
        return null;
    }

    @Override
    public IlvDataSet getMainDataSet() {
        return this.stoDS.getDataSetCount() == 0 ? null : this.stoDS.getDataSet(0);
    }

    @Override
    public String getName() {
        return this.desc == null ? "Stochastic" : this.desc;
    }

    public static StochasticIndicator createFastStochastic(StockDataSource stockDS, int[] cfgs, Color[] colors) {
        return new StochasticIndicator(stockDS, cfgs[0], cfgs[1], cfgs[2], colors, "Fast Stochastic");
    }

    public static StochasticIndicator createSlowStochastic(StockDataSource stockDS, int[] cfgs, Color[] colors) {
        return new StochasticIndicator(stockDS, cfgs[0], cfgs[1], cfgs[2], colors, "Slow Stochastic");
    }
}

