/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.indicator;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.graphic.IlvDataIndicator;
import ilog.views.chart.renderer.IlvSinglePolylineRenderer;
import ilog.views.util.java2d.IlvPattern;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import leaseLineQuote.candle.datasource.StockDataSource;
import leaseLineQuote.candle.graph.indicator.RSIDataSet;
import leaseLineQuote.candle.graph.indicator.TechnicalIndicator;

public class RSIIndicator
extends TechnicalIndicator {
    private IlvChartRenderer renderer;
    private IlvDataIndicator[] indicators;
    private RSIDataSet rsiDataSet;
    private Color color;
    private int[] levelIndicators = new int[2];
    private int[] cfgs;
    private static ArrayList rsiList = new ArrayList();

    public RSIIndicator(StockDataSource stockDS, Color color, int[] cfgs) {
        super(stockDS);
        this.color = color;
        this.levelIndicators[0] = cfgs[0];
        this.levelIndicators[1] = cfgs[1];
        this.rsiDataSet = new RSIDataSet(cfgs[2]);
        this.cfgs = cfgs;
    }

    @Override
    public void attach(IlvChart chart) {
        super.attach(chart);
        this.renderer = new IlvSinglePolylineRenderer(IlvStyle.createStroked(this.color));
        this.indicators = new IlvDataIndicator[3];
        this.indicators[0] = new IlvDataIndicator(0, new IlvDataInterval(0.0, this.levelIndicators[0]), null);
        Color RSI_PATTERN_COLOR = new Color(255, 172, 172);
        IlvPattern p2 = new IlvPattern(14, RSI_PATTERN_COLOR, null);
        this.indicators[0].setStyle(new IlvStyle(p2));
        this.indicators[1] = new IlvDataIndicator(0, 50.0, null);
        this.indicators[1].setStyle(new IlvStyle(1.1f, (Paint)Color.RED.darker()));
        this.indicators[2] = new IlvDataIndicator(0, new IlvDataInterval(this.levelIndicators[1], 100.0), null);
        this.indicators[2].setStyle(new IlvStyle(p2));
        for (int i2 = 0; i2 < this.indicators.length; ++i2) {
            chart.addDecoration(this.indicators[i2]);
        }
        this.refresh();
        chart.addRenderer(this.renderer);
    }

    @Override
    public void detach() {
        if (this.chart != null) {
            this.chart.removeRenderer(this.renderer);
            for (int i2 = 0; i2 < this.indicators.length; ++i2) {
                this.chart.removeDecoration(this.indicators[i2]);
            }
            this.renderer.getDataSource().setDataSets(null);
            this.renderer = null;
            this.indicators = null;
        }
        super.detach();
    }

    @Override
    public void setColor(Color[] color) {
        this.renderer.setStyle(0, IlvStyle.createStroked(color[0]));
    }

    @Override
    public void setCfg(Object cfg) {
        if (cfg instanceof int[]) {
            int[] vals = (int[])cfg;
            this.levelIndicators[0] = vals[0];
            this.levelIndicators[1] = vals[1];
            this.rsiDataSet.setPeriod(vals[2]);
            this.indicators[0].setRange(new IlvDataInterval(0.0, this.levelIndicators[0]));
            this.indicators[2].setRange(new IlvDataInterval(this.levelIndicators[1], 100.0));
        }
    }

    @Override
    public void refresh() {
        IlvDataSet priceDataSet = this.stockDS.getCloseDataSet();
        if (priceDataSet == null) {
            this.rsiDataSet.setDataSets(null);
            this.renderer.getDataSource().setDataSets(null);
        } else {
            this.rsiDataSet.setDataSets(new IlvDataSet[]{priceDataSet});
            if (this.renderer.getDataSource().getDataSetCount() == 0) {
                this.renderer.getDataSource().addDataSet(this.rsiDataSet);
            }
        }
    }

    @Override
    public IlvDisplayPoint getHighlightedPoint(int dataIdx) {
        if (this.renderer != null && this.rsiDataSet.getDataCount() > 0) {
            return this.renderer.getDisplayPoint(this.rsiDataSet, dataIdx);
        }
        return null;
    }

    @Override
    public String getName() {
        return "RSI";
    }

    @Override
    public IlvDataSet getMainDataSet() {
        return this.rsiDataSet;
    }
}

