/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.custscales;

import java.util.Calendar;
import java.util.Date;

public abstract class StockQueryRange {
    public static final StockQueryRange[] RANGES = new StockQueryRange[]{new Month(1), new Month(2), new Month(3), new Month(6), new Year(1), new Year(2), new Year(3), new Year(5), new Year(10)};

    public abstract Date[] getRange();

    private static class Year
    extends StockQueryRange {
        private int yearCount;

        Year(int yearCount) {
            this.yearCount = yearCount;
        }

        @Override
        public Date[] getRange() {
            Calendar cal = Calendar.getInstance();
            Date endDate = new Date();
            cal.setTime(endDate);
            cal.add(1, -this.yearCount);
            return new Date[]{cal.getTime(), endDate};
        }

        public String toString() {
            return this.yearCount + " Year" + (this.yearCount > 1 ? "s" : "");
        }
    }

    private static class Month
    extends StockQueryRange {
        private int monthCount;

        Month(int monthCount) {
            this.monthCount = monthCount;
        }

        @Override
        public Date[] getRange() {
            Calendar cal = Calendar.getInstance();
            Date endDate = new Date();
            cal.setTime(endDate);
            cal.add(2, -this.monthCount);
            cal.add(6, -1);
            return new Date[]{cal.getTime(), endDate};
        }

        public String toString() {
            return this.monthCount + " Month" + (this.monthCount > 1 ? "s" : "");
        }
    }
}

