/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.custscales;

import ilog.views.chart.IlvAxisTransformer;
import ilog.views.chart.IlvAxisTransformerException;
import ilog.views.chart.IlvDataInterval;

public class ExponentAxisTransformer
extends IlvAxisTransformer {
    private double exponent;
    private double exponentInv;

    public ExponentAxisTransformer(double exponent) {
        this.setExponent(exponent);
    }

    public void setExponent(double exponent) {
        if (exponent == 0.0) {
            throw new IllegalArgumentException("Exponent cannot be zero");
        }
        if (exponent == this.exponent) {
            return;
        }
        this.exponent = exponent;
        this.exponentInv = 1.0 / exponent;
        this.transformerChanged();
    }

    @Override
    public double apply(double value) throws IlvAxisTransformerException {
        return Math.pow(value, this.exponent);
    }

    @Override
    public double inverse(double value) throws IlvAxisTransformerException {
        return Math.pow(value, this.exponentInv);
    }

    @Override
    public boolean validateInterval(IlvDataInterval itv) {
        boolean modified = false;
        if (itv.getMin() < 0.0) {
            itv.setMin(0.0);
            modified = true;
        }
        if (itv.getMax() < 0.0) {
            itv.setMax(0.0);
            modified = true;
        }
        return modified;
    }
}

