/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.custindicator;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.event.ChartHighlightInteractionEvent;
import ilog.views.chart.event.ChartInteractionEvent;
import ilog.views.chart.event.ChartInteractionListener;
import java.awt.Color;
import java.util.LinkedHashMap;
import javax.swing.JLabel;
import leaseLineQuote.candle.control.HKIndexCode;
import leaseLineQuote.candle.datasource.StockDataSource;
import leaseLineQuote.candle.graph.ChartColors;
import leaseLineQuote.candle.graph.core.CandlePanel;
import leaseLineQuote.candle.graph.core.LowerDataStatusControl;
import leaseLineQuote.candle.graph.core.QuoteDisplayPanel;
import leaseLineQuote.candle.graph.core.UpperDataStatusControl;
import leaseLineQuote.candle.graph.custindicator.HighlightIndicator;
import leaseLineQuote.candle.graph.indicator.TechnicalIndicator;
import leaseLineQuote.candle.graph.indicator.VolumeIndicator;

public class Highlighter
implements ChartInteractionListener,
ChartColors {
    private HighlightIndicator upperHighlight;
    private HighlightIndicator[] lowerHighlights;
    private CandlePanel stockDemo = CandlePanel.getInstance();
    private IlvChartRenderer overviewRenderer;
    private StockDataSource stockDS;
    private TechnicalIndicator[] lowerIndicators;
    private TechnicalIndicator[] upperIndicators;
    private IlvChart mainChart = this.stockDemo.getMainChart();
    private IlvChart[] lowerCharts = this.stockDemo.getLowerCharts();
    private QuoteDisplayPanel quoteDisplay;

    public Highlighter() {
        this.stockDS = this.stockDemo.getStockDataSource();
        this.lowerIndicators = this.stockDemo.getLowerIndicators();
        this.quoteDisplay = this.stockDemo.getQuoteDisplayPanel();
        this.upperHighlight = this.createHighlightIndicator();
        this.mainChart.addDecoration(this.upperHighlight);
        int count = this.lowerCharts.length;
        this.lowerHighlights = new HighlightIndicator[count];
        for (int i2 = 0; i2 < count; ++i2) {
            this.lowerHighlights[i2] = this.createHighlightIndicator();
            this.lowerCharts[i2].addDecoration(this.lowerHighlights[i2]);
        }
    }

    @Override
    public void interactionPerformed(ChartInteractionEvent evt) {
        ChartHighlightInteractionEvent hevt = (ChartHighlightInteractionEvent)evt;
        if (hevt.isHighlighted()) {
            IlvDisplayPoint idp = hevt.getDisplayPoint();
            this.highlight(idp);
        } else {
            this.unhighlight();
        }
    }

    private void highlight(IlvDisplayPoint hdp) {
        IlvDataSet closeDataSet;
        LowerDataStatusControl hsc = LowerDataStatusControl.getInstance();
        UpperDataStatusControl usc = UpperDataStatusControl.getInstance();
        this.lowerIndicators = this.stockDemo.getLowerIndicators();
        this.upperIndicators = this.stockDemo.getUpperIndicators();
        int hdpIdx = hdp.getIndex();
        for (int i2 = 0; i2 < this.upperIndicators.length; ++i2) {
            LinkedHashMap dataMap = this.upperIndicators[i2].getDisplayPointMap(hdpIdx);
            if (dataMap == null) continue;
            usc.setDatasToLabels(dataMap);
        }
        this.overviewRenderer = this.stockDemo.getOverviewRenderer();
        String symbol = this.stockDS.getSymbol();
        boolean isIndice = false;
        try {
            int code = Integer.parseInt(symbol);
            if (HKIndexCode.isCode(symbol)) {
                isIndice = true;
            }
        }
        catch (Exception e2) {
            isIndice = true;
        }
        if (this.overviewRenderer.isVisible() && (hdp = this.overviewRenderer.getDisplayPoint(closeDataSet = this.stockDS.getCloseDataSet(), hdpIdx)) == null) {
            return;
        }
        this.upperHighlight.setHighlightedPoint(hdp);
        if (this.lowerIndicators.length >= this.lowerHighlights.length) {
            for (int i3 = 0; i3 < this.lowerHighlights.length; ++i3) {
                LinkedHashMap dataMap;
                IlvDisplayPoint idp = this.lowerIndicators[i3].getHighlightedPoint(hdpIdx);
                this.lowerHighlights[i3].setHighlightedPoint(idp);
                if (idp == null) {
                    this.lowerHighlights[i3].setValue(hdp.getXData());
                    if (this.lowerHighlights[i3].isVisible()) continue;
                    this.lowerHighlights[i3].setVisible(true);
                    continue;
                }
                this.lowerHighlights[i3].setVisible(true);
                if (this.lowerIndicators[i3] instanceof VolumeIndicator) {
                    if (isIndice) {
                        ((VolumeIndicator)this.lowerIndicators[i3]).setName("Turnover");
                    } else {
                        ((VolumeIndicator)this.lowerIndicators[i3]).setName("Volume");
                    }
                }
                if ((dataMap = this.lowerIndicators[i3].getDisplayPointMap(hdpIdx)) == null) continue;
                hsc.setDatasToLabels(isIndice, i3, dataMap);
            }
        }
        this.quoteDisplay.displayQuote(hdp);
    }

    private static JLabel getHighlightStatus(IlvChart chart) {
        return (JLabel)chart.getClientProperty("HIGHLIGHT_STATUS_KEY");
    }

    public void unhighlight() {
        this.upperHighlight.setHighlightedPoint(null);
        for (int i2 = 0; i2 < this.lowerHighlights.length; ++i2) {
            JLabel status;
            this.lowerHighlights[i2].setHighlightedPoint(null);
            if (this.lowerHighlights[i2].isVisible()) {
                this.lowerHighlights[i2].setVisible(false);
            }
            if ((status = Highlighter.getHighlightStatus(this.lowerCharts[i2])) == null) continue;
            status.setText("");
        }
        this.quoteDisplay.displayQuote(null);
    }

    private HighlightIndicator createHighlightIndicator() {
        HighlightIndicator indic = new HighlightIndicator(-1);
        indic.setDrawOrder(2);
        indic.setColor(Color.white);
        indic.setVisible(false);
        return indic;
    }
}

