/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.custindicator;

import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.graphic.IlvDataIndicator;
import ilog.views.chart.graphic.IlvMarker;
import ilog.views.chart.graphic.IlvMarkerFactory;
import ilog.views.chart.renderer.IlvHiLoChartRenderer;
import ilog.views.chart.util.IlvGraphicUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import leaseLineQuote.candle.graph.ChartColors;

public class HighlightIndicator
extends IlvDataIndicator {
    private int makerSize = 2;
    private IlvMarker marker;
    private boolean showingBounds;
    protected IlvDisplayPoint dp = null;
    private IlvStyle markerStyle;
    private IlvStyle boundsStyle;

    public HighlightIndicator(int axisIdx) {
        super(axisIdx, 0.0, null);
        this.setVisible(false);
        this.marker = IlvMarkerFactory.getCircleMarker();
    }

    public void setHighlightMarker(IlvMarker marker, int size) {
        this.marker = marker;
        this.makerSize = size;
        if (this.getChart() != null && this.isVisible()) {
            this.getChart().getChartArea().repaint();
        }
    }

    public void setShowingBounds(boolean showing) {
        this.showingBounds = showing;
    }

    public void setColor(Color c2) {
        this.markerStyle = new IlvStyle(Color.black, (Paint)c2);
        this.boundsStyle = new IlvStyle(Color.black, (Paint)c2);
        this.setStyle(IlvStyle.createStroked(ChartColors.CROSS_FOREGROUND));
    }

    public void setHighlightedPoint(IlvDisplayPoint dp) {
        if (dp == this.dp) {
            return;
        }
        IlvDisplayPoint olddp = this.dp;
        if (dp != null) {
            this.dp = dp;
            if (this.getAxisIndex() == -1) {
                this.setValue(dp.getXData());
            } else {
                this.setValue(dp.getYData());
            }
            if (olddp == null) {
                this.setVisible(true);
            }
        } else {
            this.setVisible(false);
            this.dp = dp;
        }
    }

    @Override
    public void draw(Graphics g2) {
        super.draw(g2);
        if (this.dp != null) {
            // empty if block
        }
    }

    protected void drawMark(Graphics g2) {
        if (this.marker != null) {
            IlvStyle s2 = this.markerStyle == null ? this.getStyle() : this.markerStyle;
            this.marker.draw(g2, IlvGraphicUtil.toInt(this.dp.getXCoord()), IlvGraphicUtil.toInt(this.dp.getYCoord()), this.makerSize, s2);
        }
    }

    @Override
    public Rectangle2D getBounds(Rectangle2D retBounds) {
        Rectangle2D bounds = super.getBounds(retBounds);
        if (this.dp != null) {
            IlvGraphicUtil.grow(bounds, this.makerSize, this.makerSize);
        }
        return bounds;
    }

    private Rectangle2D addMarkBounds(Rectangle2D bounds) {
        IlvDataSet ds;
        int idx = this.dp.getIndex();
        IlvHiLoChartRenderer renderer = (IlvHiLoChartRenderer)this.dp.getRenderer().getParent();
        IlvChartRenderer child = renderer.getChild(ds = renderer.getDataSource().getDataSet(3));
        if (child != null) {
            Rectangle2D rect = child.getBounds(ds, idx, idx, null, false);
            IlvGraphicUtil.addToRect(bounds, rect);
        }
        return bounds;
    }
}

