/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.core;

import ilog.views.chart.IlvDisplayPoint;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import leaseLineQuote.candle.control.HKIndexCode;
import leaseLineQuote.candle.datasource.StockDataSource;
import leaseLineQuote.candle.graph.ChartColors;
import leaseLineQuote.candle.graph.core.CandlePanel;

public class QuoteDisplayPanel
extends JPanel
implements ChartColors {
    JLabel date;
    JLabel high;
    JLabel low;
    JLabel open;
    JLabel close;
    private CandlePanel stockDemo = CandlePanel.getInstance();
    private StockDataSource stockDS = this.stockDemo.getStockDataSource();
    private static final Font DEFAULT_FONT = new Font("Dialog", 0, 10);

    public QuoteDisplayPanel() {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        Box box = Box.createHorizontalBox();
        this.setOpaque(false);
        box.add(this.createNameLabel("Date"));
        this.date = this.createLabel(95);
        box.add(this.date);
        box.add(this.createNameLabel("Open"));
        this.open = this.createLabel(60);
        box.add(this.open);
        box.add(this.createNameLabel("High"));
        this.high = this.createLabel(60);
        box.add(this.high);
        box.add(this.createNameLabel("Low"));
        this.low = this.createLabel(60);
        box.add(this.low);
        box.add(this.createNameLabel("Close"));
        this.close = this.createLabel(60);
        box.add(this.close);
        this.add(box);
    }

    public void displayQuote(IlvDisplayPoint dp) {
        if (this.stockDS.getDataSetCount() >= 4 && dp != null) {
            int idx = dp.getIndex();
            if (this.stockDS.getIntervalUnit() == 3) {
                this.date.setText(CandlePanel.dateTimeFmt.format(this.stockDS.getDate(idx)));
            } else {
                this.date.setText(CandlePanel.dateFmt.format(this.stockDS.getDate(idx)));
            }
            double vol = this.stockDS.getVolumeDataSet().getYData(idx);
            if (vol == -1.0) {
                this.open.setText(CandlePanel.numFmt.format(0L));
                this.high.setText(CandlePanel.numFmt.format(0L));
                this.low.setText(CandlePanel.numFmt.format(0L));
                double val = this.stockDS.getCloseDataSet().getYData(idx);
                this.close.setText(CandlePanel.numFmt.format(val));
            } else if (!HKIndexCode.isCode(this.stockDS.getSymbol()) && vol == 0.0) {
                double val = this.stockDS.getCloseDataSet().getYData(idx);
                this.open.setText(CandlePanel.numFmt.format(val));
                this.high.setText(CandlePanel.numFmt.format(val));
                this.low.setText(CandlePanel.numFmt.format(val));
                this.close.setText(CandlePanel.numFmt.format(val));
            } else {
                double val = this.stockDS.getOpenDataSet().getYData(idx);
                this.open.setText(CandlePanel.numFmt.format(val));
                val = this.stockDS.getHighDataSet().getYData(idx);
                this.high.setText(CandlePanel.numFmt.format(val));
                val = this.stockDS.getLowDataSet().getYData(idx);
                this.low.setText(CandlePanel.numFmt.format(val));
                val = this.stockDS.getCloseDataSet().getYData(idx);
                this.close.setText(CandlePanel.numFmt.format(val));
            }
        }
    }

    public void reset() {
        this.date.setText("0");
        this.open.setText("0");
        this.close.setText("0");
        this.high.setText("0");
        this.low.setText("0");
    }

    private JLabel createLabel_bak() {
        JLabel status = new JLabel("0", 4);
        status.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        status.setFont(DEFAULT_FONT);
        Dimension size = status.getPreferredSize();
        size.width = 95;
        status.setPreferredSize(size);
        status.setMinimumSize(size);
        status.setMaximumSize(size);
        status.setForeground(FIXEDLABEL_FOREGROUND);
        status.setBackground(FIXEDLABEL_BACKGROUND);
        status.setOpaque(true);
        return status;
    }

    private JLabel createLabel(int width) {
        JLabel status = new JLabel("0", 4);
        status.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        status.setFont(DEFAULT_FONT);
        Dimension size = status.getPreferredSize();
        size.width = width;
        status.setPreferredSize(size);
        status.setMinimumSize(size);
        status.setMaximumSize(size);
        status.setForeground(FIXEDLABEL_FOREGROUND);
        status.setBackground(FIXEDLABEL_BACKGROUND);
        status.setOpaque(true);
        return status;
    }

    private JLabel createNameLabel(String name) {
        JLabel nameLbl = new JLabel(name, 4);
        nameLbl.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 4));
        nameLbl.setFont(DEFAULT_FONT);
        nameLbl.setForeground(FIXEDLABEL_FOREGROUND);
        nameLbl.setOpaque(false);
        return nameLbl;
    }
}

