/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.cfgpanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import leaseLineQuote.ColorButton;
import leaseLineQuote.IntegerTextField;
import leaseLineQuote.StyledFont;
import leaseLineQuote.UserProfile;
import leaseLineQuote.candle.CandleNewFrame;
import leaseLineQuote.candle.cfgpanel.CandleConfigFrame;
import leaseLineQuote.candle.cfgpanel.CfgPanel;
import leaseLineQuote.candle.graph.ControlInterface;

public class WrCfgPanel
extends JPanel
implements CfgPanel {
    private WrLineCfg lcfgWr;
    private static WrCfgPanel wrCfgPanel;
    private CandleConfigFrame parentFrame;
    private int chartIdx;
    private ControlInterface ctrInf;

    private WrCfgPanel(CandleConfigFrame parentFrame) {
        this.parentFrame = parentFrame;
        this.createPanel();
    }

    public static WrCfgPanel getInstance(CandleConfigFrame parentFrame) {
        if (wrCfgPanel == null) {
            wrCfgPanel = new WrCfgPanel(parentFrame);
        }
        return wrCfgPanel;
    }

    @Override
    public String getKey() {
        return "WR";
    }

    public void createPanel() {
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.lcfgWr = new WrLineCfg(Color.ORANGE.darker(), 20, 10, this.parentFrame);
        this.lcfgWr.add(this);
    }

    public void setChinese() {
        this.lcfgWr.setChinese("\u5a01\u5ec9\u6307\u6a19\uff1a");
    }

    public void setEnglish() {
        this.lcfgWr.setEnglish("Williams'%R: ");
    }

    @Override
    public void unshowLines() {
        this.ctrInf = CandleNewFrame.getControlInterface();
        this.ctrInf.removeLowerIndicators(this.chartIdx, "WR", 0);
    }

    @Override
    public void showLines(int chartIdx) {
        this.ctrInf = CandleNewFrame.getControlInterface();
        this.chartIdx = chartIdx;
        this.ctrInf.createLowerIndicators(chartIdx, "WR", 0, new Color[]{this.lcfgWr.getColor()}, new int[]{this.lcfgWr.getTypeVal()});
    }

    @Override
    public void processConfirm() {
        this.processSetting();
        this.storeSetting();
    }

    private void processSetting() {
        this.ctrInf = CandleNewFrame.getControlInterface();
        this.ctrInf.setLowerIndicatorsCfg(this.chartIdx, "WR", 0, new int[]{this.lcfgWr.getTypeVal()});
        this.ctrInf.setLowerIndicatorsColor(this.chartIdx, "WR", 0, new Color[]{this.lcfgWr.getColor()});
    }

    private void storeSetting() {
        this.lcfgWr.storeSetting();
    }

    public void loadSetting() {
        this.lcfgWr.loadSetting();
        this.processSetting();
    }

    public class WrLineCfg {
        private JLabel lblType;
        private IntegerTextField input;
        private JLabel lblColor;
        private ColorButton btnColor;
        private int typeVal;

        public WrLineCfg(Color color, int typeVal, int y, JFrame parentFrame) {
            this.typeVal = typeVal;
            this.lblType = new JLabel("Williams'%R: ");
            this.lblType.setBounds(new Rectangle(5, y, 110, 16));
            this.lblType.setForeground(Color.black);
            this.lblType.setFont(StyledFont.PLAINFONT);
            this.input = new IntegerTextField(3);
            this.input.setBounds(new Rectangle(110, y - 3, 33, 23));
            this.input.setText(String.valueOf(this.typeVal));
            this.lblColor = new JLabel("Color :");
            this.lblColor.setBounds(new Rectangle(165, y, 50, 16));
            this.lblColor.setForeground(Color.black);
            this.lblColor.setFont(StyledFont.PLAINFONT);
            this.btnColor = new ColorButton(color, parentFrame);
            this.btnColor.setBounds(new Rectangle(215, y + 3, 10, 10));
        }

        public Color getColor() {
            return this.btnColor.getColor();
        }

        public int getTypeVal() {
            return this.input.getValue();
        }

        public void setChinese(String type) {
            this.lblType.setText(type);
            this.lblType.setFont(StyledFont.PLAIN_CHINESE);
            this.lblColor.setText("\u8272\u5f69\uff1a");
            this.lblColor.setFont(StyledFont.PLAIN_CHINESE);
        }

        public void setEnglish(String type) {
            this.lblType.setText(type);
            this.lblType.setFont(StyledFont.PLAINFONT);
            this.lblColor.setText("Color: ");
            this.lblColor.setFont(StyledFont.PLAINFONT);
        }

        public void add(JPanel p2) {
            p2.add((Component)this.lblType, null);
            p2.add((Component)this.input, null);
            p2.add((Component)this.lblColor, null);
            p2.add((Component)this.btnColor, null);
        }

        private void storeSetting() {
            UserProfile.put((Object)"WrLineCfg:typeVal", (Object)new Integer(this.typeVal));
            UserProfile.put((Object)"WrLineCfg:color", (Object)this.btnColor.getColor());
        }

        private void loadSetting() {
            Integer typeVal = (Integer)UserProfile.get((Object)"WrLineCfg:typeVal");
            Color color = (Color)UserProfile.get((Object)"WrLineCfg:color");
            if (typeVal != null && color != null) {
                this.input.setText(typeVal.toString());
                this.btnColor.setBackground(color);
            }
        }
    }
}

