/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.swing.layout;

import ilog.views.util.swing.layout.IlvTableLayoutConstants;
import ilog.views.util.swing.layout.IlvTableLayoutConstraints;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.ListIterator;

public class IlvTableLayout
implements LayoutManager2,
Serializable,
IlvTableLayoutConstants {
    protected static final double[][] defaultSize = new double[][]{new double[0], new double[0]};
    protected double[] columnSpec;
    protected double[] rowSpec;
    protected int[] columnSize;
    protected int[] rowSize;
    protected int[] columnOffset;
    protected int[] rowOffset;
    protected LinkedList list;
    protected boolean dirty;
    protected int oldWidth;
    protected int oldHeight;

    public IlvTableLayout() {
        this(defaultSize);
    }

    public IlvTableLayout(double[][] dArray) {
        if (dArray != null && dArray.length == 2) {
            int n2;
            double[] dArray2 = dArray[0];
            double[] dArray3 = dArray[1];
            this.columnSpec = new double[dArray2.length];
            this.rowSpec = new double[dArray3.length];
            System.arraycopy(dArray2, 0, this.columnSpec, 0, this.columnSpec.length);
            System.arraycopy(dArray3, 0, this.rowSpec, 0, this.rowSpec.length);
            for (n2 = 0; n2 < this.columnSpec.length; ++n2) {
                if (!(this.columnSpec[n2] < 0.0) || this.columnSpec[n2] == -1.0 || this.columnSpec[n2] == -2.0 || this.columnSpec[n2] == -3.0) continue;
                this.columnSpec[n2] = 0.0;
            }
            for (n2 = 0; n2 < this.rowSpec.length; ++n2) {
                if (!(this.rowSpec[n2] < 0.0) || this.rowSpec[n2] == -1.0 || this.rowSpec[n2] == -2.0 || this.rowSpec[n2] == -3.0) continue;
                this.rowSpec[n2] = 0.0;
            }
        } else {
            double[] dArray4 = new double[]{-1.0};
            double[] dArray5 = new double[]{-1.0};
            this.setColumn(dArray4);
            this.setRow(dArray5);
        }
        this.list = new LinkedList();
        this.dirty = true;
    }

    public IlvTableLayoutConstraints getConstraints(Component component) {
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.component != component) continue;
            return new IlvTableLayoutConstraints(entry.col1, entry.row1, entry.col2, entry.row2, entry.hAlign, entry.vAlign);
        }
        return null;
    }

    public void setConstraints(Component component, IlvTableLayoutConstraints ilvTableLayoutConstraints) {
        if (component == null) {
            throw new IllegalArgumentException("Parameter component cannot be null.");
        }
        if (ilvTableLayoutConstraints == null) {
            throw new IllegalArgumentException("Parameter constraint cannot be null.");
        }
        ListIterator<Entry> listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.component != component) continue;
            listIterator.set(new Entry(component, ilvTableLayoutConstraints));
        }
    }

    public void setColumn(double[] dArray) {
        this.columnSpec = new double[dArray.length];
        System.arraycopy(dArray, 0, this.columnSpec, 0, this.columnSpec.length);
        for (int i2 = 0; i2 < this.columnSpec.length; ++i2) {
            if (!(this.columnSpec[i2] < 0.0) || this.columnSpec[i2] == -1.0 || this.columnSpec[i2] == -2.0 || this.columnSpec[i2] == -3.0) continue;
            this.columnSpec[i2] = 0.0;
        }
        this.dirty = true;
    }

    public void setRow(double[] dArray) {
        this.rowSpec = new double[dArray.length];
        System.arraycopy(dArray, 0, this.rowSpec, 0, this.rowSpec.length);
        for (int i2 = 0; i2 < this.rowSpec.length; ++i2) {
            if (!(this.rowSpec[i2] < 0.0) || this.rowSpec[i2] == -1.0 || this.rowSpec[i2] == -2.0 || this.rowSpec[i2] == -3.0) continue;
            this.rowSpec[i2] = 0.0;
        }
        this.dirty = true;
    }

    public void setColumn(int n2, double d2) {
        if (d2 < 0.0 && d2 != -1.0 && d2 != -2.0 && d2 != -3.0) {
            d2 = 0.0;
        }
        this.columnSpec[n2] = d2;
        this.dirty = true;
    }

    public void setRow(int n2, double d2) {
        if (d2 < 0.0 && d2 != -1.0 && d2 != -2.0 && d2 != -3.0) {
            d2 = 0.0;
        }
        this.rowSpec[n2] = d2;
        this.dirty = true;
    }

    public double[] getColumn() {
        double[] dArray = new double[this.columnSpec.length];
        System.arraycopy(this.columnSpec, 0, dArray, 0, dArray.length);
        return dArray;
    }

    public double[] getRow() {
        double[] dArray = new double[this.rowSpec.length];
        System.arraycopy(this.rowSpec, 0, dArray, 0, dArray.length);
        return dArray;
    }

    public double getColumn(int n2) {
        return this.columnSpec[n2];
    }

    public double getRow(int n2) {
        return this.rowSpec[n2];
    }

    public int getNumColumn() {
        return this.columnSpec.length;
    }

    public int getNumRow() {
        return this.rowSpec.length;
    }

    public void insertColumn(int n2, double d2) {
        if (n2 < 0 || n2 > this.columnSpec.length) {
            throw new IllegalArgumentException("Parameter i is invalid.  i = " + n2 + ".  Valid range is [0, " + this.columnSpec.length + "].");
        }
        if (d2 < 0.0 && d2 != -1.0 && d2 != -2.0 && d2 != -3.0) {
            d2 = 0.0;
        }
        double[] dArray = new double[this.columnSpec.length + 1];
        System.arraycopy(this.columnSpec, 0, dArray, 0, n2);
        System.arraycopy(this.columnSpec, n2, dArray, n2 + 1, this.columnSpec.length - n2);
        dArray[n2] = d2;
        this.columnSpec = dArray;
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.col1 >= n2) {
                ++entry.col1;
            }
            if (entry.col2 < n2) continue;
            ++entry.col2;
        }
        this.dirty = true;
    }

    public void insertRow(int n2, double d2) {
        if (n2 < 0 || n2 > this.rowSpec.length) {
            throw new IllegalArgumentException("Parameter i is invalid.  i = " + n2 + ".  Valid range is [0, " + this.rowSpec.length + "].");
        }
        if (d2 < 0.0 && d2 != -1.0 && d2 != -2.0 && d2 != -3.0) {
            d2 = 0.0;
        }
        double[] dArray = new double[this.rowSpec.length + 1];
        System.arraycopy(this.rowSpec, 0, dArray, 0, n2);
        System.arraycopy(this.rowSpec, n2, dArray, n2 + 1, this.rowSpec.length - n2);
        dArray[n2] = d2;
        this.rowSpec = dArray;
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.row1 >= n2) {
                ++entry.row1;
            }
            if (entry.row2 < n2) continue;
            ++entry.row2;
        }
        this.dirty = true;
    }

    public void deleteColumn(int n2) {
        if (n2 < 0 || n2 >= this.columnSpec.length) {
            throw new IllegalArgumentException("Parameter i is invalid.  i = " + n2 + ".  Valid range is [0, " + (this.columnSpec.length - 1) + "].");
        }
        double[] dArray = new double[this.columnSpec.length - 1];
        System.arraycopy(this.columnSpec, 0, dArray, 0, n2);
        System.arraycopy(this.columnSpec, n2 + 1, dArray, n2, this.columnSpec.length - n2 - 1);
        this.columnSpec = dArray;
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.col1 >= n2) {
                --entry.col1;
            }
            if (entry.col2 < n2) continue;
            --entry.col2;
        }
        this.dirty = true;
    }

    public void deleteRow(int n2) {
        if (n2 < 0 || n2 >= this.rowSpec.length) {
            throw new IllegalArgumentException("Parameter i is invalid.  i = " + n2 + ".  Valid range is [0, " + (this.rowSpec.length - 1) + "].");
        }
        double[] dArray = new double[this.rowSpec.length - 1];
        System.arraycopy(this.rowSpec, 0, dArray, 0, n2);
        System.arraycopy(this.rowSpec, n2 + 1, dArray, n2, this.rowSpec.length - n2 - 1);
        this.rowSpec = dArray;
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.row1 >= n2) {
                --entry.row1;
            }
            if (entry.row2 < n2) continue;
            --entry.row2;
        }
        this.dirty = true;
    }

    public String toString() {
        int n2;
        String string = "IlvTableLayout {{";
        if (this.columnSpec.length > 0) {
            for (n2 = 0; n2 < this.columnSpec.length - 1; ++n2) {
                string = string + this.columnSpec[n2] + ", ";
            }
            string = string + this.columnSpec[this.columnSpec.length - 1] + "}, {";
        } else {
            string = string + "}, {";
        }
        if (this.rowSpec.length > 0) {
            for (n2 = 0; n2 < this.rowSpec.length - 1; ++n2) {
                string = string + this.rowSpec[n2] + ", ";
            }
            string = string + this.rowSpec[this.rowSpec.length - 1] + "}}";
        } else {
            string = string + "}}";
        }
        return string;
    }

    public void drawGrid(Container container, Graphics graphics) {
        Dimension dimension = container.getSize();
        if (this.dirty || dimension.width != this.oldWidth || dimension.height != this.oldHeight) {
            this.calculateSize(container);
        }
        int n2 = 0;
        for (int i2 = 0; i2 < this.rowSize.length; ++i2) {
            int n3 = 0;
            for (int i3 = 0; i3 < this.columnSize.length; ++i3) {
                Color color = new Color((int)(Math.random() * 1.6777215E7));
                graphics.setColor(color);
                graphics.fillRect(n3, n2, this.columnSize[i3], this.rowSize[i2]);
                n3 += this.columnSize[i3];
            }
            n2 += this.rowSize[i2];
        }
    }

    public boolean hidden() {
        boolean bl = false;
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.row1 >= 0 && entry.col1 >= 0 && entry.row2 <= this.rowSpec.length && entry.col2 <= this.columnSpec.length) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean overlapping() {
        int n2 = this.list.size();
        if (n2 == 0) {
            return false;
        }
        boolean bl = false;
        Entry[] entryArray = this.list.toArray(new Entry[n2]);
        block0: for (int i2 = 1; i2 < n2; ++i2) {
            for (int i3 = i2 - 1; i3 >= 0; --i3) {
                if ((entryArray[i3].col1 < entryArray[i2].col1 || entryArray[i3].col1 > entryArray[i2].col2 || entryArray[i3].row1 < entryArray[i2].row1 || entryArray[i3].row1 > entryArray[i2].row2) && (entryArray[i3].col2 < entryArray[i2].col1 || entryArray[i3].col2 > entryArray[i2].col2 || entryArray[i3].row2 < entryArray[i2].row1 || entryArray[i3].row2 > entryArray[i2].row2)) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    protected void calculateSize(Container container) {
        Dimension dimension;
        int n2;
        Entry entry;
        ListIterator listIterator;
        int n3;
        int n4;
        int n5 = this.columnSpec.length;
        int n6 = this.rowSpec.length;
        this.columnSize = new int[n5];
        this.rowSize = new int[n6];
        Insets insets = container.getInsets();
        Dimension dimension2 = container.getSize();
        int n7 = dimension2.width - insets.left - insets.right;
        int n8 = dimension2.height - insets.top - insets.bottom;
        int n9 = n7;
        int n10 = n8;
        for (n4 = 0; n4 < n5; ++n4) {
            if (!(this.columnSpec[n4] >= 1.0) && this.columnSpec[n4] != 0.0) continue;
            this.columnSize[n4] = (int)(this.columnSpec[n4] + 0.5);
            n9 -= this.columnSize[n4];
        }
        for (n4 = 0; n4 < n6; ++n4) {
            if (!(this.rowSpec[n4] >= 1.0) && this.rowSpec[n4] != 0.0) continue;
            this.rowSize[n4] = (int)(this.rowSpec[n4] + 0.5);
            n10 -= this.rowSize[n4];
        }
        for (n4 = 0; n4 < n5; ++n4) {
            if (this.columnSpec[n4] != -2.0 && this.columnSpec[n4] != -3.0) continue;
            n3 = 0;
            listIterator = this.list.listIterator(0);
            while (listIterator.hasNext()) {
                entry = (Entry)listIterator.next();
                if (entry.col1 != n4 || entry.col2 != n4 || n3 >= (n2 = (dimension = this.columnSpec[n4] == -2.0 ? entry.component.getPreferredSize() : entry.component.getMinimumSize()) == null ? 0 : dimension.width)) continue;
                n3 = n2;
            }
            this.columnSize[n4] = n3;
            n9 -= n3;
        }
        for (n4 = 0; n4 < n6; ++n4) {
            if (this.rowSpec[n4] != -2.0 && this.rowSpec[n4] != -3.0) continue;
            n3 = 0;
            listIterator = this.list.listIterator(0);
            while (listIterator.hasNext()) {
                entry = (Entry)listIterator.next();
                if (entry.row1 != n4 || entry.row2 != n4 || n3 >= (n2 = (dimension = this.rowSpec[n4] == -2.0 ? entry.component.getPreferredSize() : entry.component.getMinimumSize()) == null ? 0 : dimension.height)) continue;
                n3 = n2;
            }
            this.rowSize[n4] = n3;
            n10 -= n3;
        }
        n3 = n9;
        int n11 = n10;
        if (n3 < 0) {
            n3 = 0;
        }
        if (n11 < 0) {
            n11 = 0;
        }
        for (n4 = 0; n4 < n5; ++n4) {
            if (!(this.columnSpec[n4] > 0.0) || !(this.columnSpec[n4] < 1.0)) continue;
            this.columnSize[n4] = (int)(this.columnSpec[n4] * (double)n3 + 0.5);
            n9 -= this.columnSize[n4];
        }
        for (n4 = 0; n4 < n6; ++n4) {
            if (!(this.rowSpec[n4] > 0.0) || !(this.rowSpec[n4] < 1.0)) continue;
            this.rowSize[n4] = (int)(this.rowSpec[n4] * (double)n11 + 0.5);
            n10 -= this.rowSize[n4];
        }
        if (n9 < 0) {
            n9 = 0;
        }
        if (n10 < 0) {
            n10 = 0;
        }
        int n12 = 0;
        int n13 = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            if (this.columnSpec[n4] != -1.0) continue;
            ++n12;
        }
        for (n4 = 0; n4 < n6; ++n4) {
            if (this.rowSpec[n4] != -1.0) continue;
            ++n13;
        }
        n2 = n9;
        int n14 = n10;
        for (n4 = 0; n4 < n5; ++n4) {
            if (this.columnSpec[n4] != -1.0) continue;
            this.columnSize[n4] = n9 / n12;
            n2 -= this.columnSize[n4];
        }
        for (n4 = 0; n4 < n6; ++n4) {
            if (this.rowSpec[n4] != -1.0) continue;
            this.rowSize[n4] = n10 / n13;
            n14 -= this.rowSize[n4];
        }
        for (n4 = n5 - 1; n4 >= 0; --n4) {
            if (this.columnSpec[n4] != -1.0) continue;
            int n15 = n4;
            this.columnSize[n15] = this.columnSize[n15] + n2;
            break;
        }
        for (n4 = n6 - 1; n4 >= 0; --n4) {
            if (this.rowSpec[n4] != -1.0) continue;
            int n16 = n4;
            this.rowSize[n16] = this.rowSize[n16] + n14;
            break;
        }
        this.columnOffset = new int[n5 + 1];
        this.columnOffset[0] = insets.left;
        for (n4 = 0; n4 < n5; ++n4) {
            this.columnOffset[n4 + 1] = this.columnOffset[n4] + this.columnSize[n4];
        }
        this.rowOffset = new int[n6 + 1];
        this.rowOffset[0] = insets.top;
        for (n4 = 0; n4 < n6; ++n4) {
            this.rowOffset[n4 + 1] = this.rowOffset[n4] + this.rowSize[n4];
        }
        this.dirty = false;
        this.oldWidth = n7;
        this.oldHeight = n8;
    }

    public void layoutContainer(Container container) {
        Dimension dimension = container.getSize();
        if (this.dirty || dimension.width != this.oldWidth || dimension.height != this.oldHeight) {
            this.calculateSize(container);
        }
        Component[] componentArray = container.getComponents();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            try {
                int n2;
                int n3;
                int n4;
                int n5;
                ListIterator listIterator = this.list.listIterator(0);
                Entry entry = null;
                while (listIterator.hasNext()) {
                    entry = (Entry)listIterator.next();
                    if (entry.component == componentArray[i2]) break;
                    entry = null;
                }
                if (entry == null) break;
                if (entry.singleCell) {
                    int n6 = 0;
                    int n7 = 0;
                    if (entry.hAlign != 2 || entry.vAlign != 2) {
                        Dimension dimension2 = componentArray[i2].getPreferredSize();
                        n6 = dimension2.width;
                        n7 = dimension2.height;
                    }
                    int n8 = this.columnSize[entry.col1];
                    int n9 = this.rowSize[entry.row1];
                    n5 = entry.hAlign == 2 || n8 < n6 ? n8 : n6;
                    switch (entry.hAlign) {
                        case 0: {
                            n4 = this.columnOffset[entry.col1];
                            break;
                        }
                        case 3: {
                            n4 = this.columnOffset[entry.col1 + 1] - n5;
                            break;
                        }
                        case 1: {
                            n4 = this.columnOffset[entry.col1] + (n8 - n5 >> 1);
                            break;
                        }
                        case 2: {
                            n4 = this.columnOffset[entry.col1];
                            break;
                        }
                        default: {
                            n4 = 0;
                        }
                    }
                    n3 = entry.vAlign == 2 || n9 < n7 ? n9 : n7;
                    switch (entry.vAlign) {
                        case 0: {
                            n2 = this.rowOffset[entry.row1];
                            break;
                        }
                        case 3: {
                            n2 = this.rowOffset[entry.row1 + 1] - n3;
                            break;
                        }
                        case 1: {
                            n2 = this.rowOffset[entry.row1] + (n9 - n3 >> 1);
                            break;
                        }
                        case 2: {
                            n2 = this.rowOffset[entry.row1];
                            break;
                        }
                        default: {
                            n2 = 0;
                            break;
                        }
                    }
                } else {
                    n4 = this.columnOffset[entry.col1];
                    n2 = this.rowOffset[entry.row1];
                    n5 = this.columnOffset[entry.col2 + 1] - this.columnOffset[entry.col1];
                    n3 = this.rowOffset[entry.row2 + 1] - this.rowOffset[entry.row1];
                }
                componentArray[i2].setBounds(n4, n2, n5, n3);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        Object object;
        Object object2;
        int n2;
        int n3 = 0;
        int n4 = 0;
        double d2 = 1.0;
        double d3 = 1.0;
        int n5 = 0;
        int n6 = 0;
        for (n2 = 0; n2 < this.columnSpec.length; ++n2) {
            if (this.columnSpec[n2] > 0.0 && this.columnSpec[n2] < 1.0) {
                d2 -= this.columnSpec[n2];
                continue;
            }
            if (this.columnSpec[n2] != -1.0) continue;
            ++n5;
        }
        for (n2 = 0; n2 < this.rowSpec.length; ++n2) {
            if (this.rowSpec[n2] > 0.0 && this.rowSpec[n2] < 1.0) {
                d3 -= this.rowSpec[n2];
                continue;
            }
            if (this.rowSpec[n2] != -1.0) continue;
            ++n6;
        }
        if (n5 > 1) {
            d2 /= (double)n5;
        }
        if (n6 > 1) {
            d3 /= (double)n6;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        int[] nArray = new int[this.columnSpec.length];
        for (n2 = 0; n2 < this.columnSpec.length; ++n2) {
            if (this.columnSpec[n2] != -2.0 && this.columnSpec[n2] != -3.0) continue;
            int n7 = 0;
            ListIterator listIterator = this.list.listIterator(0);
            while (listIterator.hasNext()) {
                int n8;
                object2 = (Entry)listIterator.next();
                if (((IlvTableLayoutConstraints)object2).col1 != n2 || ((IlvTableLayoutConstraints)object2).col2 != n2 || n7 >= (n8 = (object = this.columnSpec[n2] == -2.0 ? ((Entry)object2).component.getPreferredSize() : ((Entry)object2).component.getMinimumSize()) == null ? 0 : ((Dimension)object).width)) continue;
                n7 = n8;
            }
            nArray[n2] = n7;
        }
        int[] nArray2 = new int[this.rowSpec.length];
        for (n2 = 0; n2 < this.rowSpec.length; ++n2) {
            if (this.rowSpec[n2] != -2.0 && this.rowSpec[n2] != -3.0) continue;
            int n9 = 0;
            object2 = this.list.listIterator(0);
            while (object2.hasNext()) {
                Dimension dimension;
                int n10;
                object = (Entry)object2.next();
                if (((IlvTableLayoutConstraints)object).row1 != n2 || ((IlvTableLayoutConstraints)object).row1 != n2 || n9 >= (n10 = (dimension = this.rowSpec[n2] == -2.0 ? ((Entry)object).component.getPreferredSize() : ((Entry)object).component.getMinimumSize()) == null ? 0 : dimension.height)) continue;
                n9 = n10;
            }
            int n11 = n2;
            nArray2[n11] = nArray2[n11] + n9;
        }
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            object2 = (Entry)listIterator.next();
            if (((IlvTableLayoutConstraints)object2).col1 < 0 || ((IlvTableLayoutConstraints)object2).col1 >= this.columnSpec.length || ((IlvTableLayoutConstraints)object2).col2 >= this.columnSpec.length || ((IlvTableLayoutConstraints)object2).row1 < 0 || ((IlvTableLayoutConstraints)object2).row1 >= this.rowSpec.length || ((IlvTableLayoutConstraints)object2).row2 >= this.rowSpec.length) continue;
            Dimension dimension = ((Entry)object2).component.getPreferredSize();
            int n12 = dimension.width;
            int n13 = dimension.height;
            for (n2 = ((IlvTableLayoutConstraints)object2).col1; n2 <= ((IlvTableLayoutConstraints)object2).col2; ++n2) {
                if (this.columnSpec[n2] >= 1.0) {
                    n12 = (int)((double)n12 - this.columnSpec[n2]);
                    continue;
                }
                if (this.columnSpec[n2] != -2.0 && this.columnSpec[n2] != -3.0) continue;
                n12 -= nArray[n2];
            }
            for (n2 = ((IlvTableLayoutConstraints)object2).row1; n2 <= ((IlvTableLayoutConstraints)object2).row2; ++n2) {
                if (this.rowSpec[n2] >= 1.0) {
                    n13 = (int)((double)n13 - this.rowSpec[n2]);
                    continue;
                }
                if (this.rowSpec[n2] != -2.0 && this.rowSpec[n2] != -3.0) continue;
                n13 -= nArray2[n2];
            }
            double d4 = 0.0;
            for (n2 = ((IlvTableLayoutConstraints)object2).col1; n2 <= ((IlvTableLayoutConstraints)object2).col2; ++n2) {
                if (this.columnSpec[n2] > 0.0 && this.columnSpec[n2] < 1.0) {
                    d4 += this.columnSpec[n2];
                    continue;
                }
                if (this.columnSpec[n2] != -1.0 || d2 == 0.0) continue;
                d4 += d2;
            }
            int n14 = d4 == 0.0 ? 0 : (int)((double)n12 / d4 + 0.5);
            if (n3 < n14) {
                n3 = n14;
            }
            double d5 = 0.0;
            for (n2 = ((IlvTableLayoutConstraints)object2).row1; n2 <= ((IlvTableLayoutConstraints)object2).row2; ++n2) {
                if (this.rowSpec[n2] > 0.0 && this.rowSpec[n2] < 1.0) {
                    d5 += this.rowSpec[n2];
                    continue;
                }
                if (this.rowSpec[n2] != -1.0 || d3 == 0.0) continue;
                d5 += d3;
            }
            n14 = d5 == 0.0 ? 0 : (int)((double)n13 / d5 + 0.5);
            if (n4 >= n14) continue;
            n4 = n14;
        }
        int n15 = n3;
        for (n2 = 0; n2 < this.columnSpec.length; ++n2) {
            if (this.columnSpec[n2] >= 1.0) {
                n15 += (int)(this.columnSpec[n2] + 0.5);
                continue;
            }
            if (this.columnSpec[n2] != -2.0 && this.columnSpec[n2] != -3.0) continue;
            n15 += nArray[n2];
        }
        int n16 = n4;
        for (n2 = 0; n2 < this.rowSpec.length; ++n2) {
            if (this.rowSpec[n2] >= 1.0) {
                n16 += (int)(this.rowSpec[n2] + 0.5);
                continue;
            }
            if (this.rowSpec[n2] != -2.0 && this.rowSpec[n2] != -3.0) continue;
            n16 += nArray2[n2];
        }
        Insets insets = container.getInsets();
        return new Dimension(n15 += insets.left + insets.right, n16 += insets.top + insets.bottom);
    }

    public Dimension minimumLayoutSize(Container container) {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = false;
        double d2 = 1.0;
        double d3 = 1.0;
        int n6 = 0;
        int n7 = 0;
        for (n3 = 0; n3 < this.columnSpec.length; ++n3) {
            if (this.columnSpec[n3] > 0.0 && this.columnSpec[n3] < 1.0) {
                d2 -= this.columnSpec[n3];
                continue;
            }
            if (this.columnSpec[n3] != -1.0) continue;
            ++n6;
        }
        for (n3 = 0; n3 < this.rowSpec.length; ++n3) {
            if (this.rowSpec[n3] > 0.0 && this.rowSpec[n3] < 1.0) {
                d3 -= this.rowSpec[n3];
                continue;
            }
            if (this.rowSpec[n3] != -1.0) continue;
            ++n7;
        }
        if (n6 > 1) {
            d2 /= (double)n6;
        }
        if (n7 > 1) {
            d3 /= (double)n7;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.col1 < 0 || entry.col1 >= this.columnSpec.length || entry.col2 >= this.columnSpec.length || entry.row1 < 0 || entry.row1 >= this.rowSpec.length || entry.row2 >= this.rowSpec.length) continue;
            Dimension dimension = entry.component.getMinimumSize();
            n2 = dimension.width;
            int n8 = dimension.height;
            for (n3 = entry.col1; n3 <= entry.col2; ++n3) {
                if (!(this.columnSpec[n3] >= 1.0)) continue;
                n2 = (int)((double)n2 - this.columnSpec[n3]);
            }
            for (n3 = entry.row1; n3 <= entry.row2; ++n3) {
                if (!(this.rowSpec[n3] >= 1.0)) continue;
                n8 = (int)((double)n8 - this.rowSpec[n3]);
            }
            double d4 = 0.0;
            for (n3 = entry.col1; n3 <= entry.col2; ++n3) {
                if (this.columnSpec[n3] > 0.0 && this.columnSpec[n3] < 1.0) {
                    d4 += this.columnSpec[n3];
                    continue;
                }
                if (this.columnSpec[n3] != -1.0 || d2 == 0.0) continue;
                d4 += d2;
            }
            int n9 = d4 == 0.0 ? 0 : (int)((double)n2 / d4 + 0.5);
            if (n4 < n9) {
                n4 = n9;
            }
            double d5 = 0.0;
            for (n3 = entry.row1; n3 <= entry.row2; ++n3) {
                if (this.rowSpec[n3] > 0.0 && this.rowSpec[n3] < 1.0) {
                    d5 += this.rowSpec[n3];
                    continue;
                }
                if (this.rowSpec[n3] != -1.0 || d3 == 0.0) continue;
                d5 += d3;
            }
            n9 = d5 == 0.0 ? 0 : (int)((double)n8 / d5 + 0.5);
            if (n5 >= n9) continue;
            n5 = n9;
        }
        int n10 = n4;
        for (n3 = 0; n3 < this.columnSpec.length; ++n3) {
            if (this.columnSpec[n3] >= 1.0) {
                n10 += (int)(this.columnSpec[n3] + 0.5);
                continue;
            }
            if (this.columnSpec[n3] != -2.0 && this.columnSpec[n3] != -3.0) continue;
            n2 = 0;
            listIterator = this.list.listIterator(0);
            while (listIterator.hasNext()) {
                Dimension dimension;
                int n11;
                Entry entry = (Entry)listIterator.next();
                if (entry.col1 != n3 || entry.col2 != n3 || n2 >= (n11 = (dimension = this.columnSpec[n3] == -2.0 ? entry.component.getPreferredSize() : entry.component.getMinimumSize()) == null ? 0 : dimension.width)) continue;
                n2 = n11;
            }
            n10 += n2;
        }
        n2 = n5;
        for (n3 = 0; n3 < this.rowSpec.length; ++n3) {
            if (this.rowSpec[n3] >= 1.0) {
                n2 += (int)(this.rowSpec[n3] + 0.5);
                continue;
            }
            if (this.rowSpec[n3] != -2.0 && this.rowSpec[n3] != -3.0) continue;
            int n12 = 0;
            listIterator = this.list.listIterator(0);
            while (listIterator.hasNext()) {
                Dimension dimension;
                int n13;
                Entry entry = (Entry)listIterator.next();
                if (entry.row1 != n3 || entry.row1 != n3 || n12 >= (n13 = (dimension = this.rowSpec[n3] == -2.0 ? entry.component.getPreferredSize() : entry.component.getMinimumSize()) == null ? 0 : dimension.height)) continue;
                n12 = n13;
            }
            n2 += n12;
        }
        Insets insets = container.getInsets();
        return new Dimension(n10 += insets.left + insets.right, n2 += insets.top + insets.bottom);
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, string);
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof String) {
            object = new IlvTableLayoutConstraints((String)object);
            this.list.add(new Entry(component, (IlvTableLayoutConstraints)object));
        } else if (object instanceof IlvTableLayoutConstraints) {
            this.list.add(new Entry(component, (IlvTableLayoutConstraints)object));
        } else {
            if (object == null) {
                throw new IllegalArgumentException("No constraint for the component");
            }
            throw new IllegalArgumentException("Cannot accept a constraint of class " + object.getClass());
        }
    }

    public void removeLayoutComponent(Component component) {
        this.list.remove(component);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
        this.dirty = true;
    }

    class Entry
    extends IlvTableLayoutConstraints {
        protected Component component;
        protected boolean singleCell;

        public Entry(Component component, IlvTableLayoutConstraints ilvTableLayoutConstraints) {
            super(ilvTableLayoutConstraints.col1, ilvTableLayoutConstraints.row1, ilvTableLayoutConstraints.col2, ilvTableLayoutConstraints.row2, ilvTableLayoutConstraints.hAlign, ilvTableLayoutConstraints.vAlign);
            this.singleCell = this.row1 == this.row2 && this.col1 == this.col2;
            this.component = component;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof Component) {
                Component component = (Component)object;
                bl = this.component == component;
            }
            return bl;
        }
    }
}

