/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.css.parser;

import ilog.views.util.css.IlvCSSDocument;
import ilog.views.util.css.parser.Rule;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class Declaration
implements Serializable {
    public String _source = null;
    public String _target = null;
    private IlvCSSDocument a;
    public String _loadedTarget;
    public int _documentLine;

    public static Declaration copy(Declaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException("null declaration to copy");
        }
        Declaration declaration2 = new Declaration();
        declaration2._source = declaration._source;
        declaration2._target = declaration._target;
        declaration2.a = declaration.a;
        declaration2._loadedTarget = declaration._loadedTarget;
        declaration2._documentLine = declaration._documentLine;
        return declaration2;
    }

    public IlvCSSDocument getDocument() {
        if (this.a == null) {
            throw new RuntimeException("null document for declaration " + this);
        }
        return this.a;
    }

    public String getSource() {
        return this._source;
    }

    public void setSource(String string) {
        this._source = string;
    }

    public String getTarget() {
        return this._target;
    }

    public void setTarget(String string) {
        this._target = string;
    }

    public void setDocument(IlvCSSDocument ilvCSSDocument) {
        this.a = ilvCSSDocument;
    }

    public URL getDocumentPath() {
        return this.a == null ? null : this.a.getURL();
    }

    public void setDocumentPath(URL uRL) {
        if (this.getDocument() == null) {
            this.a = new IlvCSSDocument();
        }
        this.a.setURL(uRL);
    }

    public void print(PrintStream printStream, int n2) {
        Rule.a(printStream, n2);
        printStream.print("{" + this._source + " -> " + this._target + "} ");
    }

    public void printCSS(PrintWriter printWriter, int n2) {
        this.printCSS(printWriter, n2, null);
    }

    public void printCSS(PrintWriter printWriter, int n2, IlvCSSDocument ilvCSSDocument) {
        Rule.a(printWriter, n2);
        if (this._loadedTarget != null && this._loadedTarget.startsWith("url(")) {
            if (ilvCSSDocument == null || ilvCSSDocument.getURL() == null) {
                printWriter.println(this._source + " : \"url(" + Rule.quote(this._target) + ")\" ;");
            } else {
                printWriter.println(this._source + " : \"url(" + Declaration.a(this._target, ilvCSSDocument.getURL()) + ")\" ;");
            }
        } else {
            printWriter.println(this._source + " : \"" + Rule.quote(this._target) + "\" ;");
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Declaration)) {
            return false;
        }
        Declaration declaration = (Declaration)object;
        return this._source.equals(declaration._source) && this._target.equals(declaration._target);
    }

    public int hashCode() {
        return this._source.hashCode() ^ this._target.hashCode() * 31;
    }

    private static String a(String string, URL uRL) {
        URL uRL2 = null;
        if (string == null) {
            throw new NullPointerException("content url must not be null.");
        }
        if (uRL == null) {
            throw new NullPointerException("baseURL must not be null.");
        }
        try {
            uRL2 = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("bad url." + string);
        }
        if (Declaration.a(uRL2, uRL)) {
            List list = Declaration.a(uRL2.getPath());
            List list2 = Declaration.a(uRL.getPath());
            String string2 = uRL2.getQuery();
            String string3 = uRL2.getRef();
            if (!uRL.getPath().endsWith("/")) {
                list2.remove(list2.size() - 1);
            }
            if (uRL2.equals(uRL)) {
                return (String)list.get(list.size() - 1);
            }
            int n2 = Declaration.a(list, list2);
            if (n2 == 0) {
                return uRL2.toExternalForm();
            }
            if (n2 == list.size()) {
                --n2;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            int n3 = list2.size() - n2;
            for (int i2 = 0; i2 < n3; ++i2) {
                arrayList.add("..");
            }
            arrayList.addAll(list.subList(n2, list.size()));
            return Declaration.a(arrayList, string3, string2);
        }
        return uRL2.toExternalForm();
    }

    private static boolean a(URL uRL, URL uRL2) {
        if (!uRL.getProtocol().equals(uRL2.getProtocol())) {
            return false;
        }
        if (!uRL.getHost().equals(uRL2.getHost())) {
            return false;
        }
        return uRL.getPort() == uRL2.getPort();
    }

    private static List a(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (string2.length() == 0) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private static int a(List list, List list2) {
        int n2 = Math.min(list2.size(), list.size());
        for (int i2 = 0; i2 < n2; ++i2) {
            String string;
            String string2 = (String)list.get(i2);
            if (string2.equals(string = (String)list2.get(i2))) continue;
            return i2;
        }
        return n2;
    }

    private static String a(List list, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append("/");
        }
        if (string != null) {
            stringBuffer.append('#');
            stringBuffer.append(string);
        }
        if (string2 != null) {
            stringBuffer.append('?');
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static void unitTest() {
        try {
            URL uRL = new URL("http://wombat.ilog.fr/root/foo/file.css");
            String string = "http://wombat.ilog.fr/root/foo/data/image.svg";
            Declaration.a(uRL, string, "data/image.svg");
            Declaration.a(uRL, "http://wombat.ilog.fr/root/foo/data/image.svg#toto", "data/image.svg#toto");
            Declaration.a(uRL, "http://wombat.ilog.fr/root/foo/data/image.svg?toto", "data/image.svg?toto");
            Declaration.a(uRL, "http://wombat.ilog.fr/root/foo/data/image.svg#foo?toto", "data/image.svg#foo?toto");
            Declaration.a(uRL, "http://wombat.ilog.fr/root/foo/data/image.svg?foo#toto", "data/image.svg#toto?foo");
            Declaration.a(uRL, "http://wombat.ilog.fr:80/root/foo/data/image.svg", "http://wombat.ilog.fr:80/root/foo/data/image.svg");
            Declaration.a(uRL, "http://wombat.ilog.fr/root/foo/image.svg", "image.svg");
            uRL = new URL("http://wombat.ilog.fr/root/foo/");
            Declaration.a(uRL, "http://wombat.ilog.fr/root/foo/image.svg", "image.svg");
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Bad URL test", malformedURLException);
        }
    }

    private static void a(URL uRL, String string, String string2) {
        if (!string2.equals(Declaration.a(string, uRL))) {
            throw new RuntimeException("Didn't create correct relative URL " + string2);
        }
    }
}

