/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.css;

import ilog.views.util.css.IlvCSSDocument;
import ilog.views.util.css.IlvCSSModel;
import ilog.views.util.css.parser.Attribute;
import ilog.views.util.css.parser.Declaration;
import ilog.views.util.css.parser.Element;
import ilog.views.util.css.parser.Parser;
import ilog.views.util.css.parser.Rule;
import ilog.views.util.styling.IlvStylingException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class IlvCSSEngine
implements Serializable {
    private Rule[] a;
    private boolean b;
    private URL[] c;
    private URL d;
    private AttributeHandler e;
    private HashMap f = new HashMap();
    static final Object[] g = new Object[0];
    private Rule h;
    public static final String DISABLED_METADATA = "__DISABLED";
    private RuleFilter i = new RuleFilter(){

        public Rule[] filterRules(Rule[] ruleArray) {
            if (ruleArray != null) {
                for (int i2 = 0; i2 < ruleArray.length; ++i2) {
                    Rule rule = ruleArray[i2];
                    String string = this.a(rule);
                    if (string == null) continue;
                    rule.setDisabledGroup(Long.parseLong(string));
                }
            }
            return ruleArray;
        }

        private String a(Rule rule) {
            if (rule == null) {
                return null;
            }
            boolean bl = true;
            Declaration[] declarationArray = rule.getMetadata();
            if (declarationArray == null) {
                declarationArray = rule.getDeclarations();
                bl = false;
            }
            if (declarationArray == null) {
                return null;
            }
            for (int i2 = 0; i2 < declarationArray.length; ++i2) {
                Declaration declaration = declarationArray[i2];
                if (!IlvCSSEngine.DISABLED_METADATA.equals(declaration._source)) continue;
                boolean bl2 = !"0".equals(declaration._target);
                Declaration[] declarationArray2 = new Declaration[declarationArray.length - 1];
                if (i2 > 0) {
                    System.arraycopy(declarationArray, 0, declarationArray2, 0, i2);
                }
                if (i2 < declarationArray.length - 1) {
                    System.arraycopy(declarationArray, i2 + 1, declarationArray2, i2, declarationArray.length - i2 - 1);
                }
                if (bl) {
                    rule.setMetadata(declarationArray2);
                } else {
                    rule.setDeclarations(declarationArray2);
                }
                return bl2 ? declaration._target : null;
            }
            return null;
        }
    };
    private RuleFilter j = null;

    public IlvCSSEngine(Reader reader) throws IlvStylingException {
        this(reader, null, null);
    }

    public IlvCSSEngine(Reader reader, URL uRL) throws IlvStylingException {
        this(reader, uRL, null);
    }

    public IlvCSSEngine(Reader reader, URL uRL, URL[] uRLArray) throws IlvStylingException {
        this(reader, new IlvCSSDocument(uRL, uRLArray));
    }

    public IlvCSSEngine(Reader reader, IlvCSSDocument ilvCSSDocument) throws IlvStylingException {
        Parser parser = new Parser(reader, ilvCSSDocument);
        ilvCSSDocument = parser.getCSSDocument();
        this.c = ilvCSSDocument.getURLpath();
        this.a = this.a(parser.parse());
        this.b = parser.hasHierarchicalSelectors();
        this.d = ilvCSSDocument.getBaseURL();
        this.setAttributeHandler(null);
    }

    public URL[] getBaseURLPath() {
        return this.c;
    }

    public URL getBaseURL() {
        return this.d;
    }

    public void setRuleFilter(RuleFilter ruleFilter) {
        this.j = ruleFilter;
    }

    public RuleFilter getRuleFilter() {
        return this.j;
    }

    public AttributeHandler getAttributeHandler() {
        return this.e;
    }

    public void setAttributeHandler(AttributeHandler attributeHandler) {
        this.e = attributeHandler;
        if (this.e == null) {
            this.e = new AttributeHandler(){

                public Object computeValue(IlvCSSModel ilvCSSModel, Object object, String string) {
                    return ilvCSSModel.getValue(object, string);
                }

                public int evaluate(IlvCSSModel ilvCSSModel, Object object, Attribute attribute) {
                    return -1;
                }
            };
        }
    }

    public void clear() {
        this.a = null;
        this.b = false;
    }

    public void setBaseURLPath(URL[] uRLArray) {
        this.c = uRLArray;
    }

    public void cascadeWith(Reader reader, URL uRL) throws IlvStylingException {
        IlvCSSDocument ilvCSSDocument = new IlvCSSDocument(uRL, this.c);
        this.cascadeWith(reader, ilvCSSDocument);
    }

    public void cascadeWith(Reader reader, IlvCSSDocument ilvCSSDocument) throws IlvStylingException {
        Parser parser = new Parser(reader, ilvCSSDocument);
        Rule[] ruleArray = this.a(parser.parse());
        this.b |= parser.hasHierarchicalSelectors();
        if (ruleArray == null) {
            return;
        }
        if (this.a == null) {
            this.a = ruleArray;
            return;
        }
        Rule[] ruleArray2 = new Rule[ruleArray.length + this.a.length];
        System.arraycopy(this.a, 0, ruleArray2, 0, this.a.length);
        System.arraycopy(ruleArray, 0, ruleArray2, this.a.length, ruleArray.length);
        Arrays.sort(ruleArray2, Rule.getComparator());
        this.a = ruleArray2;
    }

    public void cascadeWith(Reader reader, URL uRL, boolean bl) throws IlvStylingException {
        this.cascadeWith(reader, uRL);
    }

    public boolean hasHierarchicalSelectors() {
        return this.b;
    }

    public CSSrules applyCSStoModel(IlvCSSModel ilvCSSModel, Object object) {
        return this.applyCSStoModel(ilvCSSModel, object, ilvCSSModel);
    }

    public CSSrules applyCSStoModel(IlvCSSModel ilvCSSModel, Object object, IlvCSSModel ilvCSSModel2) {
        Hashtable hashtable = new Hashtable();
        this.a(ilvCSSModel2 == null ? ilvCSSModel : ilvCSSModel2, object, hashtable);
        return new CSSrules(hashtable, ilvCSSModel, object);
    }

    private synchronized void a(IlvCSSModel ilvCSSModel, Object object, Map map) {
        AppliedRule appliedRule;
        this.a(map, ilvCSSModel, object);
        AppliedRuleList appliedRuleList = this.a(this.a, ilvCSSModel, object);
        this.f.clear();
        AppliedRule appliedRule2 = appliedRule = appliedRuleList == null ? null : appliedRuleList.a;
        while (appliedRule != null) {
            AppliedRule appliedRule3 = appliedRule.d;
            Object v = map.get(appliedRule.a);
            if (v == null) {
                map.put(appliedRule.a, new AppliedRuleList(appliedRule));
            } else {
                ((AppliedRuleList)v).addLast(appliedRule);
            }
            appliedRule = appliedRule3;
        }
    }

    private void a(Map map, IlvCSSModel ilvCSSModel, Object object) {
        if (object != null) {
            map.remove(object);
        }
        Object[] objectArray = ilvCSSModel.getChildrenAsArray(object);
        this.f.put(object, objectArray);
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                this.a(map, ilvCSSModel, objectArray[i2]);
            }
        }
    }

    public static Map findDeclarations(CSSrules cSSrules, Object object) {
        return IlvCSSEngine.findDeclarations(cSSrules, object, null, null);
    }

    public static Map findDeclarations(CSSrules cSSrules, Object object, String[] stringArray, Map hashtable) {
        if (cSSrules != null) {
            if (hashtable == null) {
                hashtable = new Hashtable(7);
            }
            return IlvCSSEngine.a(cSSrules.a, object, stringArray, hashtable);
        }
        throw new IllegalArgumentException("null rule argument for " + object);
    }

    public static Map findDebugDeclarations(CSSrules cSSrules, Object object, String[] stringArray, Map hashMap) {
        if (cSSrules != null) {
            if (hashMap == null) {
                hashMap = new HashMap(7);
            }
            return IlvCSSEngine.b(cSSrules.a, object, stringArray, hashMap);
        }
        throw new IllegalArgumentException("null rule argument for " + object);
    }

    public static Collection findDebugRules(CSSrules cSSrules, Object object, String[] stringArray, Collection arrayList) {
        if (cSSrules != null) {
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            return IlvCSSEngine.a(cSSrules.a, object, stringArray, arrayList);
        }
        throw new IllegalArgumentException("null rule argument for " + object);
    }

    public void printCSS(PrintWriter printWriter) {
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            this.a[i2].printCSS(printWriter);
            printWriter.println();
        }
    }

    public void printCSS(PrintWriter printWriter, IlvCSSDocument ilvCSSDocument) {
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            this.a[i2].printCSS(printWriter, ilvCSSDocument);
            printWriter.println();
        }
    }

    public Rule[] getRules() {
        return this.getRules(false);
    }

    public Rule[] getRules(boolean bl) {
        if (!bl && this.a != null) {
            int n2 = 0;
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                if (!this.a[i2].isDisabled()) continue;
                ++n2;
            }
            if (n2 > 0) {
                Rule[] ruleArray = new Rule[this.a.length - n2];
                n2 = 0;
                for (int i3 = 0; i3 < this.a.length; ++i3) {
                    if (this.a[i3].isDisabled()) continue;
                    ruleArray[n2++] = this.a[i3];
                }
                return ruleArray;
            }
        }
        return this.a;
    }

    public synchronized void setRules(Rule[] ruleArray) {
        Arrays.sort(ruleArray, Rule.getComparator());
        this.b = false;
        for (int i2 = 0; i2 < ruleArray.length; ++i2) {
            Rule rule = ruleArray[i2];
            Element[] elementArray = rule.getElements();
            if (elementArray.length <= 1) continue;
            this.b = true;
            break;
        }
        this.a = ruleArray;
    }

    private static Map a(Map map, Object object, String[] stringArray, Map map2) {
        AppliedRuleList appliedRuleList = (AppliedRuleList)map.get(object);
        if (appliedRuleList == null) {
            return map2;
        }
        AppliedRule appliedRule = appliedRuleList.a;
        while (appliedRule != null) {
            if (IlvCSSEngine.a(stringArray, appliedRule.getPseudos())) {
                Declaration[] declarationArray = appliedRule.getDeclarations();
                for (int i2 = 0; i2 < declarationArray.length; ++i2) {
                    map2.put(declarationArray[i2]._source, declarationArray[i2]._target);
                }
            }
            appliedRule = appliedRule.d;
        }
        return map2;
    }

    private static Map b(Map map, Object object, String[] stringArray, Map map2) {
        AppliedRuleList appliedRuleList = (AppliedRuleList)map.get(object);
        if (appliedRuleList == null) {
            return map2;
        }
        AppliedRule appliedRule = appliedRuleList.a;
        while (appliedRule != null) {
            if (IlvCSSEngine.a(stringArray, appliedRule.getPseudos())) {
                Declaration[] declarationArray = appliedRule.getDeclarations();
                for (int i2 = 0; i2 < declarationArray.length; ++i2) {
                    map2.put(declarationArray[i2]._source, declarationArray[i2]);
                }
            }
            appliedRule = appliedRule.d;
        }
        return map2;
    }

    private static Collection a(Map map, Object object, String[] stringArray, Collection collection) {
        AppliedRuleList appliedRuleList = (AppliedRuleList)map.get(object);
        if (appliedRuleList == null) {
            return collection;
        }
        AppliedRule appliedRule = appliedRuleList.a;
        while (appliedRule != null) {
            if (IlvCSSEngine.a(stringArray, appliedRule.getPseudos())) {
                collection.add(appliedRule.b);
            }
            appliedRule = appliedRule.d;
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppliedRuleList a(Rule[] ruleArray, IlvCSSModel ilvCSSModel, Object object) {
        AppliedRuleList appliedRuleList = null;
        try {
            for (int i2 = 0; i2 < ruleArray.length; ++i2) {
                this.h = ruleArray[i2];
                if (this.h.isDisabled()) continue;
                appliedRuleList = this.a(appliedRuleList, this.h, ilvCSSModel, object);
            }
        }
        finally {
            this.h = null;
        }
        return appliedRuleList;
    }

    public Rule getCurrentRule() {
        return this.h;
    }

    private AppliedRuleList a(AppliedRuleList appliedRuleList, Rule rule, IlvCSSModel ilvCSSModel, Object object) {
        return this.a(appliedRuleList, rule, rule.getElements(), 0, ilvCSSModel, object, null);
    }

    private AppliedRuleList a(AppliedRuleList appliedRuleList, Rule rule, Element[] elementArray, int n2, IlvCSSModel ilvCSSModel, Object object, Object object2) {
        Object object3;
        int n3;
        Element element = elementArray[n2];
        Object[] objectArray = this.a(object);
        if (objectArray == null) {
            objectArray = g;
        }
        if (element.getPreviousTransition() == 0) {
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                appliedRuleList = this.a(appliedRuleList, rule, elementArray, n2, ilvCSSModel, objectArray[n3], object);
            }
        }
        if (!this.a(element, ilvCSSModel, object)) {
            return appliedRuleList;
        }
        if (n2 == elementArray.length - 1) {
            return this.a(appliedRuleList, rule, object);
        }
        if (elementArray[n2 + 1].getPreviousTransition() == 2 && (object3 = this.a(object2, object)) != null) {
            return this.a(appliedRuleList, rule, elementArray, n2 + 1, ilvCSSModel, object3, object2);
        }
        if (objectArray.length == 0) {
            return appliedRuleList;
        }
        for (n3 = 0; n3 < objectArray.length; ++n3) {
            appliedRuleList = this.a(appliedRuleList, rule, elementArray, n2 + 1, ilvCSSModel, objectArray[n3], object);
        }
        return appliedRuleList;
    }

    private Object[] a(Object object) {
        return (Object[])this.f.get(object);
    }

    private Object a(Object object, Object object2) {
        if (object == null) {
            return null;
        }
        Object[] objectArray = this.a(object);
        if (objectArray == null) {
            return null;
        }
        for (int i2 = 0; i2 < objectArray.length - 1; ++i2) {
            if (objectArray[i2] != object2) continue;
            return objectArray[i2 + 1];
        }
        return null;
    }

    private AppliedRuleList a(AppliedRuleList appliedRuleList, Rule rule, Object object) {
        AppliedRule appliedRule = new AppliedRule(object, rule);
        if (appliedRuleList == null) {
            return new AppliedRuleList(appliedRule);
        }
        appliedRuleList.addLast(appliedRule);
        return appliedRuleList;
    }

    private boolean a(Element element, IlvCSSModel ilvCSSModel, Object object) {
        try {
            String string = element.getType();
            if (element.getID() != null && !element.getID().equals(ilvCSSModel.getID(object)) || string != null && string != "*" && !this.a(ilvCSSModel, object, string)) {
                return false;
            }
            if (element.getCSSclasses().length > 0) {
                String string2 = ilvCSSModel.getCSSclasses(object);
                if (!this.a(element.getCSSclasses(), string2)) {
                    return false;
                }
            }
            boolean bl = true;
            Attribute[] attributeArray = element.getAttributes();
            for (int i2 = 0; i2 < attributeArray.length; ++i2) {
                if (this.a(ilvCSSModel, attributeArray[i2], object)) continue;
                bl = false;
                break;
            }
            return bl;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private boolean a(IlvCSSModel ilvCSSModel, Object object, String string) {
        String string2 = ilvCSSModel.getType(object);
        return string2 == null ? false : string.equals(string2);
    }

    private boolean a(String[] stringArray, String string) {
        if (string == null) {
            return stringArray.length == 0;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            boolean bl = false;
            String string2 = stringArray[i2];
            int n3 = string2.length();
            for (int i3 = 0; i3 < n2; ++i3) {
                if (string.charAt(i3) == ' ') continue;
                int n4 = string.indexOf(32, i3 + 1);
                if (n4 < 0) {
                    n4 = n2;
                }
                if (n4 - i3 == n3 && string2.regionMatches(0, string, i3, n3)) {
                    bl = true;
                    break;
                }
                i3 = n4;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private static boolean a(String[] stringArray, String[] stringArray2) {
        if (stringArray2.length == 0) {
            return true;
        }
        if (stringArray == null) {
            return false;
        }
        boolean bl = true;
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            bl = false;
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                if (!stringArray2[i2].equals(stringArray[i3])) continue;
                bl = true;
                break;
            }
            if (!bl) break;
        }
        return bl;
    }

    private boolean a(IlvCSSModel ilvCSSModel, Attribute attribute, Object object) {
        int n2 = this.e.evaluate(ilvCSSModel, object, attribute);
        if (n2 != -1) {
            return n2 == 1;
        }
        Object object2 = this.e.computeValue(ilvCSSModel, object, attribute._root);
        if (object2 == null) {
            return (attribute._match == 1 || attribute._match == 7) && attribute._target.length() == 0;
        }
        if (attribute._match == 0) {
            return !Boolean.FALSE.equals(object2);
        }
        switch (attribute._match) {
            case 1: {
                return attribute._target.equals(object2.toString());
            }
            case 9: {
                return !attribute._target.equals(object2.toString());
            }
            case 2: {
                return object2.toString().indexOf(attribute._target) != -1;
            }
        }
        try {
            if (object2 instanceof Long) {
                Long l2 = (Long)object2;
                if (attribute._targetL == null) {
                    attribute._targetL = Long.valueOf(attribute._target);
                }
                n2 = l2.compareTo(attribute._targetL);
            } else {
                Double d2 = null;
                d2 = object2 instanceof Double ? (Double)object2 : (object2 instanceof Number ? new Double(((Number)object2).doubleValue()) : Double.valueOf(object2.toString()));
                if (attribute._targetD == null) {
                    attribute._targetD = Double.valueOf(attribute._target);
                }
                n2 = d2.compareTo(attribute._targetD);
            }
            return IlvCSSEngine.resolvAttributeComparator(n2, attribute);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean resolvAttributeComparator(int n2, Attribute attribute) {
        if (n2 == 0) {
            return attribute._match == 4 || attribute._match == 7 || attribute._match == 6;
        }
        if (n2 < 0) {
            return attribute._match == 5 || attribute._match == 6 || attribute._match == 8;
        }
        return attribute._match == 3 || attribute._match == 4 || attribute._match == 8;
    }

    private Rule[] a(Rule[] ruleArray) {
        if (this.j != null) {
            return this.j.filterRules(this.i.filterRules(ruleArray));
        }
        return this.i.filterRules(ruleArray);
    }

    public static interface RuleFilter {
        public Rule[] filterRules(Rule[] var1);
    }

    public static interface AttributeHandler {
        public static final int MATCHING_OK = 1;
        public static final int MATCHING_FAILED = 0;
        public static final int MATCHING_DEFERRED = -1;

        public Object computeValue(IlvCSSModel var1, Object var2, String var3);

        public int evaluate(IlvCSSModel var1, Object var2, Attribute var3);
    }

    private class AppliedRule
    implements Serializable {
        Object a;
        Rule b;
        String[] c;
        AppliedRule d;

        public AppliedRule(Object object, Rule rule) {
            this.a = object;
            this.b = rule;
            this.c = rule.getPseudos();
        }

        public String[] getPseudos() {
            return this.c;
        }

        public Declaration[] getDeclarations() {
            return this.b.getDeclarations();
        }

        public void print(PrintStream printStream) {
            printStream.print(this.a);
            String[] stringArray = this.getPseudos();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                printStream.print(":" + stringArray[i2]);
            }
            Declaration[] declarationArray = this.getDeclarations();
            for (int i3 = 0; i3 < declarationArray.length; ++i3) {
                declarationArray[i3].print(printStream, 0);
            }
        }
    }

    private class AppliedRuleList {
        AppliedRule a;
        AppliedRule b;

        public AppliedRuleList(AppliedRule appliedRule) {
            this.a = appliedRule;
            this.b = appliedRule;
            appliedRule.d = null;
        }

        public final void addLast(AppliedRule appliedRule) {
            this.b.d = appliedRule;
            this.b = appliedRule;
            appliedRule.d = null;
        }
    }

    public class CSSrules
    implements Serializable {
        Map a;
        IlvCSSModel b;
        Object c;

        CSSrules(Map map, IlvCSSModel ilvCSSModel, Object object) {
            this.a = map;
            this.c = object;
            this.b = ilvCSSModel;
        }

        public IlvCSSModel getModel() {
            return this.b;
        }

        public Object getRoot() {
            return this.c;
        }

        public IlvCSSEngine getEngine() {
            return IlvCSSEngine.this;
        }

        public boolean hasHierarchicalSelectors() {
            return this.getEngine().hasHierarchicalSelectors();
        }

        public Map findDeclarations(Object object, String[] stringArray, Map map) {
            return IlvCSSEngine.findDeclarations(this, object, stringArray, map);
        }

        public Map findDeclarations(Object object) {
            return IlvCSSEngine.findDeclarations(this, object);
        }

        public void update(IlvCSSModel ilvCSSModel, Object object) {
            this.update(ilvCSSModel, object, ilvCSSModel);
        }

        public void update(IlvCSSModel ilvCSSModel, Object object, IlvCSSModel ilvCSSModel2) {
            this.b = ilvCSSModel;
            IlvCSSEngine.this.a(ilvCSSModel2, object, this.a);
        }

        public void clear() {
            this.a.clear();
        }

        public boolean isEmpty() {
            return this.a.isEmpty();
        }

        public void remove(Object object) {
            this.a.remove(object);
        }

        public boolean containsKey(Object object) {
            return this.a.containsKey(object);
        }

        public Set keys() {
            return this.a.keySet();
        }

        public Rule[] getRules(Object object) {
            AppliedRuleList appliedRuleList = (AppliedRuleList)this.a.get(object);
            if (appliedRuleList == null) {
                return new Rule[0];
            }
            int n2 = 0;
            Rule[] ruleArray = appliedRuleList.a;
            while (ruleArray != null) {
                ++n2;
                ruleArray = ruleArray.d;
            }
            ruleArray = new Rule[n2];
            int n3 = 0;
            AppliedRule appliedRule = appliedRuleList.a;
            while (appliedRule != null) {
                ruleArray[n3++] = appliedRule.b;
                appliedRule = appliedRule.d;
            }
            return ruleArray;
        }

        public ArrayList getObjects(Rule rule) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.a.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (entry.getValue() == null) continue;
                AppliedRuleList appliedRuleList = (AppliedRuleList)entry.getValue();
                AppliedRule appliedRule = appliedRuleList.a;
                while (appliedRule != null) {
                    if (appliedRule.b == rule) {
                        arrayList.add(entry.getKey());
                    }
                    appliedRule = appliedRule.d;
                }
            }
            return arrayList;
        }

        public Rule[] getRuleFamily(Rule rule) {
            Serializable serializable;
            Rule[] ruleArray;
            ArrayList<Rule> arrayList = new ArrayList<Rule>();
            ArrayList<Rule> arrayList2 = new ArrayList<Rule>();
            Collection collection = this.a.values();
            Iterator<Object> iterator = collection.iterator();
            block0: while (iterator.hasNext()) {
                ruleArray = (Rule[])iterator.next();
                if (ruleArray == null) continue;
                AppliedRule appliedRule = ruleArray.a;
                while (appliedRule != null) {
                    if (appliedRule.b == rule) {
                        serializable = appliedRule.d;
                        while (serializable != null) {
                            if (!arrayList2.contains(serializable.b)) {
                                arrayList2.add(serializable.b);
                            }
                            serializable = serializable.d;
                        }
                        serializable = ruleArray.a;
                        while (serializable != appliedRule) {
                            if (!arrayList.contains(serializable.b)) {
                                arrayList.add(serializable.b);
                            }
                            serializable = serializable.d;
                        }
                        continue block0;
                    }
                    appliedRule = appliedRule.d;
                }
            }
            ruleArray = new Rule[arrayList.size() + 1 + arrayList2.size()];
            arrayList.toArray(ruleArray);
            ruleArray[arrayList.size()] = rule;
            int n2 = arrayList.size() + 1;
            iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                serializable = (Rule)iterator.next();
                ruleArray[n2++] = serializable;
            }
            Arrays.sort(ruleArray, Rule.getComparator());
            return ruleArray;
        }

        public void print(Object object, PrintStream printStream) {
            if (this.a == null) {
                printStream.println("************  no rule for " + object);
                return;
            }
            AppliedRuleList appliedRuleList = (AppliedRuleList)this.a.get(object);
            if (appliedRuleList == null) {
                printStream.println("************  no matched rule for " + object);
                return;
            }
            printStream.println("************  matched rule for " + object);
            Object object2 = appliedRuleList.a;
            while (object2 != null) {
                object2.print(printStream);
                printStream.println();
                object2 = object2.d;
            }
            object2 = this.b.getChildrenAsArray(object);
            if (object2 != null) {
                for (int i2 = 0; i2 < ((Object[])object2).length; ++i2) {
                    this.print(object2[i2], printStream);
                }
            }
        }
    }
}

