/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.beans.editor;

import ilog.views.util.beans.editor.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class IlvURLStringPropertyEditor
extends JPanel
implements PropertyEditor {
    private String a = null;
    private PropertyChangeSupport b = null;
    protected JTextField textfield;
    private JFileChooser c;
    private FileFilter[] d;

    public IlvURLStringPropertyEditor() {
        this.setLayout(new BorderLayout(0, 0));
        this.b = new PropertyChangeSupport(this);
        try {
            this.textfield = new JTextField(80);
            this.add((Component)new Label(Messages.BUNDLE.getString("URLStringPropertyEditor.EnterURL")), "North");
            this.add((Component)this.textfield, "Center");
            JButton jButton = new JButton("...");
            this.add((Component)jButton, "After");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    FileFilter[] fileFilterArray;
                    File file = null;
                    if (IlvURLStringPropertyEditor.this.getValue() != null) {
                        try {
                            fileFilterArray = new URL(IlvURLStringPropertyEditor.this.getAsText());
                            if (fileFilterArray != null) {
                                file = new File(fileFilterArray.getPath());
                            }
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                    }
                    if (IlvURLStringPropertyEditor.this.c == null) {
                        IlvURLStringPropertyEditor.this.c = new JFileChooser();
                        IlvURLStringPropertyEditor.this.c.setDialogTitle(Messages.BUNDLE.getString("URLStringPropertyEditor.ChooseURL"));
                    }
                    IlvURLStringPropertyEditor.this.c.setSelectedFile(file);
                    fileFilterArray = IlvURLStringPropertyEditor.this.getFileFilters();
                    if (file != null) {
                        IlvURLStringPropertyEditor.this.c.setCurrentDirectory(file.getParentFile());
                        object = file.getPath();
                        int n2 = ((String)object).lastIndexOf(46);
                        if (fileFilterArray == null && n2 != -1 && n2 > ((String)object).lastIndexOf(File.pathSeparatorChar)) {
                            final String string = ((String)object).substring(n2);
                            FileFilter fileFilter = new FileFilter(){

                                public boolean accept(File file) {
                                    return file.isDirectory() || file.getName().endsWith(string);
                                }

                                public String getDescription() {
                                    return string;
                                }
                            };
                            IlvURLStringPropertyEditor.this.c.resetChoosableFileFilters();
                            IlvURLStringPropertyEditor.this.c.addChoosableFileFilter(fileFilter);
                            IlvURLStringPropertyEditor.this.c.setFileFilter(fileFilter);
                        }
                    }
                    if (fileFilterArray != null) {
                        IlvURLStringPropertyEditor.this.c.resetChoosableFileFilters();
                        for (int i2 = 0; i2 < fileFilterArray.length; ++i2) {
                            FileFilter fileFilter = fileFilterArray[i2];
                            IlvURLStringPropertyEditor.this.c.addChoosableFileFilter(fileFilter);
                        }
                        if (fileFilterArray.length > 0) {
                            IlvURLStringPropertyEditor.this.c.setFileFilter(fileFilterArray[0]);
                        }
                    }
                    if (IlvURLStringPropertyEditor.this.c.showOpenDialog(IlvURLStringPropertyEditor.this.textfield) == 0) {
                        object = IlvURLStringPropertyEditor.this.c.getSelectedFile();
                        try {
                            if (object != null) {
                                IlvURLStringPropertyEditor.this.textfield.setText(((File)object).toURL().toExternalForm());
                            }
                        }
                        catch (MalformedURLException malformedURLException) {
                            IlvURLStringPropertyEditor.this.textfield.setText("file:" + ((File)object).toString());
                        }
                    }
                    IlvURLStringPropertyEditor.this.textfield.requestFocus();
                }
            });
            this.textfield.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    try {
                        IlvURLStringPropertyEditor.this.setAsText(IlvURLStringPropertyEditor.this.textfield.getText());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void setFileFilters(FileFilter[] fileFilterArray) {
        this.d = fileFilterArray;
    }

    public FileFilter[] getFileFilters() {
        return this.d;
    }

    public void setValue(Object object) {
        String string = this.a;
        this.a = (String)object;
        this.firePropertyChange(string, this.a);
        if (this.textfield != null) {
            if (this.a != null) {
                this.textfield.setText(this.a.toString());
            } else {
                this.textfield.setText("");
            }
        }
    }

    public Object getValue() {
        return this.a;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public String getJavaInitializationString() {
        int n2;
        if (this.a == null) {
            return "null";
        }
        String string = this.a.toString().trim();
        int n3 = 0;
        while ((n2 = string.indexOf("\\", n3)) != -1) {
            string = string.substring(0, n2) + "\\" + string.substring(n2);
            n3 = n2 + 2;
        }
        return "\"" + string + "\"";
    }

    public String getAsText() {
        if (this.a != null) {
            return this.a.toString();
        }
        return "";
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.setValue(string);
    }

    public String[] getTags() {
        return null;
    }

    public void firePropertyChange(Object object, Object object2) {
        this.b.firePropertyChange(null, object, object2);
    }

    public Component getCustomEditor() {
        if (this.getValue() != null) {
            this.textfield.setText(this.getAsText());
        } else {
            this.textfield.setText("");
        }
        return this;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.b.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.b.removePropertyChangeListener(propertyChangeListener);
    }
}

