/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.servlet;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvDataWindow;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.servlet.IlvChartServerAction;
import ilog.views.chart.servlet.IlvChartServerActionEvent;
import ilog.views.chart.servlet.IlvChartServletSupport;
import ilog.views.chart.servlet.IlvParameterException;
import ilog.views.chart.servlet.IlvServletRequestParameters;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.servlet.ServletException;

public class IlvZoomAction
implements IlvChartServerAction {
    public void actionPerformed(IlvChartServerActionEvent ilvChartServerActionEvent) throws ServletException {
        IlvChart ilvChart = ilvChartServerActionEvent.getChart();
        if (ilvChart == null) {
            return;
        }
        Insets insets = ilvChart.getInsets();
        int n2 = ilvChartServerActionEvent.getIntParameter(0);
        int n3 = ilvChartServerActionEvent.getIntParameter(1);
        int n4 = ilvChartServerActionEvent.getIntParameter(2);
        int n5 = ilvChartServerActionEvent.getIntParameter(3);
        Rectangle rectangle = new Rectangle(n2, n3, n4, n5);
        try {
            rectangle = IlvChartServletSupport.toChartArea(rectangle, new IlvServletRequestParameters(ilvChartServerActionEvent.getRequest()), ilvChartServerActionEvent.getChart());
        }
        catch (IlvParameterException ilvParameterException) {
            throw new ServletException(ilvParameterException.getMessage());
        }
        IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(2);
        ilvDoublePoints.add(rectangle.x, rectangle.y);
        ilvDoublePoints.add(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        ilvChart.toData(ilvDoublePoints);
        double d2 = Math.min(ilvDoublePoints.getX(0), ilvDoublePoints.getX(1));
        double d3 = Math.max(ilvDoublePoints.getX(0), ilvDoublePoints.getX(1));
        double d4 = Math.min(ilvDoublePoints.getY(0), ilvDoublePoints.getY(1));
        double d5 = Math.max(ilvDoublePoints.getY(0), ilvDoublePoints.getY(1));
        ilvDoublePoints.dispose();
        IlvDataWindow ilvDataWindow = new IlvDataWindow(d2, d3, d4, d5);
        this.zoom(ilvChartServerActionEvent, ilvDataWindow);
    }

    protected void zoom(IlvChartServerActionEvent ilvChartServerActionEvent, IlvDataWindow ilvDataWindow) {
        ilvChartServerActionEvent.getChart().zoom(ilvDataWindow, 0);
    }

    public int getExecutionThread() {
        return 1;
    }
}

