/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.servlet;

import ilog.views.chart.servlet.IlvIMapAttributes;
import ilog.views.chart.util.IlvDoubleArray;
import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.chart.util.internal.IlvIntArrayPool;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.PathIterator;

public final class IlvIMapArea {
    private String a;

    public IlvIMapArea(Rectangle rectangle, IlvIMapAttributes ilvIMapAttributes) {
        this.a = IlvIMapArea.createTag(rectangle, ilvIMapAttributes);
    }

    public IlvIMapArea(Polygon polygon, IlvIMapAttributes ilvIMapAttributes) {
        this(polygon.xpoints, polygon.ypoints, polygon.npoints, ilvIMapAttributes);
    }

    IlvIMapArea(Shape shape, IlvIMapAttributes ilvIMapAttributes) {
        this.a = IlvIMapArea.a(shape, 0, 0, ilvIMapAttributes);
    }

    public IlvIMapArea(int[] nArray, int[] nArray2, int n2, IlvIMapAttributes ilvIMapAttributes) {
        this.a = IlvIMapArea.createTag(nArray, nArray2, n2, ilvIMapAttributes);
    }

    public IlvIMapArea(double[] dArray, double[] dArray2, int n2, IlvIMapAttributes ilvIMapAttributes) {
        this.a = IlvIMapArea.createTag(dArray, dArray2, n2, ilvIMapAttributes);
    }

    public IlvIMapArea(int n2, int n3, int n4, IlvIMapAttributes ilvIMapAttributes) {
        this.a = IlvIMapArea.createTag(n2, n3, n4, ilvIMapAttributes);
    }

    public String getTag() {
        return this.a;
    }

    private static void a(StringBuffer stringBuffer, IlvIMapAttributes ilvIMapAttributes) {
        String string = ilvIMapAttributes.getHREF();
        if (string != null) {
            stringBuffer.append(" href=");
            IlvIMapArea.a(stringBuffer, string);
        } else {
            stringBuffer.append(" nohref");
        }
        string = ilvIMapAttributes.getALT();
        if (string != null) {
            stringBuffer.append(" alt=");
            IlvIMapArea.a(stringBuffer, string);
        }
        if ((string = ilvIMapAttributes.getTitle()) != null) {
            stringBuffer.append(" title=");
            IlvIMapArea.a(stringBuffer, string);
        }
        if ((string = ilvIMapAttributes.getTarget()) != null) {
            stringBuffer.append(" target=");
            IlvIMapArea.a(stringBuffer, string);
        }
        if ((string = ilvIMapAttributes.getExtraAttributes()) != null) {
            stringBuffer.append(' ');
            stringBuffer.append(string);
        }
    }

    private static final void a(StringBuffer stringBuffer, String string) {
        stringBuffer.append('\"');
        stringBuffer.append(string);
        stringBuffer.append('\"');
    }

    public static String createTag(Rectangle rectangle, IlvIMapAttributes ilvIMapAttributes) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<area shape=\"rect\" coords=\"");
        stringBuffer.append(rectangle.x);
        stringBuffer.append(",");
        stringBuffer.append(rectangle.y);
        stringBuffer.append(",");
        stringBuffer.append(rectangle.x + rectangle.width);
        stringBuffer.append(",");
        stringBuffer.append(rectangle.y + rectangle.height);
        stringBuffer.append('\"');
        IlvIMapArea.a(stringBuffer, ilvIMapAttributes);
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    public static String createTag(double[] dArray, double[] dArray2, int n2, IlvIMapAttributes ilvIMapAttributes) {
        int[] nArray = IlvIntArrayPool.take(n2);
        int[] nArray2 = IlvIntArrayPool.take(n2);
        n2 = IlvGraphicUtil.doubleToInts(n2, dArray, dArray2, nArray, nArray2, true);
        String string = IlvIMapArea.createTag(nArray, nArray2, n2, ilvIMapAttributes);
        IlvIntArrayPool.release(nArray);
        IlvIntArrayPool.release(nArray2);
        return string;
    }

    public static String createTag(int[] nArray, int[] nArray2, int n2, IlvIMapAttributes ilvIMapAttributes) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<area shape=\"poly\" coords=\"");
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(nArray[i2]);
            stringBuffer.append(",");
            stringBuffer.append(nArray2[i2]);
        }
        if (nArray[0] != nArray[n2 - 1] || nArray2[0] != nArray2[n2 - 1]) {
            stringBuffer.append(",");
            stringBuffer.append(nArray[0]);
            stringBuffer.append(",");
            stringBuffer.append(nArray2[0]);
        }
        stringBuffer.append('\"');
        IlvIMapArea.a(stringBuffer, ilvIMapAttributes);
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    public static String createTag(int n2, int n3, int n4, IlvIMapAttributes ilvIMapAttributes) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<area shape=\"circle\" coords=\"");
        stringBuffer.append(n2);
        stringBuffer.append(",");
        stringBuffer.append(n3);
        stringBuffer.append(",");
        stringBuffer.append(n4);
        stringBuffer.append('\"');
        IlvIMapArea.a(stringBuffer, ilvIMapAttributes);
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    static String a(Shape shape, int n2, int n3, IlvIMapAttributes ilvIMapAttributes) {
        PathIterator pathIterator = shape.getPathIterator(null, 2.0);
        double[] dArray = new double[6];
        IlvDoubleArray ilvDoubleArray = new IlvDoubleArray(16);
        IlvDoubleArray ilvDoubleArray2 = new IlvDoubleArray(16);
        while (!pathIterator.isDone()) {
            int n4 = pathIterator.currentSegment(dArray);
            if (n4 == 0 || n4 == 1) {
                ilvDoubleArray.add(dArray[0] + (double)n2);
                ilvDoubleArray2.add(dArray[1] + (double)n3);
            }
            pathIterator.next();
        }
        return IlvIMapArea.createTag(ilvDoubleArray.data(), ilvDoubleArray2.data(), ilvDoubleArray.size(), ilvIMapAttributes);
    }
}

