/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.renderer;

import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartDataPicker;
import ilog.views.chart.IlvChartProjector;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvColor;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDataWindow;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvDoublePoint;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.IlvLegendItem;
import ilog.views.chart.IlvRendererLegendItem;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.data.IlvDataPoints;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.data.IlvDataSetPoint;
import ilog.views.chart.data.IlvDataSetProperty;
import ilog.views.chart.data.IlvDataSource;
import ilog.views.chart.data.IlvDefaultDataSource;
import ilog.views.chart.event.DataSetContentsEvent;
import ilog.views.chart.event.DataSetListener;
import ilog.views.chart.event.DataSetPropertyEvent;
import ilog.views.chart.graphic.IlvDataAnnotation;
import ilog.views.chart.graphic.IlvDataRenderingHint;
import ilog.views.chart.renderer.IlvDataInfoCollection;
import ilog.views.chart.renderer.IlvDataInfoMap;
import ilog.views.chart.renderer.IlvVirtualDataSet;
import ilog.views.chart.servlet.IlvIMapArea;
import ilog.views.chart.servlet.IlvIMapAttributes;
import ilog.views.chart.servlet.IlvIMapDefinition;
import ilog.views.chart.styling.IlvDataPointStyle;
import ilog.views.chart.styling.IlvDataSetStyle;
import ilog.views.chart.styling.IlvStylingSupport;
import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.chart.util.internal.IlvMathUtil;
import ilog.views.chart.view3d.IlvChart3DObject;
import ilog.views.util.IlvColorUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class IlvSingleChartRenderer
extends IlvChartRenderer {
    private IlvStyle a;
    private Map b;
    private InternalListener c;
    private transient Map d;
    private transient Stroke e;
    private transient IlvStyle f;
    private transient boolean g;

    protected IlvSingleChartRenderer() {
        this(null);
    }

    protected IlvSingleChartRenderer(IlvStyle ilvStyle) {
        this.setStyle(ilvStyle);
        this.c = new InternalListener();
    }

    public boolean isFilled() {
        return true;
    }

    boolean c() {
        return true;
    }

    public void setStyle(IlvStyle ilvStyle) {
        this.a(ilvStyle);
    }

    private void a(IlvStyle ilvStyle) {
        if (ilvStyle == null && this.getChart() != null) {
            ilvStyle = this.makeDefaultStyle();
            this.g = true;
        } else {
            this.g = false;
        }
        this.a = ilvStyle;
        this.triggerChange(4);
    }

    public IlvStyle getStyle() {
        return this.a;
    }

    public void setStyles(IlvStyle[] ilvStyleArray) {
        this.setStyle(ilvStyleArray != null ? ilvStyleArray[0] : null);
    }

    public IlvStyle[] getStyles() {
        IlvStyle[] ilvStyleArray;
        if (this.a == null) {
            ilvStyleArray = new IlvStyle[]{};
        } else {
            IlvStyle[] ilvStyleArray2 = new IlvStyle[1];
            ilvStyleArray = ilvStyleArray2;
            ilvStyleArray2[0] = this.a;
        }
        return ilvStyleArray;
    }

    protected void chartConnected(IlvChart ilvChart, IlvChart ilvChart2) {
        super.chartConnected(ilvChart, ilvChart2);
        if (ilvChart != null) {
            ilvChart.removePropertyChangeListener(this.c);
        }
        if (ilvChart2 != null) {
            ilvChart2.addPropertyChangeListener(this.c);
            if (this.a == null) {
                this.a((IlvStyle)null);
            }
        }
    }

    IlvDataSource d() {
        return new IlvDefaultDataSource();
    }

    static IlvVirtualDataSet a(IlvChartRenderer ilvChartRenderer, IlvDataSet ilvDataSet) {
        if (ilvChartRenderer instanceof IlvSingleChartRenderer) {
            return ((IlvSingleChartRenderer)ilvChartRenderer).a(ilvDataSet);
        }
        return null;
    }

    static void a(IlvChartRenderer ilvChartRenderer, IlvDataSet ilvDataSet, IlvVirtualDataSet ilvVirtualDataSet) {
        if (ilvChartRenderer instanceof IlvSingleChartRenderer) {
            ((IlvSingleChartRenderer)ilvChartRenderer).a(ilvDataSet, ilvVirtualDataSet);
        }
    }

    IlvVirtualDataSet a(IlvDataSet ilvDataSet) {
        return (IlvVirtualDataSet)ilvDataSet.getProperty(this);
    }

    IlvDataSet b(int n2) {
        return this.b(this.getDataSource().getDataSet(n2));
    }

    IlvDataSet b(IlvDataSet ilvDataSet) {
        if (!this.isDisplayingDataSet(ilvDataSet)) {
            return null;
        }
        IlvVirtualDataSet ilvVirtualDataSet = this.a(ilvDataSet);
        return ilvVirtualDataSet == null ? ilvDataSet : ilvVirtualDataSet;
    }

    IlvDataSet e() {
        return this.b(this.getDataSource().getDataSet(0));
    }

    final IlvDataSet f() {
        return this.getDataSource().getDataSet(0);
    }

    int g() {
        return 0;
    }

    Points a(IlvDataPoints ilvDataPoints) {
        return new Points(ilvDataPoints, true);
    }

    void a(Points points) {
        points.b();
    }

    public void toDisplay(IlvDoublePoints ilvDoublePoints) {
        IlvChart ilvChart = this.getChart();
        if (this.j()) {
            double[] dArray;
            double d2 = this.getXShift();
            if (d2 != 0.0) {
                for (int i2 = 0; i2 < ilvDoublePoints.size(); ++i2) {
                    ilvDoublePoints.setX(i2, ilvDoublePoints.getX(i2) + d2);
                }
            }
            double d3 = (dArray = this.getDepths()) == null ? ilvChart.get3DView().getFrontDepth() : (dArray[0] + dArray[1]) / 2.0;
            ilvChart.get3DView().toDisplay(ilvDoublePoints, this.getYAxisIdx(), d3);
        } else {
            super.toDisplay(ilvDoublePoints);
        }
    }

    void a(IlvDoublePoints ilvDoublePoints) {
        IlvChart ilvChart = this.getChart();
        if (ilvChart != null) {
            double d2 = this.getXShift();
            if (d2 != 0.0) {
                for (int i2 = 0; i2 < ilvDoublePoints.size(); ++i2) {
                    ilvDoublePoints.setX(i2, ilvDoublePoints.getX(i2) + d2);
                }
            }
            ilvChart.getProjector2D().toDisplay(ilvDoublePoints, this.getPlotRect(), this.getCoordinateSystem());
        }
    }

    final IlvAxis h() {
        return this.getCoordinateSystem().getYAxis();
    }

    final IlvAxis i() {
        return this.getCoordinateSystem().getXAxis();
    }

    protected void set3D(boolean bl) {
        super.set3D(bl);
        if (!bl && this.d != null) {
            this.d.clear();
        }
    }

    public String getZAnnotationText() {
        return null;
    }

    final boolean j() {
        return this.getChart() != null && this.getChart().is3D() && this.has3DSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map k() {
        if (this.d == null) {
            IlvSingleChartRenderer ilvSingleChartRenderer = this;
            synchronized (ilvSingleChartRenderer) {
                if (this.d == null) {
                    this.d = new HashMap();
                }
            }
        }
        return this.d;
    }

    void a(Map map) {
        this.d = map;
    }

    final IlvChart3DObject c(int n2) {
        return this.d == null ? null : (IlvChart3DObject)this.d.get(new Integer(n2));
    }

    Rectangle2D b(Points points) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        Rectangle2D rectangle2D = null;
        int n2 = points.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvChart3DObject ilvChart3DObject = this.c(points.getDataIndex(i2));
            if (ilvChart3DObject == null) continue;
            rectangle2D = ilvChart3DObject.getBounds2D(rectangle2D);
            IlvGraphicUtil.addToRect(double_, rectangle2D);
        }
        return double_;
    }

    void a(Graphics graphics, Points points) {
        this.a(points, true);
    }

    void a(Points points, boolean bl) {
    }

    IlvDataPoints a(IlvDataSet ilvDataSet, int n2, int n3) {
        int n4 = this.g();
        if (n4 > 0) {
            if ((n2 -= n4) < 0) {
                n2 = 0;
            }
            if ((n3 += n4) > ilvDataSet.getDataCount() - 1) {
                n3 = ilvDataSet.getDataCount() - 1;
            }
        }
        return ilvDataSet.getDataBetween(n2, n3);
    }

    public void draw(Graphics graphics) {
        if (this.j()) {
            this.a(graphics, this.a((Rectangle)null), true);
        } else {
            Shape shape = graphics.getClip();
            Rectangle rectangle = this.getClipRect();
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            Rectangle rectangle2 = this.getChart() != null && !this.getChart().isOptimizedRepaint() ? null : graphics.getClipBounds();
            this.a(graphics, this.a(rectangle2), false);
            graphics.setClip(shape);
        }
    }

    public void draw(Graphics graphics, IlvDataSet ilvDataSet, int n2, int n3) {
        this.a(graphics, this.a(ilvDataSet, n2, n3), this.getChart().is3D());
    }

    void a(Graphics graphics, IlvDataPoints ilvDataPoints, boolean bl) {
        if (ilvDataPoints == null) {
            return;
        }
        Points points = this.a(ilvDataPoints);
        if (points.size() > 0) {
            if (bl) {
                this.a(graphics, points);
            } else {
                this.b(graphics, points);
            }
        }
        this.a(points);
    }

    IlvDataPoints a(Rectangle rectangle) {
        IlvDataWindow ilvDataWindow = null;
        if (rectangle != null) {
            ilvDataWindow = this.c(this.b(rectangle));
            if (ilvDataWindow.isEmpty()) {
                return null;
            }
        } else {
            ilvDataWindow = this.getCoordinateSystem().getVisibleWindow();
        }
        return this.e().getDataInside(ilvDataWindow, this.g(), this.c());
    }

    Rectangle b(Rectangle rectangle) {
        IlvStyle ilvStyle = this.getStyle();
        if (ilvStyle.quickBounds()) {
            ilvStyle.expand(rectangle);
        } else {
            rectangle.setBounds(this.getPlotRect());
        }
        return rectangle;
    }

    IlvDataWindow a(IlvDataWindow ilvDataWindow) {
        return ilvDataWindow;
    }

    IlvDataWindow c(Rectangle rectangle) {
        Rectangle rectangle2 = this.getPlotRect();
        IlvDataWindow ilvDataWindow = this.getChart().getProjector().toDataWindow(rectangle, rectangle2, this.getCoordinateSystem());
        this.a(ilvDataWindow);
        if (this.getXShift() != 0.0) {
            ilvDataWindow.xRange.translate(-this.getXShift());
        }
        ilvDataWindow.xRange.intersection(this.i().getVisibleRange());
        ilvDataWindow.yRange.intersection(this.h().getVisibleRange());
        return ilvDataWindow;
    }

    public Rectangle2D getBounds(IlvDataSet ilvDataSet, int n2, int n3, Rectangle2D rectangle2D) {
        return this.getBounds(ilvDataSet, n2, n3, rectangle2D, true);
    }

    public Rectangle2D getBounds(IlvDataSet ilvDataSet, int n2, int n3, Rectangle2D rectangle2D, boolean bl) {
        Object object;
        Serializable serializable;
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Double();
        } else {
            rectangle2D.setRect(0.0, 0.0, 0.0, 0.0);
        }
        if (this.getChart() == null) {
            return rectangle2D;
        }
        boolean bl2 = this.getChart().is3D();
        if (bl2 && !this.has3DSupport()) {
            return rectangle2D;
        }
        if (ilvDataSet != this.e()) {
            serializable = this.a(ilvDataSet);
            if (serializable != null) {
                object = new IlvDataSetPoint(ilvDataSet, n2);
                IlvDataSetPoint ilvDataSetPoint = new IlvDataSetPoint(ilvDataSet, n3);
                ((IlvVirtualDataSet)serializable).map((IlvDataSetPoint)object);
                ((IlvVirtualDataSet)serializable).map(ilvDataSetPoint);
                ilvDataSet = ((IlvDataSetPoint)object).getDataSet();
                n2 = Math.min(((IlvDataSetPoint)object).getIndex(), ilvDataSetPoint.getIndex());
                n3 = Math.max(((IlvDataSetPoint)object).getIndex(), ilvDataSetPoint.getIndex());
            } else {
                return null;
            }
        }
        if ((serializable = this.a(ilvDataSet, n2, n3)) != null) {
            object = this.a((IlvDataPoints)serializable);
            if (((Points)object).size() > 0) {
                rectangle2D = bl2 ? this.b((Points)object) : this.c((Points)object);
                if (bl && this.n()) {
                    this.a((Points)object, rectangle2D);
                }
            }
            this.a((Points)object);
        }
        return rectangle2D;
    }

    public IlvDisplayPoint getNearestPoint(IlvChartDataPicker ilvChartDataPicker) {
        IlvDataPoints ilvDataPoints;
        if (this.getChart() == null || this.getChart().is3D()) {
            return null;
        }
        int n2 = ilvChartDataPicker.getPickX();
        int n3 = ilvChartDataPicker.getPickY();
        int n4 = ilvChartDataPicker.getPickDistance();
        Rectangle rectangle = null;
        if (n4 >= 0 && n4 < 2000) {
            rectangle = new Rectangle((int)Math.floor(n2 - n4), (int)Math.floor(n3 - n4), 2 * n4, 2 * n4);
        }
        if ((ilvDataPoints = this.a(rectangle)) == null) {
            return null;
        }
        Points points = this.a(ilvDataPoints);
        int n5 = points.size();
        if (n5 == 0) {
            return null;
        }
        int n6 = -1;
        IlvDataSetPoint ilvDataSetPoint = null;
        IlvDataSet ilvDataSet = points.getDataSet();
        Double d2 = ilvDataSet.getUndefValue();
        if (ilvChartDataPicker.useDataSpace()) {
            IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(n2, n3);
            this.toData(ilvDoublePoints);
            double[] dArray = points.getXData();
            double[] dArray2 = points.getYData();
            double d3 = Double.MAX_VALUE;
            for (int i2 = 0; i2 < n5; ++i2) {
                double d4;
                if (d2 != null && dArray2[i2] == d2 || !((d4 = ilvChartDataPicker.computeDistance(ilvDoublePoints.getX(0), ilvDoublePoints.getY(0), dArray[i2], dArray2[i2])) <= d3)) continue;
                n6 = i2;
                if (d4 == 0.0) break;
                d3 = d4;
            }
            if (n6 != -1) {
                ilvDoublePoints.set(0, dArray[n6], dArray2[n6]);
                this.toDisplay(ilvDoublePoints);
                ilvDataSetPoint = new IlvDisplayPoint(this, ilvDataSet, points.getDataIndex(n6), ilvDoublePoints.getX(0), ilvDoublePoints.getY(0));
            }
        } else {
            double[] dArray = points.getXCoords();
            double[] dArray3 = points.getYCoords();
            double[] dArray4 = points.getYData();
            double d5 = n4;
            for (int i3 = 0; i3 < n5; ++i3) {
                double d6;
                if (d2 != null && dArray4[i3] == d2 || !((d6 = ilvChartDataPicker.computeDistance(n2, n3, dArray[i3], dArray3[i3])) <= d5)) continue;
                n6 = i3;
                if (d6 == 0.0) break;
                d5 = d6;
            }
            if (n6 != -1) {
                ilvDataSetPoint = new IlvDisplayPoint(this, ilvDataSet, points.getDataIndex(n6), dArray[n6], dArray3[n6]);
            }
        }
        if (ilvDataSetPoint != null && ilvDataSet instanceof IlvVirtualDataSet) {
            ((IlvVirtualDataSet)ilvDataSet).unmap(ilvDataSetPoint);
            if (ilvDataSetPoint.getIndex() == -1) {
                ilvDataSetPoint = null;
            }
        }
        this.a(points);
        return ilvDataSetPoint;
    }

    public IlvDisplayPoint getDisplayItem(IlvChartDataPicker ilvChartDataPicker) {
        int n2 = ilvChartDataPicker.getPickX();
        int n3 = ilvChartDataPicker.getPickY();
        Rectangle rectangle = new Rectangle((int)Math.floor(n2 - 1), (int)Math.floor(n3 - 1), 2, 2);
        IlvDataPoints ilvDataPoints = this.a(rectangle);
        if (ilvDataPoints == null) {
            return null;
        }
        Points points = this.a(ilvDataPoints);
        IlvDisplayPoint ilvDisplayPoint = this.a(ilvChartDataPicker, points);
        points.b();
        if (ilvDisplayPoint != null && ilvDisplayPoint.getDataSet() instanceof IlvVirtualDataSet) {
            ((IlvVirtualDataSet)ilvDisplayPoint.getDataSet()).unmap(ilvDisplayPoint);
            if (ilvDisplayPoint.getIndex() == -1) {
                ilvDisplayPoint = null;
            }
        }
        return ilvDisplayPoint;
    }

    IlvDisplayPoint a(IlvChartDataPicker ilvChartDataPicker, Points points) {
        int n2 = points.size();
        if (n2 == 0) {
            return null;
        }
        ItemContains itemContains = this.a(ilvChartDataPicker);
        itemContains.startProcessItems();
        this.a(points, itemContains);
        itemContains.endProcessItems();
        return itemContains.getDisplayItem();
    }

    public IlvDisplayPoint getDisplayPoint(IlvDataSet ilvDataSet, int n2) {
        IlvDataSet ilvDataSet2 = this.b(ilvDataSet);
        if (ilvDataSet2 == null) {
            return null;
        }
        IlvDataSetPoint ilvDataSetPoint = new IlvDataSetPoint(ilvDataSet, n2);
        if (ilvDataSet2 instanceof IlvVirtualDataSet) {
            ((IlvVirtualDataSet)ilvDataSet2).map(ilvDataSetPoint);
        }
        IlvDataPoints ilvDataPoints = ilvDataSetPoint.getData();
        this.toDisplay(ilvDataPoints);
        return new IlvDisplayPoint(this, ilvDataSet, n2, ilvDataPoints.getX(0), ilvDataPoints.getY(0));
    }

    public void setDisplayPoint(IlvDataSet ilvDataSet, int n2, double d2, double d3) {
        if (!this.isDisplayingDataSet(ilvDataSet)) {
            return;
        }
        IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(d2, d3);
        this.toData(ilvDoublePoints);
        this.setDataPoint(ilvDataSet, n2, ilvDoublePoints.getX(0), ilvDoublePoints.getY(0));
    }

    public void setDataPoint(IlvDataSet ilvDataSet, int n2, double d2, double d3) {
        if (!this.isDisplayingDataSet(ilvDataSet)) {
            return;
        }
        IlvDataSetPoint ilvDataSetPoint = new IlvDataSetPoint(ilvDataSet, n2);
        IlvVirtualDataSet ilvVirtualDataSet = this.a(ilvDataSet);
        if (ilvVirtualDataSet != null) {
            ilvVirtualDataSet.map(ilvDataSetPoint);
        }
        ilvDataSetPoint.setData(d2, d3);
    }

    public void addImageMapAreas(IlvIMapDefinition ilvIMapDefinition, List list) {
        IlvDataPoints ilvDataPoints = this.a((Rectangle)null);
        if (ilvDataPoints == null) {
            return;
        }
        Points points = this.a(ilvDataPoints);
        if (points.size() > 0) {
            MapAction mapAction = this.a(ilvIMapDefinition, list);
            mapAction.startProcessItems();
            this.a(points, mapAction);
            mapAction.endProcessItems();
        }
        this.a(points);
    }

    abstract void a(Points var1, ItemAction var2);

    Rectangle2D c(Points points) {
        BoundsAction boundsAction = this.m();
        boundsAction.startProcessItems();
        this.a(points, boundsAction);
        boundsAction.endProcessItems();
        return boundsAction.getBounds();
    }

    void b(Graphics graphics, Points points) {
        DrawItem drawItem = this.l();
        drawItem.setGraphics(graphics);
        drawItem.startProcessItems();
        this.a(points, drawItem);
        drawItem.endProcessItems();
    }

    DrawItem l() {
        return new DefaultDrawItem();
    }

    BoundsAction m() {
        return new DefaultBoundsAction();
    }

    ItemContains a(IlvChartDataPicker ilvChartDataPicker) {
        return new DefaultItemContains(ilvChartDataPicker);
    }

    MapAction a(IlvIMapDefinition ilvIMapDefinition, List list) {
        return new MapAction(ilvIMapDefinition, list);
    }

    void a(IlvDataSet ilvDataSet, IlvDataInfoCollection ilvDataInfoCollection) {
        if (this.b == null) {
            this.b = new HashMap();
        }
        if (ilvDataInfoCollection == null) {
            this.b.remove(ilvDataSet);
        } else {
            this.b.put(ilvDataSet, ilvDataInfoCollection);
        }
    }

    IlvDataInfoCollection a(IlvDataSet ilvDataSet, boolean bl) {
        IlvDataInfoCollection ilvDataInfoCollection = this.b == null ? null : this.b.get(ilvDataSet);
        if (ilvDataInfoCollection == null && bl) {
            ilvDataInfoCollection = new InfoCollection();
            this.a(ilvDataSet, ilvDataInfoCollection);
        }
        return ilvDataInfoCollection;
    }

    boolean n() {
        if (this.u() != null) {
            return true;
        }
        IlvDataSource ilvDataSource = this.getDataSource();
        int n2 = ilvDataSource.getDataSetCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvDataSet ilvDataSet = ilvDataSource.getDataSet(i2);
            IlvDataInfoCollection ilvDataInfoCollection = this.a(ilvDataSet, false);
            if (ilvDataInfoCollection != null && ilvDataInfoCollection.holdsAnnotation()) {
                return true;
            }
            IlvDataSetStyle ilvDataSetStyle = IlvDataSetStyle.get(this.getChart(), ilvDataSet);
            if (ilvDataSetStyle == null) continue;
            return ilvDataSetStyle.holdsAnnotation();
        }
        return false;
    }

    boolean o() {
        if (this.v() != null) {
            return true;
        }
        IlvDataSource ilvDataSource = this.getDataSource();
        int n2 = ilvDataSource.getDataSetCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvDataSet ilvDataSet = ilvDataSource.getDataSet(i2);
            IlvDataInfoCollection ilvDataInfoCollection = this.a(ilvDataSet, false);
            if (ilvDataInfoCollection != null && ilvDataInfoCollection.holdsRenderingHint()) {
                return true;
            }
            IlvDataSetStyle ilvDataSetStyle = IlvDataSetStyle.get(this.getChart(), ilvDataSet);
            if (ilvDataSetStyle == null) continue;
            Map map = ilvDataSetStyle.getPointStyles();
            return map != null && map.size() > 0;
        }
        return false;
    }

    public void dataSetContentsChanged(DataSetContentsEvent dataSetContentsEvent) {
        Object object;
        Object object2;
        IlvChart ilvChart = this.getChart();
        if (ilvChart != null && ilvChart.isDynamicStyling()) {
            if (dataSetContentsEvent.getType() != 1 && (object2 = IlvStylingSupport.get(ilvChart)) != null && ((IlvStylingSupport)object2).hasStyles()) {
                object = dataSetContentsEvent.getDataSet();
                int n2 = dataSetContentsEvent.getFirstIdx();
                int n3 = dataSetContentsEvent.getLastIdx();
                if (object instanceof IlvVirtualDataSet) {
                    if (dataSetContentsEvent.getType() == 6) {
                        object = this.f();
                        n2 = 0;
                        n3 = object.getDataCount() - 1;
                    } else {
                        IlvDataSetPoint ilvDataSetPoint = new IlvDataSetPoint((IlvDataSet)object, n2);
                        IlvDataSetPoint ilvDataSetPoint2 = new IlvDataSetPoint((IlvDataSet)object, n3);
                        ((IlvVirtualDataSet)object).unmap(ilvDataSetPoint);
                        ((IlvVirtualDataSet)object).unmap(ilvDataSetPoint2);
                        n2 = ilvDataSetPoint.index;
                        n3 = ilvDataSetPoint2.index;
                        object = ilvDataSetPoint.dataSet;
                        if (n2 == -1 || n3 == -1) {
                            n2 = 0;
                            n3 = object.getDataCount() - 1;
                        }
                    }
                }
                IlvDataSetStyle.applyStyles((IlvDataSet)object, n2, n3, (IlvStylingSupport)object2);
            }
        }
        if (this.isViewable()) {
            if (this.j() && (dataSetContentsEvent.getType() == 2 || dataSetContentsEvent.getType() == 3 || dataSetContentsEvent.getType() == 4)) {
                object2 = dataSetContentsEvent.getDataSet();
                object = this.a(this.a((IlvDataSet)object2, dataSetContentsEvent.getFirstIdx(), dataSetContentsEvent.getLastIdx()));
                this.a((Points)object, false);
                ((Points)object).b();
            }
            ilvChart.dataSetContentsChanged(dataSetContentsEvent, this);
        }
    }

    public void dataSetPropertyChanged(DataSetPropertyEvent dataSetPropertyEvent) {
        IlvStylingSupport ilvStylingSupport;
        IlvChart ilvChart;
        if (dataSetPropertyEvent.getPropertyName().equals("name")) {
            this.triggerChange(6);
        }
        if ((ilvChart = this.getChart()) != null && (ilvStylingSupport = IlvStylingSupport.get(ilvChart)) != null && ilvStylingSupport.hasStyles()) {
            IlvDataSet ilvDataSet = dataSetPropertyEvent.getDataSet();
            if (ilvDataSet instanceof IlvVirtualDataSet) {
                ilvDataSet = this.f();
            }
            try {
                IlvDataSetStyle ilvDataSetStyle = IlvDataSetStyle.applyStyles(ilvDataSet, this, ilvStylingSupport);
                if (ilvDataSetStyle != null) {
                    this.applyDataSetStyle(ilvDataSetStyle);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void dataSetsRemoved(int n2, int n3, IlvDataSet[] ilvDataSetArray) {
        for (int i2 = n2; i2 <= n3; ++i2) {
            IlvDataSet ilvDataSet = ilvDataSetArray[i2];
            this.a(ilvDataSet, (IlvDataInfoCollection)null);
            this.a(ilvDataSet, (IlvVirtualDataSet)null);
            ilvDataSet.removeDataSetListener(this.c);
        }
        super.dataSetsRemoved(n2, n3, ilvDataSetArray);
    }

    protected void dataSetsAdded(int n2, int n3, IlvDataSet[] ilvDataSetArray) {
        for (int i2 = n2; i2 <= n3; ++i2) {
            this.getDataSource().getDataSet(i2).addDataSetListener(this.c);
        }
        super.dataSetsAdded(n2, n3, ilvDataSetArray);
    }

    void a(IlvDataSet ilvDataSet, IlvVirtualDataSet ilvVirtualDataSet) {
        this.a(ilvDataSet, ilvVirtualDataSet, true);
    }

    void a(IlvDataSet ilvDataSet, IlvVirtualDataSet ilvVirtualDataSet, boolean bl) {
        IlvVirtualDataSet ilvVirtualDataSet2 = this.a(ilvDataSet);
        if (ilvVirtualDataSet2 != null) {
            if (bl) {
                ilvVirtualDataSet2.removeDataSetListener(this.c);
            }
            ilvVirtualDataSet2.setDataSets(null);
        }
        ilvDataSet.putProperty(this, ilvVirtualDataSet, false);
        if (ilvVirtualDataSet != null) {
            ilvDataSet.removeDataSetListener(this.c);
            if (bl) {
                ilvVirtualDataSet.addDataSetListener(this.c);
            }
        } else if (ilvVirtualDataSet2 != ilvVirtualDataSet) {
            ilvDataSet.addDataSetListener(this.c);
        }
        if (this.getChart() != null && ilvVirtualDataSet2 != ilvVirtualDataSet) {
            this.getChart().updateDataRange();
        }
    }

    public IlvDataInterval getXRange(IlvDataInterval ilvDataInterval) {
        IlvDataSet ilvDataSet = this.e();
        if (ilvDataSet == null) {
            if (ilvDataInterval == null) {
                ilvDataInterval = new IlvDataInterval();
            } else {
                ilvDataInterval.empty();
            }
            return ilvDataInterval;
        }
        IlvDataInterval ilvDataInterval2 = ilvDataSet.getXRange(ilvDataInterval);
        double d2 = this.getXShift();
        if (d2 != 0.0) {
            ilvDataInterval2.translate(d2);
        }
        return ilvDataInterval2;
    }

    public IlvDataInterval getYRange(IlvDataInterval ilvDataInterval) {
        IlvDataSet ilvDataSet = this.e();
        if (ilvDataSet == null) {
            if (ilvDataInterval == null) {
                ilvDataInterval = new IlvDataInterval();
            } else {
                ilvDataInterval.empty();
            }
            return ilvDataInterval;
        }
        return ilvDataSet.getYRange(ilvDataInterval);
    }

    public IlvDataInterval getYRange(IlvDataInterval ilvDataInterval, IlvDataInterval ilvDataInterval2) {
        if (ilvDataInterval2 == null) {
            ilvDataInterval2 = new IlvDataInterval();
        } else {
            ilvDataInterval2.empty();
        }
        IlvDataSet ilvDataSet = this.e();
        if (ilvDataSet == null) {
            return ilvDataInterval2;
        }
        IlvDataWindow ilvDataWindow = new IlvDataWindow(ilvDataInterval, this.h().getVisibleRange());
        IlvDataPoints ilvDataPoints = ilvDataSet.getDataInside(ilvDataWindow, 0, true);
        if (ilvDataPoints == null) {
            return ilvDataInterval2;
        }
        int n2 = ilvDataPoints.size();
        Double d2 = ilvDataSet.getUndefValue();
        double d3 = d2 != null ? d2 : 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d4 = ilvDataPoints.getY(i2);
            if (d2 != null && d4 == d3) continue;
            ilvDataInterval2.add(d4);
        }
        ilvDataPoints.dispose();
        return ilvDataInterval2;
    }

    public Insets getPreferredMargins() {
        return new Insets(0, 0, 0, 0);
    }

    protected IlvStyle makeDefaultStyle() {
        return this.a(this.r(), null, this.e);
    }

    private Color r() {
        Color color = null;
        boolean bl = this.isFilled();
        if (this.getChart() == null) {
            color = (Color)IlvColor.getDefaultColors().get(0);
        } else {
            int n2;
            Collection collection;
            ArrayList<Color> arrayList = null;
            Color[] colorArray = this.getDefaultColors();
            if (colorArray == null) {
                arrayList = IlvColor.getDefaultColors();
            } else {
                arrayList = new ArrayList<Color>(Arrays.asList(colorArray));
                collection = IlvColor.getDefaultColors();
                for (n2 = arrayList.size(); n2 < collection.size(); ++n2) {
                    arrayList.add((Color)collection.get(n2));
                }
            }
            collection = this.t();
            n2 = this.s();
            if (n2 < arrayList.size() && !collection.contains(arrayList.get(n2))) {
                color = (Color)arrayList.get(n2);
            } else {
                HashSet<Color> hashSet = new HashSet<Color>(arrayList);
                hashSet.removeAll(collection);
                if (hashSet.size() == 0) {
                    color = IlvColorUtil.getRandomColor();
                } else {
                    int n3 = arrayList.size();
                    for (int i2 = 0; i2 < n3 && !hashSet.contains(color = (Color)arrayList.get(i2)); ++i2) {
                    }
                }
            }
        }
        return color;
    }

    IlvStyle a(Paint paint, Paint paint2, Stroke stroke) {
        if (stroke == null) {
            stroke = IlvStyle.DEFAULT_STROKE;
        }
        if (paint2 == null) {
            paint2 = Color.black;
        }
        if (this.isFilled()) {
            return new IlvStyle(stroke, paint2, paint);
        }
        return new IlvStyle(stroke, paint);
    }

    private int s() {
        Object e2;
        int n2 = 0;
        Iterator iterator = this.getChart().getAllRendererIterator();
        while (iterator.hasNext() && (e2 = iterator.next()) != this) {
            if (!(e2 instanceof IlvSingleChartRenderer)) continue;
            ++n2;
        }
        return n2;
    }

    private Set t() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.getChart().getRendererIterator();
        while (iterator.hasNext()) {
            IlvChartRenderer ilvChartRenderer = (IlvChartRenderer)iterator.next();
            this.a(hashSet, ilvChartRenderer.getStyles());
        }
        return hashSet;
    }

    private void a(Set set, IlvStyle[] ilvStyleArray) {
        if (ilvStyleArray == null) {
            return;
        }
        Color color = null;
        for (int i2 = 0; i2 < ilvStyleArray.length; ++i2) {
            color = ilvStyleArray[i2].getFillColor();
            if (color != null) {
                set.add(color);
            }
            if ((color = ilvStyleArray[i2].getStrokeColor()) == null) continue;
            set.add(color);
        }
    }

    public void drawLegendSymbol(IlvLegendItem ilvLegendItem, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = Math.min(n4, n5);
        this.getLegendStyle().renderRect(graphics, n2 + (n4 - n6) / 2, n3 + (n5 - n6) / 2, n6, n6);
    }

    public IlvLegendItem[] createLegendItems() {
        if (this.isViewable() && this.isVisibleInLegend()) {
            return new IlvLegendItem[]{new IlvRendererLegendItem(this)};
        }
        return null;
    }

    public String getLegendText(IlvLegendItem ilvLegendItem) {
        return this.getDefaultLegendText();
    }

    public String getDefaultLegendText() {
        if (this.getName() != null) {
            return this.getName();
        }
        if (this.e() != null) {
            return this.e().getName() != null ? this.e().getName() : "";
        }
        return "";
    }

    final double p() {
        IlvDataSet ilvDataSet = this.f();
        if (ilvDataSet == null) {
            return 0.0;
        }
        Double d2 = IlvDataSetProperty.getCategory(ilvDataSet);
        if (d2 != null) {
            return d2;
        }
        int n2 = ilvDataSet.getDataCount();
        return n2 > 1 ? ilvDataSet.getXRange(null).getLength() / (double)(n2 - 1) : 1.0;
    }

    public void drawAnnotations(Graphics graphics) {
        if (this.n()) {
            IlvDataPoints ilvDataPoints = this.a((Rectangle)null);
            if (ilvDataPoints == null) {
                return;
            }
            Points points = this.a(ilvDataPoints);
            if (points.size() > 0) {
                this.c(graphics, points);
            }
            this.a(points);
        }
    }

    void c(Graphics graphics, Points points) {
        IlvDataSet ilvDataSet = points.getDataSet();
        int n2 = points.size();
        double[] dArray = points.getXCoords();
        double[] dArray2 = points.getYCoords();
        int[] nArray = points.getIndices();
        Rectangle2D rectangle2D = null;
        IlvDisplayPoint ilvDisplayPoint = null;
        IlvDataWindow ilvDataWindow = this.getCoordinateSystem().getVisibleWindow();
        Rectangle rectangle = graphics.getClipBounds();
        Double d2 = ilvDataSet.getUndefValue();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvDataAnnotation ilvDataAnnotation;
            if (!ilvDataWindow.contains(points.getXData(i2), points.getYData(i2)) || d2 != null && points.getYData(i2) == d2.doubleValue() || (ilvDataAnnotation = this.a(ilvDisplayPoint = new IlvDisplayPoint(this, ilvDataSet, nArray[i2], dArray[i2], dArray2[i2]))) == null) continue;
            rectangle2D = ilvDataAnnotation.getBounds(ilvDisplayPoint, rectangle2D);
            if (rectangle != null && !rectangle.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight())) continue;
            ilvDataAnnotation.draw(graphics, ilvDisplayPoint);
        }
    }

    void a(Points points, Rectangle2D rectangle2D) {
        IlvDataSet ilvDataSet = points.getDataSet();
        int n2 = points.size();
        double[] dArray = points.getXCoords();
        double[] dArray2 = points.getYCoords();
        int[] nArray = points.getIndices();
        Rectangle2D rectangle2D2 = null;
        IlvDisplayPoint ilvDisplayPoint = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            ilvDisplayPoint = new IlvDisplayPoint(this, ilvDataSet, nArray[i2], dArray[i2], dArray2[i2]);
            IlvDataAnnotation ilvDataAnnotation = this.a(ilvDisplayPoint);
            if (ilvDataAnnotation == null) continue;
            rectangle2D2 = ilvDataAnnotation.getBounds(ilvDisplayPoint, rectangle2D2);
            rectangle2D = IlvGraphicUtil.addToRect(rectangle2D, rectangle2D2);
        }
    }

    Rectangle2D a(IlvDataSet ilvDataSet, int n2) {
        IlvDataAnnotation ilvDataAnnotation;
        IlvDisplayPoint ilvDisplayPoint = this.getDisplayPoint(ilvDataSet, n2);
        if (ilvDisplayPoint != null && (ilvDataAnnotation = this.a(ilvDisplayPoint)) != null) {
            return ilvDataAnnotation.getBounds(ilvDisplayPoint, null);
        }
        return null;
    }

    public void setAnnotation(IlvDataSet ilvDataSet, int n2, IlvDataAnnotation ilvDataAnnotation) {
        InfoCollection infoCollection = (InfoCollection)this.a(ilvDataSet, ilvDataAnnotation != null);
        if (infoCollection == null) {
            return;
        }
        Rectangle2D rectangle2D = null;
        boolean bl = false;
        if (this.getChart() != null) {
            IlvDataInterval ilvDataInterval = this.i().getVisibleRange();
            bl = ilvDataInterval.isInside(ilvDataSet.getXData(n2));
        }
        if (bl) {
            rectangle2D = this.a(ilvDataSet, n2);
        }
        infoCollection.setAnnotation(n2, ilvDataAnnotation);
        if (bl) {
            if (ilvDataAnnotation != null || this.u() != null) {
                if (rectangle2D == null) {
                    rectangle2D = this.a(ilvDataSet, n2);
                } else {
                    IlvGraphicUtil.addToRect(rectangle2D, this.a(ilvDataSet, n2));
                }
            }
            if (rectangle2D != null && !rectangle2D.isEmpty()) {
                this.getChart().getChartArea().repaint2D(rectangle2D);
            }
        }
    }

    public void setAnnotation(IlvDataSet ilvDataSet, IlvDataAnnotation ilvDataAnnotation) {
        InfoCollection infoCollection = (InfoCollection)this.a(ilvDataSet, ilvDataAnnotation != null);
        if (infoCollection == null) {
            return;
        }
        infoCollection.setAnnotation(ilvDataAnnotation);
        if (this.getChart() != null) {
            this.getChart().getChartArea().repaint();
        }
    }

    public IlvDataAnnotation getAnnotation(IlvDataSet ilvDataSet, int n2) {
        return this.a(new IlvDataSetPoint(ilvDataSet, n2));
    }

    public void setRenderingHint(IlvDataSet ilvDataSet, int n2, IlvDataRenderingHint ilvDataRenderingHint) {
        boolean bl;
        InfoCollection infoCollection = (InfoCollection)this.a(ilvDataSet, ilvDataRenderingHint != null);
        if (infoCollection == null) {
            return;
        }
        Rectangle2D rectangle2D = null;
        boolean bl2 = bl = this.getChart() != null;
        if (bl) {
            rectangle2D = this.getBounds(ilvDataSet, n2, n2, rectangle2D);
        }
        infoCollection.setRenderingHint(n2, ilvDataRenderingHint);
        if (bl) {
            Rectangle2D rectangle2D2 = this.getBounds(ilvDataSet, n2, n2, null);
            IlvGraphicUtil.addToRect(rectangle2D, rectangle2D2);
            this.getChart().getChartArea().repaint2D(rectangle2D);
        }
    }

    public void setRenderingHint(IlvDataSet ilvDataSet, IlvDataRenderingHint ilvDataRenderingHint) {
        InfoCollection infoCollection = (InfoCollection)this.a(ilvDataSet, ilvDataRenderingHint != null);
        if (infoCollection == null) {
            return;
        }
        infoCollection.setRenderingHint(ilvDataRenderingHint);
        if (this.getChart() != null) {
            this.getChart().getChartArea().repaint();
        }
    }

    public IlvDataRenderingHint getRenderingHint(IlvDataSet ilvDataSet, int n2) {
        return this.b(new IlvDataSetPoint(ilvDataSet, n2));
    }

    public IlvStyle getStyle(IlvDataSet ilvDataSet, int n2) {
        IlvDisplayPoint ilvDisplayPoint;
        IlvDataRenderingHint ilvDataRenderingHint;
        if (!this.isDisplayingDataSet(ilvDataSet)) {
            return null;
        }
        IlvStyle ilvStyle = this.b(ilvDataSet, n2);
        if (this.o() && (ilvDataRenderingHint = this.b(ilvDisplayPoint = new IlvDisplayPoint(this, ilvDataSet = this.b(ilvDataSet), n2, 0.0, 0.0))) != null) {
            return ilvDataRenderingHint.getStyle(ilvDisplayPoint, ilvStyle);
        }
        return ilvStyle;
    }

    public final IlvStyle getDisplayStyle(int n2) {
        return this.getStyle(this.f(), n2);
    }

    void q() {
        if (this.g) {
            this.a = null;
            this.a((IlvStyle)null);
        }
    }

    IlvStyle b(IlvDataSet ilvDataSet, int n2) {
        return this.getStyle();
    }

    IlvDataAnnotation a(IlvDataSetPoint ilvDataSetPoint) {
        IlvDataInfoCollection ilvDataInfoCollection;
        IlvDataAnnotation ilvDataAnnotation;
        if (ilvDataSetPoint.getDataSet() instanceof IlvVirtualDataSet) {
            ((IlvVirtualDataSet)ilvDataSetPoint.getDataSet()).unmap(ilvDataSetPoint);
        }
        IlvDataAnnotation ilvDataAnnotation2 = ilvDataAnnotation = (ilvDataInfoCollection = this.a(ilvDataSetPoint.getDataSet(), false)) == null ? null : ilvDataInfoCollection.getAnnotation(ilvDataSetPoint.getIndex());
        if (ilvDataAnnotation == null) {
            ilvDataAnnotation = this.u();
        }
        if (ilvDataAnnotation == null) {
            IlvDataSetStyle ilvDataSetStyle = IlvDataSetStyle.get(this.getChart(), ilvDataSetPoint.getDataSet());
            if (ilvDataSetStyle == null) {
                return null;
            }
            IlvDataPointStyle ilvDataPointStyle = ilvDataSetStyle.getPointStyle(ilvDataSetPoint.getIndex());
            IlvDataAnnotation ilvDataAnnotation3 = ilvDataAnnotation = ilvDataPointStyle == null ? null : ilvDataPointStyle.getAnnotation();
            if (ilvDataAnnotation == null) {
                ilvDataAnnotation = ilvDataSetStyle.getAnnotation();
            }
        }
        return ilvDataAnnotation;
    }

    private IlvDataAnnotation u() {
        IlvDataAnnotation ilvDataAnnotation = this.getAnnotation();
        return ilvDataAnnotation != null || this.getParent() == null ? ilvDataAnnotation : this.getParent().getAnnotation();
    }

    IlvDataRenderingHint b(IlvDataSetPoint ilvDataSetPoint) {
        IlvDataInfoCollection ilvDataInfoCollection;
        IlvDataRenderingHint ilvDataRenderingHint;
        if (ilvDataSetPoint.getDataSet() instanceof IlvVirtualDataSet) {
            ((IlvVirtualDataSet)ilvDataSetPoint.getDataSet()).unmap(ilvDataSetPoint);
        }
        IlvDataRenderingHint ilvDataRenderingHint2 = ilvDataRenderingHint = (ilvDataInfoCollection = this.a(ilvDataSetPoint.getDataSet(), false)) == null ? null : ilvDataInfoCollection.getRenderingHint(ilvDataSetPoint.getIndex());
        if (ilvDataRenderingHint == null) {
            ilvDataRenderingHint = this.v();
        }
        if (ilvDataRenderingHint == null) {
            IlvDataSetStyle ilvDataSetStyle = IlvDataSetStyle.get(this.getChart(), ilvDataSetPoint.getDataSet());
            ilvDataRenderingHint = ilvDataSetStyle == null ? null : ilvDataSetStyle.getPointStyle(ilvDataSetPoint.getIndex());
        }
        return ilvDataRenderingHint;
    }

    private IlvDataRenderingHint v() {
        IlvDataRenderingHint ilvDataRenderingHint = this.getRenderingHint();
        return ilvDataRenderingHint != null || this.getParent() == null ? ilvDataRenderingHint : this.getParent().getRenderingHint();
    }

    Point a(IlvDoublePoint ilvDoublePoint, Dimension dimension, double d2, boolean bl) {
        IlvChartProjector ilvChartProjector = this.getChart().getProjector();
        Rectangle rectangle = this.getPlotRect();
        IlvDoublePoint ilvDoublePoint2 = new IlvDoublePoint(ilvDoublePoint.x, ilvDoublePoint.y);
        ilvChartProjector.shiftAlongAxis(rectangle, bl ? this.h() : this.i(), ilvDoublePoint2, d2);
        double d3 = IlvGraphicUtil.pointAngleDeg(ilvDoublePoint.x, ilvDoublePoint.y, ilvDoublePoint2.x, ilvDoublePoint2.y);
        double d4 = IlvMathUtil.cosDeg(d3);
        double d5 = IlvMathUtil.sinDeg(d3);
        d3 = Math.min(d4 == 0.0 ? 100000.0 : Math.abs((double)dimension.width / (2.0 * d4)), d5 == 0.0 ? 100000.0 : Math.abs((double)dimension.height / (2.0 * d5)));
        ilvDoublePoint2.x += d3 * d4;
        ilvDoublePoint2.y -= d3 * d5;
        return new Point(ilvDoublePoint2.xFloor(), ilvDoublePoint2.yFloor());
    }

    public void applyStyles(boolean bl) throws Exception {
        IlvStylingSupport ilvStylingSupport = IlvStylingSupport.get(this.getChart());
        IlvDataSet ilvDataSet = this.f();
        if (ilvStylingSupport == null || ilvDataSet == null) {
            return;
        }
        IlvDataSetStyle ilvDataSetStyle = IlvDataSetStyle.get(this.getChart(), ilvDataSet);
        if (ilvDataSetStyle != null && !bl) {
            return;
        }
        ilvDataSetStyle = IlvDataSetStyle.applyStyles(ilvDataSet, this, ilvStylingSupport);
        if (ilvDataSetStyle != null) {
            this.applyDataSetStyle(ilvDataSetStyle);
        }
    }

    public void applyDataSetStyle(IlvDataSetStyle ilvDataSetStyle) {
        this.e = ilvDataSetStyle.getUsedStroke();
        if (ilvDataSetStyle.getColor1() == null) {
            boolean bl = this.g;
            this.a = null;
            this.setStyle(this.a(this.r(), ilvDataSetStyle.getColor2(), ilvDataSetStyle.getUsedStroke()));
            this.g = bl;
        } else {
            IlvStyle ilvStyle = ilvDataSetStyle.getStyle(this, this.getStyle());
            this.setStyle(ilvStyle);
        }
    }

    abstract class ItemIterator {
        int a;
        int b = -1;
        Points c;
        boolean d;
        IlvStyle e;
        IlvStyle f;
        IlvDisplayPoint g;
        Double h;

        public ItemIterator(Points points) {
            this.c = points;
            this.d = IlvSingleChartRenderer.this.o();
            this.h = points.getDataSet().getUndefValue();
        }

        public boolean hasNext() {
            return this.a();
        }

        public void next() {
            if (this.b >= this.c.size()) {
                throw new NoSuchElementException();
            }
            this.a = this.b;
        }

        public abstract Item getItem();

        public IlvStyle getStyle() {
            IlvDisplayPoint ilvDisplayPoint;
            IlvDataRenderingHint ilvDataRenderingHint;
            IlvStyle ilvStyle = IlvSingleChartRenderer.this.getStyle();
            if (this.d && (ilvDataRenderingHint = IlvSingleChartRenderer.this.b(ilvDisplayPoint = this.c.getDisplayPoint(this.getCurrentIdx()))) != null) {
                return ilvDataRenderingHint.getStyle(ilvDisplayPoint, ilvStyle);
            }
            return ilvStyle;
        }

        public int getCurrentIdx() {
            return this.a;
        }

        public Points getPoints() {
            return this.c;
        }

        private boolean a() {
            do {
                if (++this.b < this.c.size()) continue;
                return false;
            } while (this.h != null && this.h.doubleValue() == this.c.getYData(this.b));
            return true;
        }
    }

    class MapAction
    implements ItemAction {
        static final double a = 2.0;
        IlvIMapDefinition b;
        List c;

        MapAction(IlvIMapDefinition ilvIMapDefinition, List list) {
            this.b = ilvIMapDefinition;
            this.c = list;
        }

        public void startProcessItems() {
        }

        public void endProcessItems() {
        }

        public void processItem(Points points, int n2, Item item, IlvStyle ilvStyle) {
            IlvIMapArea ilvIMapArea;
            IlvDataSetPoint ilvDataSetPoint = points.a(n2);
            IlvIMapAttributes ilvIMapAttributes = this.b.getAttributes(ilvDataSetPoint);
            IlvIMapArea ilvIMapArea2 = ilvIMapArea = ilvIMapAttributes == null ? null : this.a(item, ilvStyle, ilvIMapAttributes);
            if (ilvIMapArea != null) {
                this.c.add(ilvIMapArea);
            }
        }

        IlvIMapArea a(Item item, IlvStyle ilvStyle, IlvIMapAttributes ilvIMapAttributes) {
            return item.getMapArea(this.b, ilvStyle, ilvIMapAttributes);
        }
    }

    class DefaultBoundsAction
    extends BoundsAction {
        Rectangle2D a;
        Rectangle2D b;

        DefaultBoundsAction() {
            this.a = new Rectangle2D.Double();
            this.b = null;
        }

        protected void itemBounds(Points points, int n2, Item item, IlvStyle ilvStyle) {
            this.b = item.getBounds(ilvStyle, this.b);
            this.a = IlvGraphicUtil.addToRect(this.a, this.b);
        }

        public Rectangle2D getBounds() {
            return this.a;
        }
    }

    class DefaultDrawItem
    extends DrawItem {
        DefaultDrawItem() {
        }

        protected void drawItem(Points points, int n2, Item item, IlvStyle ilvStyle) {
            item.draw(this.getGraphics(), ilvStyle);
        }
    }

    class DefaultItemContains
    extends ItemContains {
        IlvDisplayPoint a;

        public DefaultItemContains(IlvChartDataPicker ilvChartDataPicker) {
            super(ilvChartDataPicker);
        }

        public void processItem(Points points, int n2, Item item, IlvStyle ilvStyle) {
            if (item.contains(ilvStyle, this.getX(), this.getY())) {
                this.a = new IlvDisplayPoint(IlvSingleChartRenderer.this, points.getDataSet(), points.getDataIndex(n2), points.getXCoord(n2), points.getYCoord(n2));
            }
        }

        public IlvDisplayPoint getDisplayItem() {
            return this.a;
        }
    }

    abstract class ItemContains
    implements ItemAction {
        private IlvChartDataPicker a;

        public void startProcessItems() {
        }

        public void endProcessItems() {
        }

        public ItemContains(IlvChartDataPicker ilvChartDataPicker) {
            this.a = ilvChartDataPicker;
        }

        public abstract void processItem(Points var1, int var2, Item var3, IlvStyle var4);

        public final int getX() {
            return this.a.getPickX();
        }

        public final int getY() {
            return this.a.getPickY();
        }

        public final IlvChartDataPicker getDataPicker() {
            return this.a;
        }

        public abstract IlvDisplayPoint getDisplayItem();
    }

    abstract class DrawItem
    implements ItemAction {
        Graphics a;

        DrawItem() {
        }

        public void startProcessItems() {
        }

        public void endProcessItems() {
        }

        public final Graphics getGraphics() {
            return this.a;
        }

        public void setGraphics(Graphics graphics) {
            this.a = graphics;
        }

        public void processItem(Points points, int n2, Item item, IlvStyle ilvStyle) {
            this.drawItem(points, n2, item, ilvStyle);
        }

        protected abstract void drawItem(Points var1, int var2, Item var3, IlvStyle var4);
    }

    abstract class BoundsAction
    implements ItemAction {
        BoundsAction() {
        }

        public void startProcessItems() {
        }

        public void endProcessItems() {
        }

        public void processItem(Points points, int n2, Item item, IlvStyle ilvStyle) {
            this.itemBounds(points, n2, item, ilvStyle);
        }

        protected abstract void itemBounds(Points var1, int var2, Item var3, IlvStyle var4);

        public abstract Rectangle2D getBounds();
    }

    static interface ItemAction {
        public void startProcessItems();

        public void endProcessItems();

        public void processItem(Points var1, int var2, Item var3, IlvStyle var4);
    }

    class DefaultItem
    extends IlvDoublePoints
    implements Item {
        public DefaultItem() {
        }

        public DefaultItem(int n2) {
            super(n2);
        }

        public void draw(Graphics graphics, IlvStyle ilvStyle) {
            if (IlvSingleChartRenderer.this.isFilled()) {
                ilvStyle.renderPoints(graphics, this.getXValues(), this.getYValues(), this.size());
            } else {
                ilvStyle.drawPolyline(graphics, this.getXValues(), this.getYValues(), this.size());
            }
        }

        public Rectangle2D getBounds(IlvStyle ilvStyle, Rectangle2D rectangle2D) {
            return ilvStyle.getBounds(this.getXValues(), this.getYValues(), this.size(), rectangle2D);
        }

        public boolean contains(IlvStyle ilvStyle, double d2, double d3) {
            return IlvSingleChartRenderer.this.isFilled() ? ilvStyle.pointsContains(this.getXValues(), this.getYValues(), this.size(), d2, d3) : ilvStyle.polylineContains(this.getXValues(), this.getYValues(), this.size(), d2, d3);
        }

        public IlvIMapArea getMapArea(IlvIMapDefinition ilvIMapDefinition, IlvStyle ilvStyle, IlvIMapAttributes ilvIMapAttributes) {
            double[] dArray;
            double[] dArray2;
            int n2 = this.size();
            if (ilvIMapDefinition.isChartOrigin()) {
                Rectangle rectangle = this.a();
                if (rectangle.x != 0 || rectangle.y != 0) {
                    dArray2 = this.getXValuesClone();
                    dArray = this.getYValuesClone();
                    int n3 = 0;
                    while (n3 < n2) {
                        int n4 = n3;
                        dArray2[n4] = dArray2[n4] + (double)rectangle.x;
                        int n5 = n3++;
                        dArray[n5] = dArray[n5] + (double)rectangle.y;
                    }
                } else {
                    dArray2 = this.getXValues();
                    dArray = this.getYValues();
                }
            } else {
                dArray2 = this.getXValues();
                dArray = this.getYValues();
            }
            return new IlvIMapArea(dArray2, dArray, n2, ilvIMapAttributes);
        }

        Rectangle a() {
            IlvChart.Area area = IlvSingleChartRenderer.this.getChart().getChartArea();
            if (IlvSingleChartRenderer.this.getChart().isPaintingImage() && IlvSingleChartRenderer.this.getChart().getPaintContext().getBounds() != null) {
                return (Rectangle)IlvSingleChartRenderer.this.getChart().getPaintContext().getBounds().get(area);
            }
            return area.getBounds();
        }
    }

    static interface Item {
        public void draw(Graphics var1, IlvStyle var2);

        public Rectangle2D getBounds(IlvStyle var1, Rectangle2D var2);

        public boolean contains(IlvStyle var1, double var2, double var4);

        public IlvIMapArea getMapArea(IlvIMapDefinition var1, IlvStyle var2, IlvIMapAttributes var3);
    }

    final class Points {
        private IlvDataPoints a;
        private boolean b = false;
        private IlvDataSet c;
        private IlvDoublePoints d;
        private boolean e;

        public Points(IlvDataPoints ilvDataPoints, boolean bl) {
            this.a = ilvDataPoints;
            this.c = ilvDataPoints.getDataSet();
            this.e = bl;
        }

        public final IlvChart getChart() {
            return IlvSingleChartRenderer.this.getChart();
        }

        public final IlvDataSet getDataSet() {
            return this.c;
        }

        final IlvDataSetPoint a(int n2) {
            IlvDataSetPoint ilvDataSetPoint = new IlvDataSetPoint(this.getDataSet(), this.getDataIndex(n2));
            if (this.getDataSet() instanceof IlvVirtualDataSet) {
                ((IlvVirtualDataSet)this.getDataSet()).unmap(ilvDataSetPoint);
            }
            return ilvDataSetPoint;
        }

        final void a() {
            if (this.a != null) {
                if (this.e) {
                    this.d = new IlvDoublePoints();
                    this.d.add(this.a);
                    IlvSingleChartRenderer.this.toDisplay(this.d);
                } else {
                    IlvSingleChartRenderer.this.toDisplay(this.a);
                    this.d = this.a;
                }
            }
            this.b = true;
        }

        public final void addData(double d2, double d3) {
            this.a.add(d2, d3);
        }

        public final void addData(double[] dArray, double[] dArray2, int n2) {
            this.a.add(dArray, dArray2, n2);
        }

        public final void addData(int n2, double[] dArray, double[] dArray2, int n3) {
            this.a.add(n2, dArray, dArray2, n3);
        }

        public final void addData(int n2, double d2, double d3) {
            this.addData(n2, new double[]{d2}, new double[]{d3}, 1);
        }

        void b() {
            if (this.a != null) {
                this.a.dispose();
            }
            if (this.d != null && this.d != this.a) {
                this.d.dispose();
            }
        }

        IlvDataPoints c() {
            return this.isProjected() && !this.e ? null : this.a;
        }

        IlvDoublePoints d() {
            return this.d;
        }

        public final boolean isProjected() {
            return this.d != null;
        }

        public final int[] getIndices() {
            return this.a.getIndices();
        }

        public int size() {
            return this.a == null ? 0 : this.a.size();
        }

        public final int getDataIndex(int n2) {
            return this.a.getIndices()[n2];
        }

        public final double[] getXCoords() {
            if (!this.isProjected()) {
                this.a();
            }
            return this.d.getXValues();
        }

        public final double[] getYCoords() {
            if (!this.isProjected()) {
                this.a();
            }
            return this.d.getYValues();
        }

        public final double getXCoord(int n2) {
            return this.getXCoords()[n2];
        }

        public final double getYCoord(int n2) {
            return this.getYCoords()[n2];
        }

        public final IlvDisplayPoint getDisplayPoint(int n2) {
            return this.getDisplayPoint(n2, false, true);
        }

        public final IlvDisplayPoint getDisplayPoint(int n2, boolean bl, boolean bl2) {
            double d2 = bl2 ? this.getXCoord(n2) : 0.0;
            double d3 = bl2 ? this.getYCoord(n2) : 0.0;
            IlvDisplayPoint ilvDisplayPoint = new IlvDisplayPoint(IlvSingleChartRenderer.this, this.c, this.getDataIndex(n2), d2, d3);
            if (bl && this.c instanceof IlvVirtualDataSet) {
                ((IlvVirtualDataSet)this.c).unmap(ilvDisplayPoint);
            }
            return ilvDisplayPoint;
        }

        public final double[] getXData() {
            if (this.isProjected()) {
                if (this.e) {
                    return this.a.getXValues();
                }
                int[] nArray = this.getIndices();
                int n2 = this.size();
                double[] dArray = new double[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    dArray[i2] = this.c.getXData(nArray[i2]);
                }
                return dArray;
            }
            return this.a.getXValues();
        }

        public final double[] getYData() {
            if (this.b) {
                if (this.e) {
                    return this.a.getYValues();
                }
                int[] nArray = this.getIndices();
                int n2 = this.size();
                double[] dArray = new double[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    dArray[i2] = this.c.getYData(nArray[i2]);
                }
                return dArray;
            }
            return this.a.getYValues();
        }

        public final double getXData(int n2) {
            return this.isProjected() && !this.e ? this.c.getXData(this.getDataIndex(n2)) : this.a.getX(n2);
        }

        public final double getYData(int n2) {
            return this.isProjected() && !this.e ? this.c.getYData(this.getDataIndex(n2)) : this.a.getY(n2);
        }

        public String toString() {
            if (this.a != null) {
                return this.a.toString();
            }
            return null;
        }
    }

    static class InfoCollection
    implements IlvDataInfoCollection,
    Serializable {
        IlvDataInfoMap a;
        IlvDataAnnotation b;
        IlvDataRenderingHint c;

        InfoCollection() {
        }

        public void setAnnotation(IlvDataAnnotation ilvDataAnnotation) {
            this.b = ilvDataAnnotation;
        }

        public void setAnnotation(int n2, IlvDataAnnotation ilvDataAnnotation) {
            if (this.a == null) {
                if (ilvDataAnnotation != null) {
                    this.a = new IlvDataInfoMap();
                    this.a.setAnnotation(n2, ilvDataAnnotation);
                }
            } else {
                this.a.setAnnotation(n2, ilvDataAnnotation);
            }
        }

        public void setRenderingHint(IlvDataRenderingHint ilvDataRenderingHint) {
            this.c = ilvDataRenderingHint;
        }

        public void setRenderingHint(int n2, IlvDataRenderingHint ilvDataRenderingHint) {
            if (this.a == null) {
                if (ilvDataRenderingHint != null) {
                    this.a = new IlvDataInfoMap();
                    this.a.setRenderingHint(n2, ilvDataRenderingHint);
                }
            } else {
                this.a.setRenderingHint(n2, ilvDataRenderingHint);
            }
        }

        public IlvDataAnnotation getAnnotation(int n2) {
            IlvDataAnnotation ilvDataAnnotation = this.a == null ? null : this.a.getAnnotation(n2);
            return ilvDataAnnotation == null ? this.b : ilvDataAnnotation;
        }

        public IlvDataRenderingHint getRenderingHint(int n2) {
            IlvDataRenderingHint ilvDataRenderingHint = this.a == null ? null : this.a.getRenderingHint(n2);
            return ilvDataRenderingHint == null ? this.c : ilvDataRenderingHint;
        }

        public Iterator getAnnotations() {
            return null;
        }

        public Iterator getRenderingHints() {
            return null;
        }

        public boolean holdsAnnotation() {
            return this.b != null || this.a != null && this.a.holdsAnnotation();
        }

        public boolean holdsRenderingHint() {
            return this.c != null || this.a != null && this.a.holdsRenderingHint();
        }
    }

    private class InternalListener
    implements DataSetListener,
    PropertyChangeListener,
    Serializable {
        private InternalListener() {
        }

        public void dataSetContentsChanged(DataSetContentsEvent dataSetContentsEvent) {
            IlvSingleChartRenderer.this.dataSetContentsChanged(dataSetContentsEvent);
        }

        public void dataSetPropertyChanged(DataSetPropertyEvent dataSetPropertyEvent) {
            IlvSingleChartRenderer.this.dataSetPropertyChanged(dataSetPropertyEvent);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == IlvSingleChartRenderer.this.getChart() && "defaultColors".equals(propertyChangeEvent.getPropertyName())) {
                IlvSingleChartRenderer.this.q();
            }
        }
    }
}

