/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.renderer;

import ilog.views.chart.IlvChartDataPicker;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvLegendItem;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.data.IlvDataSource;
import ilog.views.chart.graphic.IlvDataAnnotation;
import ilog.views.chart.graphic.IlvDataRenderingHint;
import ilog.views.chart.renderer.IlvSingleChartRenderer;
import ilog.views.chart.servlet.IlvIMapDefinition;
import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.util.collections.IlvCollections;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class IlvCompositeChartRenderer
extends IlvChartRenderer {
    private ArrayList a = new ArrayList();
    private IlvStyle[] b;

    protected IlvCompositeChartRenderer() {
    }

    public boolean isViewable() {
        if (this.isVisible()) {
            for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
                if (!this.getChild(i2).isViewable()) continue;
                return true;
            }
        }
        return false;
    }

    public void setStyles(IlvStyle[] ilvStyleArray) {
        if (ilvStyleArray == null) {
            int n2 = this.getChildCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.getChild(i2).setStyles(null);
            }
        } else {
            int n3 = Math.min(ilvStyleArray.length, this.getChildCount());
            for (int i3 = 0; i3 < n3; ++i3) {
                this.getChild(i3).setStyles(new IlvStyle[]{ilvStyleArray[i3]});
            }
        }
        this.b = ilvStyleArray;
    }

    boolean d() {
        return this.b == null;
    }

    void e() {
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvChartRenderer ilvChartRenderer = this.getChild(i2);
            if (ilvChartRenderer instanceof IlvSingleChartRenderer) {
                ((IlvSingleChartRenderer)ilvChartRenderer).q();
                continue;
            }
            ((IlvCompositeChartRenderer)ilvChartRenderer).e();
        }
    }

    public IlvStyle[] getStyles() {
        ArrayList<IlvStyle> arrayList = new ArrayList<IlvStyle>();
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            IlvStyle[] ilvStyleArray = this.getChild(i2).getStyles();
            for (int i3 = 0; i3 < ilvStyleArray.length; ++i3) {
                arrayList.add(ilvStyleArray[i3]);
            }
        }
        return arrayList.toArray(new IlvStyle[arrayList.size()]);
    }

    public IlvStyle getStyle(IlvDataSet ilvDataSet, int n2) {
        int n3 = this.getChildCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!this.getChild(i2).isDisplayingDataSet(ilvDataSet)) continue;
            return this.getChild(i2).getStyle(ilvDataSet, n2);
        }
        return null;
    }

    public int getChildCount() {
        return this.a.size();
    }

    public IlvChartRenderer getChild(int n2) {
        return n2 < this.a.size() ? (IlvChartRenderer)this.a.get(n2) : null;
    }

    public List getChildren() {
        return (List)this.a.clone();
    }

    public Iterator getChildIterator() {
        return IlvCollections.unmodifiableIterator(this.a.iterator());
    }

    int c(IlvChartRenderer ilvChartRenderer) {
        return this.a.indexOf(ilvChartRenderer);
    }

    void a(int n2, IlvChartRenderer ilvChartRenderer) {
        if (n2 == -1) {
            this.a.add(ilvChartRenderer);
        } else {
            this.a.add(n2, ilvChartRenderer);
        }
        IlvStyle[] ilvStyleArray = ilvChartRenderer.getStyles();
        if ((ilvStyleArray == null || ilvStyleArray.length == 0) && this.b != null && n2 < this.b.length) {
            ilvChartRenderer.setStyles(new IlvStyle[]{this.b[n2]});
        }
        this.e(ilvChartRenderer);
        this.updateChildren();
    }

    void b(int n2, IlvChartRenderer ilvChartRenderer) {
        IlvChartRenderer ilvChartRenderer2 = this.getChild(n2);
        if (ilvChartRenderer2 != null) {
            ilvChartRenderer.setDataSource(ilvChartRenderer2.getDataSource());
        }
        this.a.set(n2, ilvChartRenderer);
        this.e(ilvChartRenderer);
        this.updateChildren();
    }

    void d(IlvChartRenderer ilvChartRenderer) {
        this.a.remove(ilvChartRenderer);
        this.updateChildren();
    }

    void f() {
        this.a.clear();
    }

    public IlvChartRenderer getChild(IlvDataSet ilvDataSet) {
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvChartRenderer ilvChartRenderer = this.getChild(i2);
            if (!ilvChartRenderer.isDisplayingDataSet(ilvDataSet)) continue;
            return ilvChartRenderer;
        }
        return null;
    }

    public final IlvChartRenderer getChild(String string) {
        if (string == null) {
            return null;
        }
        IlvDataSource ilvDataSource = this.getDataSource();
        int n2 = ilvDataSource.getDataSetCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = ilvDataSource.getDataSet(i2).getName();
            if (string2 == null || !string2.equals(string)) continue;
            return this.getChild(ilvDataSource.getDataSet(i2));
        }
        return null;
    }

    private void e(IlvChartRenderer ilvChartRenderer) {
        if (ilvChartRenderer.getChart() != null) {
            throw new IllegalArgumentException("renderer already added to a chart");
        }
        ilvChartRenderer.setParent(this);
    }

    protected abstract IlvChartRenderer createChild(IlvDataSet var1);

    protected void updateChildren() {
    }

    public void setDisplayPoint(IlvDataSet ilvDataSet, int n2, double d2, double d3) {
        IlvChartRenderer ilvChartRenderer = this.getChild(ilvDataSet);
        if (ilvChartRenderer != null) {
            ilvChartRenderer.setDisplayPoint(ilvDataSet, n2, d2, d3);
        }
    }

    public void setDataPoint(IlvDataSet ilvDataSet, int n2, double d2, double d3) {
        IlvChartRenderer ilvChartRenderer = this.getChild(ilvDataSet);
        if (ilvChartRenderer != null) {
            ilvChartRenderer.setDataPoint(ilvDataSet, n2, d2, d3);
        }
    }

    public void draw(Graphics graphics) {
        ListIterator listIterator = this.c();
        while (listIterator.hasNext()) {
            IlvChartRenderer ilvChartRenderer = (IlvChartRenderer)listIterator.next();
            if (!ilvChartRenderer.isViewable()) continue;
            ilvChartRenderer.draw(graphics);
        }
    }

    final ListIterator g() {
        return this.a.listIterator();
    }

    final ListIterator h() {
        return IlvCollections.reversedIterator(this.a);
    }

    ListIterator c() {
        return this.g();
    }

    private final ListIterator i() {
        ListIterator listIterator = this.c();
        while (listIterator.hasNext()) {
            listIterator.next();
        }
        return IlvCollections.reversedIterator(listIterator);
    }

    public void drawAnnotations(Graphics graphics) {
        ListIterator listIterator = this.c();
        while (listIterator.hasNext()) {
            IlvChartRenderer ilvChartRenderer = (IlvChartRenderer)listIterator.next();
            if (!ilvChartRenderer.isViewable()) continue;
            ilvChartRenderer.drawAnnotations(graphics);
        }
    }

    public void draw(Graphics graphics, IlvDataSet ilvDataSet, int n2, int n3) {
        ListIterator listIterator = this.c();
        while (listIterator.hasNext()) {
            IlvChartRenderer ilvChartRenderer = (IlvChartRenderer)listIterator.next();
            if (!ilvChartRenderer.isViewable() || !ilvChartRenderer.isDisplayingDataSet(ilvDataSet)) continue;
            ilvChartRenderer.draw(graphics, ilvDataSet, n2, n3);
        }
    }

    public Rectangle2D getBounds(IlvDataSet ilvDataSet, int n2, int n3, Rectangle2D rectangle2D) {
        return this.getBounds(ilvDataSet, n2, n3, rectangle2D, true);
    }

    public Rectangle2D getBounds(IlvDataSet ilvDataSet, int n2, int n3, Rectangle2D rectangle2D, boolean bl) {
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Double();
        } else {
            rectangle2D.setRect(0.0, 0.0, 0.0, 0.0);
        }
        int n4 = this.getChildCount();
        Rectangle2D rectangle2D2 = null;
        for (int i2 = 0; i2 < n4; ++i2) {
            IlvChartRenderer ilvChartRenderer = this.getChild(i2);
            if (!ilvChartRenderer.isViewable() || !ilvChartRenderer.isDisplayingDataSet(ilvDataSet)) continue;
            rectangle2D2 = ilvChartRenderer.getBounds(ilvDataSet, n2, n3, rectangle2D2, bl);
            IlvGraphicUtil.addToRect(rectangle2D, rectangle2D2);
        }
        return rectangle2D;
    }

    public IlvDisplayPoint getNearestPoint(IlvChartDataPicker ilvChartDataPicker) {
        return IlvChartRenderer.getNearestPoint(this.i(), ilvChartDataPicker);
    }

    public IlvDisplayPoint getDisplayItem(IlvChartDataPicker ilvChartDataPicker) {
        return IlvChartRenderer.getDisplayItem(this.i(), ilvChartDataPicker);
    }

    public IlvDisplayPoint getDisplayPoint(IlvDataSet ilvDataSet, int n2) {
        IlvChartRenderer ilvChartRenderer = this.getChild(ilvDataSet);
        return ilvChartRenderer == null ? null : ilvChartRenderer.getDisplayPoint(ilvDataSet, n2);
    }

    public IlvDataInterval getXRange(IlvDataInterval ilvDataInterval) {
        if (ilvDataInterval == null) {
            ilvDataInterval = new IlvDataInterval();
        }
        ilvDataInterval.empty();
        IlvDataInterval ilvDataInterval2 = null;
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvChartRenderer ilvChartRenderer = this.getChild(i2);
            if (!ilvChartRenderer.isViewable()) continue;
            ilvDataInterval2 = ilvChartRenderer.getXRange(ilvDataInterval2);
            ilvDataInterval.add(ilvDataInterval2);
        }
        return ilvDataInterval;
    }

    public IlvDataInterval getYRange(IlvDataInterval ilvDataInterval) {
        if (ilvDataInterval == null) {
            ilvDataInterval = new IlvDataInterval();
        }
        ilvDataInterval.empty();
        IlvDataInterval ilvDataInterval2 = null;
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvChartRenderer ilvChartRenderer = this.getChild(i2);
            if (!ilvChartRenderer.isViewable()) continue;
            ilvDataInterval2 = ilvChartRenderer.getYRange(ilvDataInterval2);
            ilvDataInterval.add(ilvDataInterval2);
        }
        return ilvDataInterval;
    }

    public IlvDataInterval getYRange(IlvDataInterval ilvDataInterval, IlvDataInterval ilvDataInterval2) {
        if (ilvDataInterval2 == null) {
            ilvDataInterval2 = new IlvDataInterval();
        }
        ilvDataInterval2.empty();
        IlvDataInterval ilvDataInterval3 = null;
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvChartRenderer ilvChartRenderer = this.getChild(i2);
            if (!ilvChartRenderer.isViewable()) continue;
            ilvDataInterval3 = ilvChartRenderer.getYRange(ilvDataInterval, ilvDataInterval3);
            ilvDataInterval2.add(ilvDataInterval3);
        }
        return ilvDataInterval2;
    }

    public void drawLegendSymbol(IlvLegendItem ilvLegendItem, Graphics graphics, int n2, int n3, int n4, int n5) {
    }

    public IlvLegendItem[] createLegendItems() {
        IlvLegendItem[] ilvLegendItemArray = null;
        if (this.isViewable()) {
            ArrayList<IlvLegendItem> arrayList = new ArrayList<IlvLegendItem>();
            for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
                IlvLegendItem[] ilvLegendItemArray2 = this.getChild(i2).createLegendItems();
                if (ilvLegendItemArray2 == null) continue;
                arrayList.addAll(Arrays.asList(ilvLegendItemArray2));
            }
            ilvLegendItemArray = new IlvLegendItem[arrayList.size()];
            arrayList.toArray(ilvLegendItemArray);
        }
        return ilvLegendItemArray;
    }

    public String getLegendText(IlvLegendItem ilvLegendItem) {
        return "";
    }

    public void addImageMapAreas(IlvIMapDefinition ilvIMapDefinition, List list) {
        ListIterator listIterator = this.i();
        while (listIterator.hasNext()) {
            IlvChartRenderer ilvChartRenderer = (IlvChartRenderer)listIterator.next();
            if (!ilvChartRenderer.isViewable() || !ilvIMapDefinition.mustGenerate(ilvChartRenderer)) continue;
            ilvChartRenderer.addImageMapAreas(ilvIMapDefinition, list);
        }
    }

    public void setAnnotation(IlvDataSet ilvDataSet, int n2, IlvDataAnnotation ilvDataAnnotation) {
        IlvChartRenderer ilvChartRenderer = this.getChild(ilvDataSet);
        if (ilvChartRenderer != null) {
            ilvChartRenderer.setAnnotation(ilvDataSet, n2, ilvDataAnnotation);
        }
    }

    public void setAnnotation(IlvDataSet ilvDataSet, IlvDataAnnotation ilvDataAnnotation) {
        IlvChartRenderer ilvChartRenderer = this.getChild(ilvDataSet);
        if (ilvChartRenderer != null) {
            ilvChartRenderer.setAnnotation(ilvDataSet, ilvDataAnnotation);
        }
    }

    public IlvDataAnnotation getAnnotation(IlvDataSet ilvDataSet, int n2) {
        IlvChartRenderer ilvChartRenderer = this.getChild(ilvDataSet);
        return ilvChartRenderer != null ? ilvChartRenderer.getAnnotation(ilvDataSet, n2) : null;
    }

    public void setRenderingHint(IlvDataSet ilvDataSet, int n2, IlvDataRenderingHint ilvDataRenderingHint) {
        IlvChartRenderer ilvChartRenderer = this.getChild(ilvDataSet);
        if (ilvChartRenderer != null) {
            ilvChartRenderer.setRenderingHint(ilvDataSet, n2, ilvDataRenderingHint);
        }
    }

    public void setRenderingHint(IlvDataSet ilvDataSet, IlvDataRenderingHint ilvDataRenderingHint) {
        IlvChartRenderer ilvChartRenderer = this.getChild(ilvDataSet);
        if (ilvChartRenderer != null) {
            ilvChartRenderer.setRenderingHint(ilvDataSet, ilvDataRenderingHint);
        }
    }

    public IlvDataRenderingHint getRenderingHint(IlvDataSet ilvDataSet, int n2) {
        IlvChartRenderer ilvChartRenderer = this.getChild(ilvDataSet);
        return ilvChartRenderer != null ? ilvChartRenderer.getRenderingHint(ilvDataSet, n2) : null;
    }
}

