/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.interactor;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartDecoration;
import ilog.views.chart.IlvChartInteractor;
import ilog.views.chart.IlvCoordinateSystem;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDataWindow;
import ilog.views.chart.IlvDoublePoint;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.graphic.IlvDataIndicator;
import ilog.views.util.collections.IlvCollections;
import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.ListIterator;

public class IlvChartDataIndicatorInteractor
extends IlvChartInteractor {
    private static final float[] a;
    private static final BasicStroke b;
    private InteractionHandler c = new Translater();
    private transient IlvDataIndicator d;
    private transient IlvDoublePoint e;
    private transient Object f;
    private boolean g;
    private InteractionHandler h;

    public IlvChartDataIndicatorInteractor() {
        this(0, 16, false);
    }

    public IlvChartDataIndicatorInteractor(int n2, int n3, boolean bl) {
        super(n2, n3);
        this.enableEvents(56L);
        this.g = bl;
        this.b();
    }

    private void b() {
        this.e = null;
        this.d = null;
        this.f = null;
    }

    public final boolean isOpaqueEdit() {
        return this.g;
    }

    public void setOpaqueEdit(boolean bl) {
        this.g = bl;
    }

    protected final IlvDataIndicator getIndicator() {
        return this.d;
    }

    private boolean a(int n2, int n3) {
        List list = this.getChart().getDecorations();
        if (list == null) {
            return false;
        }
        ListIterator listIterator = IlvCollections.reversedIterator(list);
        while (listIterator.hasNext()) {
            IlvChartDecoration ilvChartDecoration = (IlvChartDecoration)listIterator.next();
            if (!(ilvChartDecoration instanceof IlvDataIndicator) || !((IlvDataIndicator)ilvChartDecoration).contains(n2, n3)) continue;
            this.d = (IlvDataIndicator)ilvChartDecoration;
            return true;
        }
        return false;
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                if ((mouseEvent.getModifiers() & this.getEventMask()) != this.getEventMask() || (mouseEvent.getModifiers() & ~this.getEventMask()) != 0 || !this.a(mouseEvent.getX(), mouseEvent.getY())) break;
                this.e = this.getData(mouseEvent);
                this.h = this.a(mouseEvent);
                this.startOperation(mouseEvent);
                this.f = this.h.computeValue(0.0, 0.0, this.g);
                if (!this.g) {
                    this.drawGhost();
                }
                mouseEvent.consume();
                break;
            }
            case 502: {
                if ((mouseEvent.getModifiers() & this.getEventMask()) != this.getEventMask() || (mouseEvent.getModifiers() & ~this.getEventMask()) != 0 || !this.isInOperation()) break;
                IlvDoublePoint ilvDoublePoint = this.getData(mouseEvent);
                this.validate(ilvDoublePoint);
                if (!this.g) {
                    this.drawGhost();
                }
                double d2 = ilvDoublePoint.x - this.e.x;
                double d3 = ilvDoublePoint.y - this.e.y;
                this.h.computeValue(d2, d3, true);
                this.endOperation(mouseEvent);
                mouseEvent.consume();
                break;
            }
        }
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 506: {
                if (!this.isInOperation()) break;
                IlvDoublePoint ilvDoublePoint = this.getData(mouseEvent);
                this.validate(ilvDoublePoint);
                double d2 = ilvDoublePoint.x - this.e.x;
                double d3 = ilvDoublePoint.y - this.e.y;
                if (this.g) {
                    this.f = this.h.computeValue(d2, d3, true);
                } else {
                    this.drawGhost();
                    this.f = this.h.computeValue(d2, d3, false);
                    this.drawGhost();
                }
                this.e = ilvDoublePoint;
                mouseEvent.consume();
            }
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 27) {
            if (!this.g && this.e != null) {
                this.drawGhost();
            }
            this.abort();
            keyEvent.consume();
        }
    }

    protected void drawGhost(Graphics graphics) {
        IlvChart ilvChart = this.getChart();
        int n2 = this.d.getType();
        IlvStyle ilvStyle = this.c();
        IlvCoordinateSystem ilvCoordinateSystem = this.getChart().getCoordinateSystem(this.getYAxisIndex());
        Shape shape = null;
        switch (n2) {
            case 0: 
            case 1: {
                double d2 = (Double)this.f;
                int n3 = this.d.getAxisIndex() == -1 ? 1 : 2;
                shape = ilvChart.getProjector().getShape(d2, n3, ilvChart.getChartArea().getPlotRect(), ilvCoordinateSystem);
                break;
            }
            default: {
                IlvDataWindow ilvDataWindow = new IlvDataWindow((IlvDataWindow)this.f);
                ilvDataWindow.intersection(ilvCoordinateSystem.getVisibleWindow());
                if (ilvDataWindow.isEmpty()) {
                    return;
                }
                shape = ilvChart.getProjector().getShape(ilvDataWindow, ilvChart.getChartArea().getPlotRect(), ilvCoordinateSystem);
            }
        }
        ilvStyle.renderShape(graphics, shape);
    }

    protected Rectangle getGhostBounds() {
        IlvChart ilvChart = this.getChart();
        int n2 = this.d.getType();
        IlvStyle ilvStyle = this.c();
        Rectangle rectangle = new Rectangle();
        IlvCoordinateSystem ilvCoordinateSystem = this.getChart().getCoordinateSystem(this.getYAxisIndex());
        Shape shape = null;
        switch (n2) {
            case 0: 
            case 1: {
                double d2 = (Double)this.f;
                int n3 = this.d.getAxisIndex() == -1 ? 1 : 2;
                shape = ilvChart.getProjector().getShape(d2, n3, ilvChart.getChartArea().getPlotRect(), ilvCoordinateSystem);
                break;
            }
            default: {
                IlvDataWindow ilvDataWindow = new IlvDataWindow((IlvDataWindow)this.f);
                ilvDataWindow.intersection(ilvCoordinateSystem.getVisibleWindow());
                if (ilvDataWindow.isEmpty()) {
                    return rectangle;
                }
                shape = ilvChart.getProjector().getShape(ilvDataWindow, ilvChart.getChartArea().getPlotRect(), ilvCoordinateSystem);
            }
        }
        rectangle = shape.getBounds();
        this.c().expand(rectangle);
        return rectangle;
    }

    private final IlvStyle c() {
        IlvStyle ilvStyle = this.d.getStyle();
        if (ilvStyle == null) {
            ilvStyle = new IlvStyle(1.0f, (Paint)this.getGhostColor());
        }
        return ilvStyle;
    }

    protected void validate(IlvDoublePoint ilvDoublePoint) {
        IlvDataInterval ilvDataInterval = this.getChart().getXAxis().getDataRange();
        ilvDoublePoint.x = Math.max(ilvDataInterval.min, Math.min(ilvDataInterval.max, ilvDoublePoint.x));
        ilvDataInterval = this.getChart().getYAxis(this.d.getAxisIndex()).getDataRange();
        ilvDoublePoint.y = Math.max(ilvDataInterval.min, Math.min(ilvDataInterval.max, ilvDoublePoint.y));
    }

    protected void startOperation(MouseEvent mouseEvent) {
        super.startOperation(mouseEvent);
        this.setAllowDrawGhost(!this.g);
        if (this.h != null) {
            this.setCursor(this.h.getCursor());
        }
    }

    protected void endOperation(MouseEvent mouseEvent) {
        super.endOperation(mouseEvent);
        this.setAllowDrawGhost(false);
        this.setCursor(null);
        this.d = null;
        this.e = null;
        this.f = null;
    }

    protected void abort() {
        super.abort();
        this.setAllowDrawGhost(false);
        this.setCursor(null);
        this.d = null;
        this.e = null;
        this.f = null;
    }

    private final InteractionHandler a(MouseEvent mouseEvent) {
        IlvDoublePoint ilvDoublePoint = this.getData(mouseEvent);
        InteractionHandler interactionHandler = null;
        IlvDataInterval ilvDataInterval = null;
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl = false;
        double d4 = 0.0;
        double d5 = 0.0;
        IlvDataWindow ilvDataWindow = this.d.getDataWindow();
        int n2 = this.d.getType();
        boolean bl2 = false;
        switch (n2) {
            case 0: 
            case 1: {
                boolean bl3 = bl2 = n2 == 0;
                if (bl2) {
                    ilvDataInterval = this.getChart().getCoordinateSystem((int)0).getVisibleWindow().xRange;
                    d2 = ilvDoublePoint.x;
                } else {
                    ilvDataInterval = this.getChart().getCoordinateSystem((int)0).getVisibleWindow().yRange;
                    d2 = ilvDoublePoint.y;
                }
                d4 = ilvDataInterval.getLength() * 0.02;
                d3 = this.d.getValue();
                if (!(d2 > d3 - d4) || !(d2 < d3 + d4)) break;
                interactionHandler = this.c;
                break;
            }
            case 2: 
            case 3: {
                boolean bl4 = bl2 = n2 == 2;
                if (bl2) {
                    ilvDataInterval = ilvDataWindow.xRange;
                    d2 = ilvDoublePoint.x;
                } else {
                    ilvDataInterval = ilvDataWindow.yRange;
                    d2 = ilvDoublePoint.y;
                }
                d5 = ilvDataInterval.getLength();
                d4 = d5 * 0.1;
                if (d2 > ilvDataInterval.min && d2 < ilvDataInterval.min + d4) {
                    interactionHandler = new Reshaper(bl2 ? 1 : 3);
                    break;
                }
                if (d2 < ilvDataInterval.max && d2 > ilvDataInterval.max - d4) {
                    interactionHandler = new Reshaper(bl2 ? 2 : 4);
                    break;
                }
                if (!(d2 >= ilvDataInterval.min + d4) || !(d2 <= ilvDataInterval.max - d4)) break;
                interactionHandler = this.c;
                break;
            }
            case 4: {
                ilvDataInterval = ilvDataWindow.xRange;
                d5 = ilvDataInterval.getLength();
                d4 = d5 * 0.1;
                d2 = ilvDoublePoint.x;
                if (ilvDoublePoint.x > ilvDataInterval.min && ilvDoublePoint.x < ilvDataInterval.min + d4 && ilvDoublePoint.y >= ilvDataWindow.yRange.min && ilvDoublePoint.y <= ilvDataWindow.yRange.max) {
                    interactionHandler = new Reshaper(1);
                    break;
                }
                if (d2 < ilvDataInterval.max && d2 > ilvDataInterval.max - d4 && ilvDoublePoint.y >= ilvDataWindow.yRange.min && ilvDoublePoint.y <= ilvDataWindow.yRange.max) {
                    interactionHandler = new Reshaper(2);
                    break;
                }
                ilvDataInterval = ilvDataWindow.yRange;
                d5 = ilvDataInterval.getLength();
                d4 = d5 * 0.1;
                d2 = ilvDoublePoint.y;
                if (d2 > ilvDataInterval.min && d2 < ilvDataInterval.min + d4 && ilvDoublePoint.x >= ilvDataWindow.xRange.min && ilvDoublePoint.x <= ilvDataWindow.xRange.max) {
                    interactionHandler = new Reshaper(3);
                    break;
                }
                if (d2 < ilvDataInterval.max && d2 > ilvDataInterval.max - d4 && ilvDoublePoint.x >= ilvDataWindow.xRange.min && ilvDoublePoint.x <= ilvDataWindow.xRange.max) {
                    interactionHandler = new Reshaper(4);
                    break;
                }
                if (!(ilvDoublePoint.x >= ilvDataWindow.xRange.min) || !(ilvDoublePoint.x <= ilvDataWindow.xRange.max) || !(ilvDoublePoint.y >= ilvDataWindow.yRange.min) || !(ilvDoublePoint.y <= ilvDataWindow.yRange.max)) break;
                interactionHandler = this.c;
            }
        }
        return interactionHandler;
    }

    public boolean has3DSupport() {
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.b();
    }

    static {
        IlvChartInteractor.register("DataIndicator", IlvChartDataIndicatorInteractor.class);
        a = new float[]{5.0f};
        b = new BasicStroke(1.0f, 0, 0, 10.0f, a, 0.0f);
    }

    private final class Reshaper
    implements InteractionHandler {
        static final int a = 1;
        static final int b = 2;
        static final int c = 3;
        static final int d = 4;
        private int e;

        public Reshaper(int n2) {
            this.e = n2;
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(12);
        }

        public Object computeValue(double d2, double d3, boolean bl) {
            IlvDataWindow ilvDataWindow = IlvChartDataIndicatorInteractor.this.f != null ? (IlvDataWindow)IlvChartDataIndicatorInteractor.this.f : IlvChartDataIndicatorInteractor.this.getIndicator().getDataWindow();
            IlvDataInterval ilvDataInterval = null;
            int n2 = IlvChartDataIndicatorInteractor.this.getIndicator().getType();
            switch (this.e) {
                case 1: {
                    ilvDataWindow.xRange.min += d2;
                    ilvDataInterval = ilvDataWindow.xRange;
                    break;
                }
                case 2: {
                    ilvDataWindow.xRange.max += d2;
                    ilvDataInterval = ilvDataWindow.xRange;
                    break;
                }
                case 3: {
                    ilvDataWindow.yRange.min += d3;
                    ilvDataInterval = ilvDataWindow.yRange;
                    break;
                }
                case 4: {
                    ilvDataWindow.yRange.max += d3;
                    ilvDataInterval = ilvDataWindow.yRange;
                }
            }
            if (bl) {
                if (n2 != 4) {
                    IlvChartDataIndicatorInteractor.this.getIndicator().setRange(ilvDataInterval);
                } else {
                    IlvChartDataIndicatorInteractor.this.getIndicator().setDataWindow(ilvDataWindow);
                }
            }
            return ilvDataWindow;
        }
    }

    private final class Translater
    implements InteractionHandler {
        private Translater() {
        }

        public Object computeValue(double d2, double d3, boolean bl) {
            IlvDataInterval ilvDataInterval = null;
            Serializable serializable = null;
            int n2 = IlvChartDataIndicatorInteractor.this.getIndicator().getType();
            switch (n2) {
                case 0: 
                case 1: {
                    double d4 = IlvChartDataIndicatorInteractor.this.f != null ? ((Double)IlvChartDataIndicatorInteractor.this.f).doubleValue() : IlvChartDataIndicatorInteractor.this.getIndicator().getValue();
                    System.err.println("v:" + d4 + "   dx:" + d2 + "   dy:" + d3);
                    d4 += n2 == 0 ? d2 : d3;
                    if (bl) {
                        IlvChartDataIndicatorInteractor.this.getIndicator().setValue(d4);
                    }
                    serializable = new Double(d4);
                    System.err.println("value:" + serializable);
                    break;
                }
                default: {
                    IlvDataWindow ilvDataWindow;
                    IlvDataWindow ilvDataWindow2 = ilvDataWindow = IlvChartDataIndicatorInteractor.this.f != null ? (IlvDataWindow)IlvChartDataIndicatorInteractor.this.f : IlvChartDataIndicatorInteractor.this.getIndicator().getDataWindow();
                    if (n2 != 3) {
                        ilvDataInterval = IlvChartDataIndicatorInteractor.this.getChart().getXAxis().getDataRange();
                        ilvDataWindow.xRange.translate(d2);
                    }
                    if (n2 != 2) {
                        ilvDataInterval = IlvChartDataIndicatorInteractor.this.getYAxis().getDataRange();
                        ilvDataWindow.yRange.translate(d3);
                    }
                    if (bl) {
                        if (n2 == 2) {
                            IlvChartDataIndicatorInteractor.this.getIndicator().setRange(ilvDataWindow.xRange);
                        } else if (n2 == 3) {
                            IlvChartDataIndicatorInteractor.this.getIndicator().setRange(ilvDataWindow.yRange);
                        } else {
                            IlvChartDataIndicatorInteractor.this.getIndicator().setDataWindow(ilvDataWindow);
                        }
                    }
                    serializable = ilvDataWindow;
                }
            }
            return serializable;
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(13);
        }
    }

    private static interface InteractionHandler {
        public Object computeValue(double var1, double var3, boolean var5);

        public Cursor getCursor();
    }
}

