/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvAxisTransformer;
import ilog.views.chart.IlvAxisTransformerException;
import ilog.views.chart.IlvCategoryStepsDefinition;
import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartDrawable;
import ilog.views.chart.IlvChartProjector;
import ilog.views.chart.IlvCoordinateSystem;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDefaultStepsDefinition;
import ilog.views.chart.IlvDoublePoint;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.IlvLabelRenderer;
import ilog.views.chart.IlvLogarithmicAxisTransformer;
import ilog.views.chart.IlvLogarithmicStepsDefinition;
import ilog.views.chart.IlvPolarProjector;
import ilog.views.chart.IlvScaleAnnotation;
import ilog.views.chart.IlvScaleConfiguration;
import ilog.views.chart.IlvStepsDefinition;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.IlvTextRenderer;
import ilog.views.chart.IlvTimeStepsDefinition;
import ilog.views.chart.IlvTimeUnit;
import ilog.views.chart.IlvValueFormat;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.event.AxisChangeEvent;
import ilog.views.chart.event.AxisListener;
import ilog.views.chart.event.AxisRangeEvent;
import ilog.views.chart.util.IlvDoubleArray;
import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.chart.util.internal.IlvFlags;
import ilog.views.chart.util.internal.IlvMathUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public class IlvScale
implements IlvChartDrawable,
Serializable {
    public static final int TICK_INSIDE = 1;
    public static final int TICK_OUTSIDE = 2;
    public static final int TICK_CROSS = 3;
    public static final int CONSTANT_SKIP = 1;
    public static final int ADAPTIVE_SKIP = 2;
    static final int a = 1;
    static final int b = 2;
    static final int c = 3;
    private static final int d = 1;
    private static final int e = 2;
    private static final int f = 4;
    private static final int g = 8;
    private static final int h = 16;
    private static final int i = 32;
    private static final int j = 64;
    private static final int k = 128;
    private static final int l = 256;
    private static final int m = 512;
    private static final int n = 1024;
    private static final int o = 2048;
    private static final int p = 8192;
    private static final int q = 16384;
    private static final int r = 32768;
    private static final int s = 63;
    IlvFlags t = new IlvFlags(63);
    private int u = Integer.MAX_VALUE;
    private int v = 6;
    private int w = 3;
    private int x = 3;
    private int y = 3;
    private int z = 0;
    private int aa = 2;
    private int ab = 1;
    private double ac = 0.0;
    private boolean ad;
    private IlvChart.AxisElement ae;
    private AxisListener af;
    private IlvAxis.Crossing ag;
    transient Rectangle ah;
    transient Rectangle ai;
    Steps aj;
    IlvStepsDefinition ak;
    private IlvStyle al;
    private Color am;
    private Title an;
    private List ao;
    private IlvValueFormat ap;
    private Font aq;
    private IlvScale ar;
    private IlvScale as;
    private boolean at;
    private IlvScaleConfiguration au = IlvScaleConfiguration.a(1);

    public IlvScale() {
        this(0.0, 0.0);
    }

    public IlvScale(double d2, double d3) {
        this.au.a(this);
        this.setStepUnit(d2 == 0.0 ? null : new Double(d2), d3 == 0.0 ? null : new Double(d3));
        this.ai();
    }

    public IlvScale(IlvTimeUnit ilvTimeUnit) {
        this.au.a(this);
        this.setTimeUnit(ilvTimeUnit);
        this.ai();
    }

    IlvScaleConfiguration a() {
        return this.au;
    }

    void a(IlvScaleConfiguration ilvScaleConfiguration) {
        if (this.au != null) {
            this.au.a((IlvScale)null);
        }
        this.au = ilvScaleConfiguration;
        if (ilvScaleConfiguration != null) {
            ilvScaleConfiguration.a(this);
        }
        this.m().m();
    }

    public void setAxisStroke(Stroke stroke) {
        this.al = this.b().setStroke(stroke);
    }

    public final Stroke getAxisStroke() {
        return this.b().getStroke();
    }

    final IlvStyle b() {
        if (this.al == null) {
            this.al = IlvStyle.createStroked(this.getForeground());
        } else if (!this.t.getFlag(32768)) {
            this.al.a(this.getForeground());
        }
        return this.al;
    }

    void a(boolean bl) {
        this.t.setFlag(8192, bl);
    }

    final boolean c() {
        return this.t.getFlag(8192);
    }

    void b(boolean bl) {
        this.t.setFlag(16384, bl);
    }

    final boolean d() {
        return this.getChart().isAntiAliasingText();
    }

    public final Font getLabelFont() {
        if (this.aq == null) {
            if (this.getChart() != null) {
                return this.getChart().getChartArea().getFont();
            }
            return UIManager.getFont("Label.font");
        }
        return this.getChart() != null && this.getChart().getFontManager() != null ? this.getChart().getFontManager().getDeriveFont(this.aq) : this.aq;
    }

    public void setLabelFont(Font font) {
        this.aq = font;
        this.z();
    }

    FontMetrics a(Font font) {
        if (this.getChart() != null) {
            return this.getChart().getChartArea().getFontMetrics(font);
        }
        return new JLabel().getFontMetrics(font);
    }

    public void setLabelColor(Color color) {
        Color color2 = this.am;
        this.am = color;
    }

    public final Color getLabelColor() {
        return this.am == null ? this.getForeground() : this.am;
    }

    public void setForeground(Color color) {
        Color color2 = this.getForeground();
        if (color == null || color instanceof ColorUIResource) {
            this.t.setFlag(32768, false);
            color = this.aa();
        } else {
            this.t.setFlag(32768, true);
        }
        this.al = this.b().setStrokePaint(color);
    }

    public Color getForeground() {
        if (this.al == null || !this.t.getFlag(32768)) {
            return this.aa();
        }
        return this.al.getStrokeColor();
    }

    private Color aa() {
        return this.getChart() != null ? this.getChart().getChartArea().getForeground() : UIManager.getColor("Label.foreground");
    }

    public final int getDrawOrder() {
        return this.u;
    }

    public void setDrawOrder(int n2) {
        if (this.u == n2) {
            return;
        }
        int n3 = this.u;
        this.u = n2;
        if (this.getChart() != null) {
            this.getChart().a(this, n3, n2);
            this.getChart().getChartArea().repaint2D(this.getBounds(null));
        }
    }

    public void setMajorTickSize(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Value must be positive");
        }
        this.v = n2;
        this.z();
    }

    public final int getMajorTickSize() {
        return this.v;
    }

    public void setMinorTickSize(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Value must be positive");
        }
        this.w = n2;
        this.z();
    }

    public final int getMinorTickSize() {
        return this.w;
    }

    public final int getTickLayout() {
        return this.aa;
    }

    public void setTickLayout(int n2) {
        if (this.aa == n2) {
            return;
        }
        if (n2 != 1 && n2 != 2 && n2 != 3) {
            throw new IllegalArgumentException("Invalid constant");
        }
        this.aa = n2;
        this.z();
    }

    public final int getLabelOffset() {
        return this.x;
    }

    public void setLabelOffset(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Value must be positive");
        }
        this.x = n2;
        this.z();
    }

    public final int getTitleOffset() {
        return this.y;
    }

    public void setTitleOffset(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Value must be positive");
        }
        this.y = n2;
        this.z();
    }

    public final boolean isAutoWrapping() {
        return this.ad;
    }

    public void setAutoWrapping(boolean bl) {
        if (this.ad == bl) {
            return;
        }
        this.ad = bl;
        this.m().a(bl);
        this.z();
    }

    public final int getLabelAlignment() {
        return this.z;
    }

    public void setLabelAlignment(int n2) {
        if (n2 != 2 && n2 != 0 && n2 != 4) {
            throw new IllegalArgumentException("Invalid Alignment");
        }
        if (this.z == n2) {
            return;
        }
        this.z = n2;
        this.m().a(n2);
        if (this.getChart() != null) {
            this.getChart().getChartArea().repaint();
        }
    }

    private synchronized Title ab() {
        if (this.an == null) {
            this.an = new Title(null, 0.0);
        }
        return this.an;
    }

    public double getTitleRotation() {
        return this.ab().getLabelRenderer().getRotation();
    }

    public void setTitleRotation(double d2) {
        this.ab().getLabelRenderer().setRotation(d2);
    }

    public Font getTitleFont() {
        return this.ab().getLabelRenderer().getFont();
    }

    public void setTitleFont(Font font) {
        this.ab().getLabelRenderer().setFont(font);
    }

    public void setTitle(String string) {
        this.ab().setText(string);
        this.z();
    }

    void a(boolean bl, boolean bl2) {
        if (bl) {
            double d2;
            double d3 = d2 = this.getAxis().isXAxis() ? 0.0 : -90.0;
            if (this.getChart() != null && this.getChart().isProjectorReversed()) {
                d2 = d2 == 0.0 ? -90.0 : 0.0;
            }
            this.ab().getLabelRenderer().setRotation(d2);
        }
        if (bl2) {
            this.z();
        }
    }

    public final String getTitle() {
        return this.ab().getText();
    }

    public void setTitle(String string, double d2) {
        this.ab().setText(string);
        this.ab().getLabelRenderer().setRotation(d2);
        this.z();
    }

    public IlvLabelRenderer getTitleRenderer() {
        return this.ab().getLabelRenderer();
    }

    public int getTitlePlacement() {
        return this.ab().getPlacement();
    }

    public void setTitlePlacement(int n2) {
        this.ab().setPlacement(n2);
    }

    final Title e() {
        return this.an;
    }

    boolean f() {
        IlvAxis ilvAxis = this.getDualAxis();
        if (ilvAxis == null) {
            return false;
        }
        IlvDataInterval ilvDataInterval = ilvAxis.getVisibleRange();
        return this.isVisible() && this.getAxis() != null && (!this.ae() || ilvDataInterval.isInside(this.getCrossingValue()));
    }

    public double getLabelRotation() {
        return this.ac;
    }

    public void setLabelRotation(double d2) {
        this.ac = d2;
        this.m().a(d2);
        this.z();
    }

    public void setSkippingLabel(boolean bl) {
        if (bl == this.isSkippingLabel()) {
            return;
        }
        this.t.setFlag(2, bl);
        this.z();
    }

    public final boolean isSkippingLabel() {
        return this.t.getFlag(2);
    }

    public void setSkipLabelMode(int n2) {
        if (n2 == this.ab) {
            return;
        }
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Invalid constant");
        }
        this.ab = n2;
        this.z();
    }

    public final int getSkipLabelMode() {
        return this.ab;
    }

    private void e(boolean bl) {
        this.t.setFlag(2048, bl);
    }

    final boolean g() {
        return this.isCategory() && ((IlvCategoryStepsDefinition)this.getStepsDefinition()).isStepBetweenCategory();
    }

    public boolean has3DSupport() {
        return true;
    }

    public final boolean isVisible() {
        return this.t.getFlag(1);
    }

    public void setVisible(boolean bl) {
        this.t.setFlag(1, bl);
        this.z();
    }

    public final boolean isAxisVisible() {
        return this.t.getFlag(16);
    }

    public void setAxisVisible(boolean bl) {
        this.t.setFlag(16, bl);
        this.z();
    }

    public final boolean isMajorTickVisible() {
        return this.t.getFlag(4);
    }

    public void setMajorTickVisible(boolean bl) {
        this.t.setFlag(4, bl);
        this.z();
    }

    public final boolean isMinorTickVisible() {
        return this.t.getFlag(8);
    }

    public void setMinorTickVisible(boolean bl) {
        this.t.setFlag(8, bl);
        this.z();
    }

    public final boolean isLabelVisible() {
        return this.t.getFlag(32);
    }

    public void setLabelVisible(boolean bl) {
        this.t.setFlag(32, bl);
        this.z();
    }

    final boolean h() {
        return this.t.getFlag(128);
    }

    void c(boolean bl) {
        this.t.setFlag(128, bl);
    }

    public void setCrossingValue(double d2) {
        this.setCrossing(new IlvAxis.AnchoredCrossing(d2));
    }

    public void setCrossing(IlvAxis.Crossing crossing) {
        this.a(crossing);
    }

    public void setAutoCrossing(boolean bl) {
        if (bl) {
            this.a((IlvAxis.Crossing)null);
        } else {
            this.a(this.getCrossing());
        }
    }

    private void a(IlvAxis.Crossing crossing) {
        this.ag = crossing;
        this.m().n();
        this.z();
    }

    public final boolean isAutoCrossing() {
        return this.ag == null;
    }

    public final double getCrossingValue() {
        if (this.getChart().is3D()) {
            return this.getChart().get3DView().d().getCrossingValue(this.getAxis());
        }
        return this.getCrossing().getValue(this.getDualAxis());
    }

    public final IlvAxis.Crossing getCrossing() {
        return this.ag == null ? this.ac() : this.ag;
    }

    private IlvAxis.Crossing ac() {
        return this.a().a();
    }

    void a(IlvScale ilvScale) {
        if (ilvScale == this.as) {
            return;
        }
        if (this.as != null) {
            this.as.b((IlvScale)null);
        }
        this.as = ilvScale;
        this.as.b(this);
        this.at = false;
        this.z();
    }

    final IlvScale i() {
        if (this.as != null) {
            return this.as;
        }
        IlvChart ilvChart = this.getChart();
        if (ilvChart == null || ilvChart.getType() != 1 || this.getAxis().isXAxis() || this.ae()) {
            return null;
        }
        int n2 = ilvChart.getYAxisCount();
        IlvAxis.Crossing crossing = this.getCrossing();
        boolean bl = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvScale ilvScale = ilvChart.getYScale(i2);
            if (ilvScale == null) continue;
            if (ilvScale == this) {
                bl = true;
                continue;
            }
            if (!bl || ilvScale.getCrossing() != crossing) continue;
            return ilvScale;
        }
        return null;
    }

    final void b(IlvScale ilvScale) {
        this.ar = ilvScale;
        this.m().n();
        this.z();
    }

    final IlvScale j() {
        if (this.ar != null) {
            return this.ar;
        }
        IlvChart ilvChart = this.getChart();
        if (ilvChart == null || ilvChart.getType() != 1 || this.getAxis().isXAxis() || this.ae()) {
            return null;
        }
        IlvAxis.Crossing crossing = this.getCrossing();
        boolean bl = false;
        int n2 = ilvChart.getYAxisCount();
        while (--n2 >= 0) {
            IlvScale ilvScale = ilvChart.getYScale(n2);
            if (ilvScale == null) continue;
            if (ilvScale == this) {
                bl = true;
                continue;
            }
            if (!bl || ilvScale.getCrossing() != crossing) continue;
            return ilvScale;
        }
        return null;
    }

    final boolean k() {
        return this.at;
    }

    final boolean l() {
        return this.i() != null && this.k() && (this.getChart() == null || this.getChart().getType() == 1);
    }

    void c(IlvScale ilvScale) {
        this.a(ilvScale);
        boolean bl = this.at = ilvScale != null;
        if (this.at) {
            ilvScale.a(this.r());
        }
    }

    public final IlvStepsDefinition getStepsDefinition() {
        return this.ak;
    }

    public void setStepsDefinition(IlvStepsDefinition ilvStepsDefinition) {
        if (ilvStepsDefinition == null) {
            throw new IllegalArgumentException("Steps definition cannot be null");
        }
        if (ilvStepsDefinition.getScale() != null) {
            throw new IllegalArgumentException("Steps definition owned by a scale");
        }
        if (this.ak != null) {
            this.ak.a(null);
        }
        this.e(ilvStepsDefinition instanceof IlvCategoryStepsDefinition);
        this.ak = ilvStepsDefinition;
        this.ak.a(this);
        if (this.getAxis() != null && ilvStepsDefinition instanceof IlvLogarithmicStepsDefinition && (this.getAxis().getTransformer() == null || !(this.getAxis().getTransformer() instanceof IlvLogarithmicAxisTransformer))) {
            this.getAxis().setTransformer(new IlvLogarithmicAxisTransformer());
        }
        if (this.m() != null) {
            this.m().m();
        }
        this.z();
    }

    public void setStepUnit(double d2, double d3) {
        boolean bl = false;
        IlvDefaultStepsDefinition ilvDefaultStepsDefinition = null;
        if (this.getStepsDefinition() instanceof IlvDefaultStepsDefinition) {
            ilvDefaultStepsDefinition = (IlvDefaultStepsDefinition)this.getStepsDefinition();
        } else {
            ilvDefaultStepsDefinition = new IlvDefaultStepsDefinition();
            bl = true;
        }
        if (d2 != 0.0) {
            ilvDefaultStepsDefinition.setStepUnit(d2);
        } else {
            ilvDefaultStepsDefinition.setAutoStepUnit(true);
        }
        if (d3 != 0.0) {
            ilvDefaultStepsDefinition.setSubStepUnit(d3);
        } else {
            ilvDefaultStepsDefinition.setAutoSubStepUnit(true);
        }
        if (bl) {
            this.setStepsDefinition(ilvDefaultStepsDefinition);
        }
    }

    public void setStepUnit(Double d2, Double d3) {
        boolean bl = false;
        IlvDefaultStepsDefinition ilvDefaultStepsDefinition = null;
        if (this.getStepsDefinition() instanceof IlvDefaultStepsDefinition) {
            ilvDefaultStepsDefinition = (IlvDefaultStepsDefinition)this.getStepsDefinition();
        } else {
            ilvDefaultStepsDefinition = new IlvDefaultStepsDefinition();
            bl = true;
        }
        if (d2 != null) {
            ilvDefaultStepsDefinition.setStepUnit(d2);
        } else {
            ilvDefaultStepsDefinition.setAutoStepUnit(true);
        }
        if (d3 != null) {
            ilvDefaultStepsDefinition.setSubStepUnit(d3);
        } else {
            ilvDefaultStepsDefinition.setAutoSubStepUnit(true);
        }
        if (bl) {
            this.setStepsDefinition(ilvDefaultStepsDefinition);
        }
    }

    public void setTimeUnit(IlvTimeUnit ilvTimeUnit) {
        boolean bl = false;
        IlvTimeStepsDefinition ilvTimeStepsDefinition = null;
        if (this.getStepsDefinition() instanceof IlvTimeStepsDefinition) {
            ilvTimeStepsDefinition = (IlvTimeStepsDefinition)this.getStepsDefinition();
        } else {
            ilvTimeStepsDefinition = new IlvTimeStepsDefinition();
            bl = true;
        }
        if (ilvTimeUnit != null) {
            ilvTimeStepsDefinition.setUnit(ilvTimeUnit);
        } else {
            ilvTimeStepsDefinition.setAutoUnit(true);
        }
        if (bl) {
            this.setStepsDefinition(ilvTimeStepsDefinition);
        }
    }

    public void setCategory(IlvDataSet ilvDataSet, boolean bl) {
        this.setStepsDefinition(new IlvCategoryStepsDefinition(bl, ilvDataSet));
    }

    public final void setCategory(boolean bl) {
        if (bl) {
            this.setCategory(null, true);
        } else {
            this.setStepUnit(null, null);
        }
    }

    public final boolean isCategory() {
        return this.t.getFlag(2048);
    }

    public void setLogarithmic(double d2) {
        if (this.getAxis() == null) {
            throw new UnsupportedOperationException("Scale should be added to a chart");
        }
        this.getAxis().setTransformer(new IlvLogarithmicAxisTransformer(d2));
        this.setStepsDefinition(new IlvLogarithmicStepsDefinition());
    }

    final Steps m() {
        return this.aj;
    }

    void a(Steps steps) {
        this.aj = steps;
    }

    final boolean n() {
        return this.getChart() != null && this.getChart().is3D();
    }

    final IlvChartProjector o() {
        return this.ae == null ? null : this.ae.f().getProjector();
    }

    final IlvChartProjector p() {
        return this.ae == null ? null : this.ae.f().getProjector2D();
    }

    public final IlvAxis getAxis() {
        return this.ae == null ? null : this.ae.c();
    }

    public final IlvAxis getDualAxis() {
        return this.ae == null ? null : this.ae.h();
    }

    public final IlvCoordinateSystem getCoordinateSystem() {
        return this.ae == null ? null : this.ae.g();
    }

    public final IlvChart getChart() {
        return this.ae == null ? null : this.ae.f();
    }

    final Rectangle q() {
        return this.ah;
    }

    void a(IlvChart.AxisElement axisElement) {
        if (this.ae != null) {
            this.ae.c().removeAxisListener(this.ag());
        }
        this.ae = axisElement;
        if (this.ae != null) {
            this.ae.c().addAxisListener(this.ag());
            if (this.getChart().isAutoScaleTitleRotation()) {
                this.a(true, false);
            }
        }
        if (this.getStepsDefinition() instanceof IlvTimeStepsDefinition) {
            ((IlvTimeStepsDefinition)this.getStepsDefinition()).k();
        }
        if (this.l()) {
            this.i().a(axisElement);
        }
    }

    final IlvChart.AxisElement r() {
        return this.ae;
    }

    synchronized void a(Rectangle rectangle, boolean bl) {
        this.a(rectangle, bl, false);
    }

    synchronized void a(Rectangle rectangle, boolean bl, boolean bl2) {
        if (!this.ah.equals(rectangle)) {
            this.ah.setBounds(rectangle);
            if (bl) {
                this.aj.n();
            } else {
                this.aj.m();
            }
            if (bl2) {
                this.a((Graphics)null);
            }
        }
        if (this.l()) {
            this.i().a(rectangle, bl);
        }
    }

    final double a(double d2) {
        return this.au.a(d2);
    }

    void a(double d2, double d3, int n2, double d4, int[] nArray) {
        double d5 = IlvMathUtil.cosDeg(d4);
        double d6 = IlvMathUtil.sinDeg(d4);
        if (this.getTickLayout() == 2) {
            nArray[0] = IlvGraphicUtil.toInt(d2);
            nArray[1] = IlvGraphicUtil.toInt(d3);
            nArray[2] = IlvGraphicUtil.toInt(d2 + (double)n2 * d5);
            nArray[3] = IlvGraphicUtil.toInt(d3 - (double)n2 * d6);
        } else if (this.getTickLayout() == 1) {
            nArray[0] = IlvGraphicUtil.toInt(d2);
            nArray[1] = IlvGraphicUtil.toInt(d3);
            nArray[2] = IlvGraphicUtil.toInt(d2 - (double)n2 * d5);
            nArray[3] = IlvGraphicUtil.toInt(d3 + (double)n2 * d6);
        } else {
            double d7 = (double)n2 * d5;
            double d8 = (double)(-n2) * d6;
            nArray[0] = IlvGraphicUtil.toInt(d2 + d7);
            nArray[1] = IlvGraphicUtil.toInt(d3 + d8);
            nArray[2] = IlvGraphicUtil.toInt(d2 - d7);
            nArray[3] = IlvGraphicUtil.toInt(d3 - d8);
        }
    }

    final double a(int n2) {
        return this.aj.b(n2).getWidth();
    }

    final double b(int n2) {
        return this.aj.b(n2).getHeight();
    }

    final String c(int n2) {
        return this.aj._labels[n2];
    }

    final IlvDoublePoints s() {
        return this.aj.h();
    }

    final IlvDoublePoints t() {
        return this.aj.i();
    }

    final IlvDoublePoints u() {
        return this.aj.j();
    }

    public final IlvDoubleArray getStepValues() {
        this.aj.a(null);
        return this.aj.f();
    }

    public final IlvDoubleArray getSubStepValues() {
        this.aj.a(null);
        return this.aj.g();
    }

    public final void recalc() {
        this.aj.m();
        this.a((Graphics)null);
    }

    final boolean a(Graphics graphics) {
        return this.au.a(graphics);
    }

    public synchronized void draw(Graphics graphics) {
        if (!this.f()) {
            return;
        }
        this.au.draw(graphics);
    }

    final boolean v() {
        return this.an != null && this.an.getText() != null;
    }

    private final void a(IlvDoublePoint ilvDoublePoint) {
        this.au.computeTitleLocation(ilvDoublePoint);
    }

    Rectangle2D a(IlvDoublePoint ilvDoublePoint, int n2, int n3, int n4, double d2, Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Double(ilvDoublePoint.x - (double)n2 / 2.0, ilvDoublePoint.y - (double)n3 / 2.0, n2, n3);
        } else {
            rectangle2D.setRect(ilvDoublePoint.x - (double)n2 / 2.0, ilvDoublePoint.y - (double)n3 / 2.0, n2, n3);
        }
        if (d2 != 0.0) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(IlvMathUtil.toRadians(d2), ilvDoublePoint.xFloor(), ilvDoublePoint.yFloor());
            rectangle2D = IlvGraphicUtil.transform(rectangle2D, affineTransform);
        }
        return rectangle2D;
    }

    int a(IlvDoublePoints ilvDoublePoints, int n2) {
        int n3 = ilvDoublePoints.size();
        if (n3 == 0 || !this.isSkippingLabel() || this.getSkipLabelMode() != 1) {
            return 1;
        }
        double[] dArray = this.m().e().data();
        boolean bl = false;
        double d2 = this.a(0);
        double d3 = this.b(0);
        IlvDoublePoint ilvDoublePoint = new IlvDoublePoint(ilvDoublePoints.getX(0), ilvDoublePoints.getY(0));
        ilvDoublePoint = this.computeLabelLocation(ilvDoublePoint, this.a(dArray[0]), n2, d2, d3);
        Rectangle2D rectangle2D = IlvScale.a(ilvDoublePoint, d2, d3, null);
        IlvGraphicUtil.grow(rectangle2D, 1.0, 1.0);
        Rectangle2D rectangle2D2 = null;
        Rectangle2D rectangle2D3 = null;
        int n4 = 1;
        int n5 = 1;
        for (int i2 = 1; i2 < n3; i2 += n4) {
            d2 = this.a(i2);
            d3 = this.b(i2);
            ilvDoublePoint.setLocation(ilvDoublePoints.getX(i2), ilvDoublePoints.getY(i2));
            ilvDoublePoint = this.computeLabelLocation(ilvDoublePoint, this.a(dArray[i2]), n2, d2, d3);
            rectangle2D2 = IlvScale.a(ilvDoublePoint, d2, d3, rectangle2D2);
            IlvGraphicUtil.grow(rectangle2D2, 1.0, 1.0);
            if (rectangle2D.intersects(rectangle2D2)) {
                ++n5;
                continue;
            }
            rectangle2D3 = rectangle2D;
            rectangle2D = rectangle2D2;
            rectangle2D2 = rectangle2D3;
            if (n5 > n4) {
                n4 = n5;
            }
            n5 = 1;
        }
        return n4;
    }

    int d(boolean bl) {
        return this.au.a(bl);
    }

    int w() {
        int n2 = this.getLabelOffset();
        if (!(this.h() || this.g() || !this.isMajorTickVisible() || this.getTickLayout() != 2 && this.getTickLayout() != 3)) {
            n2 += this.getMajorTickSize();
        }
        return n2;
    }

    void a(double d2, IlvDoublePoint ilvDoublePoint) {
        IlvDoublePoints ilvDoublePoints = this.getAxis().isXAxis() ? new IlvDoublePoints(d2, this.getCrossingValue()) : new IlvDoublePoints(this.getCrossingValue(), d2);
        this.a(ilvDoublePoints);
        ilvDoublePoint.x = ilvDoublePoints.getX(0);
        ilvDoublePoint.y = ilvDoublePoints.getY(0);
    }

    IlvDoublePoints a(double[] dArray, int n2) {
        if (n2 != 0) {
            IlvDoublePoints ilvDoublePoints = this.b(dArray, n2);
            this.a(ilvDoublePoints);
            return ilvDoublePoints;
        }
        return new IlvDoublePoints(0);
    }

    public double toValue(int n2, int n3) {
        IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(n2, n3);
        this.o().toData(ilvDoublePoints, this.q(), this.getCoordinateSystem());
        if (this.getAxis().isXAxis()) {
            return ilvDoublePoints.getX(0);
        }
        return ilvDoublePoints.getY(0);
    }

    public Point toPoint(double d2) {
        IlvDoublePoint ilvDoublePoint = new IlvDoublePoint();
        this.a(d2, ilvDoublePoint);
        return new Point(ilvDoublePoint.xFloor(), ilvDoublePoint.yFloor());
    }

    Rectangle2D a(Rectangle2D rectangle2D) {
        return this.au.getAxisBounds(rectangle2D);
    }

    private void ad() {
        this.t.setFlag(1024, false);
    }

    synchronized Rectangle a(Rectangle rectangle, Rectangle rectangle2) {
        Rectangle rectangle3 = (Rectangle)this.q().clone();
        this.a(rectangle2, true);
        rectangle = this.getBounds(rectangle).getBounds();
        this.a(rectangle3, true);
        return rectangle;
    }

    public synchronized Rectangle2D getBounds(Rectangle2D rectangle2D) {
        this.recalc();
        if (this.t.getFlag(1024)) {
            if (rectangle2D == null) {
                rectangle2D = new Rectangle(this.ai);
            } else {
                rectangle2D.setRect(this.ai);
            }
        } else {
            rectangle2D = this.a(rectangle2D);
            if (this.isLabelVisible()) {
                rectangle2D = this.b(rectangle2D);
            }
            if (!(!this.isMajorTickVisible() && !this.isMinorTickVisible() || this.isLabelVisible() && this.getTickLayout() != 3 && this.getTickLayout() != 1)) {
                rectangle2D = this.a(rectangle2D, this.isMajorTickVisible());
            }
            if (this.v()) {
                Rectangle2D rectangle2D2 = this.an.a((Rectangle2D)null);
                rectangle2D.add(rectangle2D2);
            }
            this.ai.setRect(rectangle2D);
        }
        rectangle2D = this.c(rectangle2D);
        this.t.setFlag(1024, true);
        this.au.a(rectangle2D);
        return rectangle2D;
    }

    Rectangle2D b(Rectangle2D rectangle2D) {
        int n2 = this.w();
        IlvDoublePoints ilvDoublePoints = this.u();
        double[] dArray = this.m().e().data();
        int n3 = ilvDoublePoints.size();
        Rectangle2D rectangle2D2 = null;
        IlvDoublePoint ilvDoublePoint = new IlvDoublePoint();
        for (int i2 = 0; i2 < n3; ++i2) {
            double d2 = this.a(i2);
            double d3 = this.b(i2);
            ilvDoublePoint.setLocation(ilvDoublePoints.getX(i2), ilvDoublePoints.getY(i2));
            ilvDoublePoint = this.computeLabelLocation(ilvDoublePoint, this.a(dArray[i2]), n2, d2, d3);
            rectangle2D2 = IlvScale.a(ilvDoublePoint, d2, d3, rectangle2D2);
            rectangle2D = IlvGraphicUtil.addToRect(rectangle2D, rectangle2D2);
        }
        return rectangle2D;
    }

    Rectangle2D a(Rectangle2D rectangle2D, boolean bl) {
        IlvDoublePoints ilvDoublePoints = bl ? this.aj.h() : this.aj.i();
        int n2 = ilvDoublePoints.size();
        if (n2 == 0) {
            return rectangle2D;
        }
        double[] dArray = bl ? this.aj.f().data() : this.aj.g().data();
        int n3 = this.d(bl);
        int[] nArray = new int[4];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.a(ilvDoublePoints.getX(i2), ilvDoublePoints.getY(i2), n3, this.a(dArray[i2]), nArray);
            if (this.getTickLayout() == 3) {
                IlvGraphicUtil.addToRect(rectangle2D, (double)nArray[0], (double)nArray[1]);
            }
            IlvGraphicUtil.addToRect(rectangle2D, (double)nArray[2], (double)nArray[3]);
        }
        return rectangle2D;
    }

    final void a(IlvDoublePoints ilvDoublePoints) {
        this.o().toDisplay(ilvDoublePoints, this.q(), this.getCoordinateSystem());
    }

    private IlvDoublePoints b(double[] dArray, int n2) {
        boolean bl = this.getAxis().isXAxis();
        double[] dArray2 = new double[n2];
        if (bl) {
            double d2 = this.getCrossingValue();
            for (int i2 = 0; i2 < n2; ++i2) {
                dArray2[i2] = d2;
            }
            return new IlvDoublePoints(n2, dArray, dArray2);
        }
        double d3 = this.getCrossingValue();
        for (int i3 = 0; i3 < n2; ++i3) {
            dArray2[i3] = d3;
        }
        return new IlvDoublePoints(n2, dArray2, dArray);
    }

    final int x() {
        return this.au.getScaleLength();
    }

    final int a(int n2, int n3, int n4) {
        return this.au.a(n2, n3, n4);
    }

    public IlvScaleAnnotation[] getAnnotations() {
        if (this.ao == null) {
            return null;
        }
        IlvScaleAnnotation[] ilvScaleAnnotationArray = new IlvScaleAnnotation[this.ao.size()];
        return this.ao.toArray(ilvScaleAnnotationArray);
    }

    public void setAnnotations(IlvScaleAnnotation[] ilvScaleAnnotationArray) {
        if (ilvScaleAnnotationArray == null && this.ao != null) {
            int n2 = this.ao.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.b((IlvScaleAnnotation)this.ao.get(0));
            }
            this.z();
        } else if (ilvScaleAnnotationArray != null) {
            int n3 = ilvScaleAnnotationArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                this.a(ilvScaleAnnotationArray[i3]);
            }
            this.z();
        }
    }

    List y() {
        return this.ao;
    }

    public void addAnnotation(IlvScaleAnnotation ilvScaleAnnotation) {
        this.a(ilvScaleAnnotation);
        this.z();
    }

    private void a(IlvScaleAnnotation ilvScaleAnnotation) {
        if (ilvScaleAnnotation == null) {
            throw new IllegalArgumentException();
        }
        if (ilvScaleAnnotation.getScale() != null) {
            throw new IllegalArgumentException("Annotation already attached to a scale");
        }
        if (this.ao == null) {
            this.ao = new ArrayList();
        }
        this.ao.add(ilvScaleAnnotation);
        ilvScaleAnnotation.a(this);
    }

    public void removeAnnotation(IlvScaleAnnotation ilvScaleAnnotation) {
        this.b(ilvScaleAnnotation);
        this.z();
    }

    private void b(IlvScaleAnnotation ilvScaleAnnotation) {
        if (ilvScaleAnnotation.getScale() != this) {
            throw new IllegalArgumentException("Annotation not displayed by this scale");
        }
        ilvScaleAnnotation.a((IlvScale)null);
        this.ao.remove(ilvScaleAnnotation);
        if (this.ao.size() == 0) {
            this.ao = null;
        }
    }

    Rectangle2D c(Rectangle2D rectangle2D) {
        if (this.ao == null) {
            return rectangle2D;
        }
        Rectangle2D rectangle2D2 = null;
        IlvDataInterval ilvDataInterval = this.getAxis().getVisibleRange();
        Iterator iterator = this.ao.iterator();
        while (iterator.hasNext()) {
            IlvScaleAnnotation ilvScaleAnnotation = (IlvScaleAnnotation)iterator.next();
            if (!ilvDataInterval.isInside(ilvScaleAnnotation.getValue())) continue;
            rectangle2D2 = ilvScaleAnnotation.getBounds(rectangle2D2);
            IlvGraphicUtil.addToRect(rectangle2D, rectangle2D2);
        }
        return rectangle2D;
    }

    void a(IlvDoubleArray ilvDoubleArray, IlvDoubleArray ilvDoubleArray2) {
        block21: {
            ilvDoubleArray.reset();
            ilvDoubleArray2.reset();
            IlvStepsDefinition ilvStepsDefinition = this.getStepsDefinition();
            if (ilvStepsDefinition == null) {
                return;
            }
            ilvStepsDefinition.update();
            IlvAxisTransformer ilvAxisTransformer = this.getAxis().getTransformer();
            boolean bl = ilvAxisTransformer != null && ilvStepsDefinition.a();
            IlvDataInterval ilvDataInterval = bl ? this.getAxis().getTVisibleRange() : this.getAxis().getVisibleRange();
            try {
                double d2 = ilvDataInterval.getMin();
                if (!ilvStepsDefinition.hasNext(d2)) {
                    return;
                }
                double d3 = ilvDataInterval.getMax();
                if (ilvStepsDefinition.hasSubStep()) {
                    double d4 = ilvStepsDefinition.b(d2);
                    if ((d2 = ilvStepsDefinition.a(d2)) == d4) {
                        d4 = ilvStepsDefinition.incrementSubStep(d4);
                    }
                    while (d4 < d2 && !IlvMathUtil.equals(d4, d2)) {
                        if (bl) {
                            ilvDoubleArray2.add(ilvAxisTransformer.inverse(d4));
                        } else {
                            ilvDoubleArray2.add(d4);
                        }
                        d4 = ilvStepsDefinition.incrementSubStep(d4);
                    }
                    while (d2 <= d3) {
                        if (bl) {
                            ilvDoubleArray.add(ilvAxisTransformer.inverse(d2));
                        } else {
                            ilvDoubleArray.add(d2);
                        }
                        d4 = ilvStepsDefinition.b(d2);
                        if (d2 == d4) {
                            d4 = ilvStepsDefinition.incrementSubStep(d4);
                        }
                        if (ilvStepsDefinition.hasNext(d2)) {
                            d2 = ilvStepsDefinition.incrementStep(d2);
                            while (d4 < d2 && d4 <= d3 && !IlvMathUtil.equals(d4, d2)) {
                                if (bl) {
                                    ilvDoubleArray2.add(ilvAxisTransformer.inverse(d4));
                                } else {
                                    ilvDoubleArray2.add(d4);
                                }
                                d4 = ilvStepsDefinition.incrementSubStep(d4);
                            }
                            continue;
                        }
                        break block21;
                    }
                    break block21;
                }
                d2 = ilvStepsDefinition.a(d2);
                while (d2 <= d3) {
                    if (bl) {
                        ilvDoubleArray.add(ilvAxisTransformer.inverse(d2));
                    } else {
                        ilvDoubleArray.add(d2);
                    }
                    if (ilvStepsDefinition.hasNext(d2)) {
                        d2 = ilvStepsDefinition.incrementStep(d2);
                        continue;
                    }
                    break;
                }
            }
            catch (IlvAxisTransformerException ilvAxisTransformerException) {
                ilvAxisTransformerException.printStackTrace();
                ilvDoubleArray.reset();
                ilvDoubleArray2.reset();
            }
        }
    }

    public Rectangle2D getLabelBounds(int n2, Rectangle2D rectangle2D) {
        if (n2 >= this.getLabelCount()) {
            throw new IndexOutOfBoundsException("Invalid step label index");
        }
        this.m().a(null);
        IlvDoublePoints ilvDoublePoints = this.u();
        double d2 = this.a(n2);
        double d3 = this.b(n2);
        IlvDoublePoint ilvDoublePoint = new IlvDoublePoint(ilvDoublePoints.getX(n2), ilvDoublePoints.getY(n2));
        double d4 = this.m().e().get(n2);
        ilvDoublePoint = this.computeLabelLocation(ilvDoublePoint, this.a(d4), this.w(), d2, d3);
        return IlvScale.a(ilvDoublePoint, d2, d3, rectangle2D);
    }

    public int getLabelCount() {
        return this.u().size();
    }

    public double getLabelValue(int n2) {
        if (n2 >= this.getLabelCount()) {
            throw new IndexOutOfBoundsException("Invalid step label index");
        }
        return this.m().e().get(n2);
    }

    public String computeLabel(double d2) {
        if (this.getLabelFormat() != null) {
            return this.getLabelFormat().formatValue(d2);
        }
        return this.getStepsDefinition() == null ? "" : this.getStepsDefinition().computeLabel(d2);
    }

    public final IlvValueFormat getLabelFormat() {
        return this.ap;
    }

    public void setLabelFormat(IlvValueFormat ilvValueFormat) {
        this.ap = ilvValueFormat;
        this.m().o();
        this.z();
    }

    private final boolean ae() {
        IlvAxis.Crossing crossing = this.getCrossing();
        return crossing != IlvAxis.MIN_VALUE && crossing != IlvAxis.MAX_VALUE;
    }

    private void af() {
        if (this.getAxis().isXAxis()) {
            int n2 = this.getChart().getYAxisCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                IlvScale ilvScale = this.getChart().getYScale(i2);
                if (ilvScale == null || !ilvScale.ae()) continue;
                ilvScale.m().n();
            }
        } else {
            IlvScale ilvScale = this.getChart().getXScale();
            if (ilvScale != null && ilvScale.ae()) {
                ilvScale.m().n();
            }
        }
    }

    private synchronized AxisListener ag() {
        if (this.af == null) {
            this.af = this.ah();
        }
        return this.af;
    }

    private AxisListener ah() {
        return new AxisLST();
    }

    protected IlvDoublePoint computeLabelLocation(IlvDoublePoint ilvDoublePoint, double d2, int n2, double d3, double d4) {
        return IlvGraphicUtil.computeTextLocation(ilvDoublePoint, d2, n2, d3, d4);
    }

    static final Rectangle2D a(IlvDoublePoint ilvDoublePoint, double d2, double d3, Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Double(ilvDoublePoint.x - d2 / 2.0, ilvDoublePoint.y - d3 / 2.0, d2, d3);
        } else {
            rectangle2D.setRect(ilvDoublePoint.x - d2 / 2.0, ilvDoublePoint.y - d3 / 2.0, d2, d3);
        }
        return rectangle2D;
    }

    static IlvDoublePoint a(IlvDoublePoint ilvDoublePoint, double d2, int n2, double d3, double d4, double d5) {
        double d6;
        double d7;
        double d8;
        double d9;
        if (d5 == 0.0) {
            d9 = d3;
            d8 = d4;
        } else {
            d7 = IlvMathUtil.cosDeg(d5);
            d6 = IlvMathUtil.sinDeg(d5);
            d9 = Math.abs(d3 * d7) + Math.abs(d4 * d6);
            d8 = Math.abs(d3 * d6) + Math.abs(d4 * d7);
        }
        d7 = IlvMathUtil.cosDeg(d2);
        d6 = IlvMathUtil.sinDeg(d2);
        double d10 = Math.min(d7 == 0.0 ? 100000.0 : Math.abs(d9 / (2.0 * d7)), d6 == 0.0 ? 100000.0 : Math.abs(d8 / (2.0 * d6)));
        d10 = n2 < 0 ? (double)n2 - d10 : (d10 += (double)n2);
        ilvDoublePoint.x += d10 * d7;
        ilvDoublePoint.y += -d10 * d6;
        return ilvDoublePoint;
    }

    void z() {
        IlvChart.Area area;
        this.ad();
        IlvChart.Area area2 = area = this.getChart() != null ? this.getChart().getChartArea() : null;
        if (area != null) {
            area.revalidate();
            area.repaint();
        }
    }

    private void ai() {
        this.ah = new Rectangle(0, 0, -1, -1);
        this.ai = new Rectangle();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.ai();
    }

    public void drawHighlight(Graphics graphics) {
        this.au.drawSelection(graphics);
    }

    public boolean hit(Point2D point2D) {
        return this.au.contains(point2D);
    }

    public static int getAxisIndex(IlvScale ilvScale) {
        if (ilvScale.ae == null) {
            throw new IllegalArgumentException("scale not connected to a chart.");
        }
        return ilvScale.ae.b();
    }

    class AxisLST
    implements AxisListener,
    Serializable {
        AxisLST() {
        }

        public void axisRangeChanged(AxisRangeEvent axisRangeEvent) {
            if (axisRangeEvent.isVisibleRangeEvent() && axisRangeEvent.isChangedEvent()) {
                IlvScale.this.af();
                IlvScale.this.m().m();
                if (!axisRangeEvent.isAdjusting()) {
                    IlvScale.this.z();
                }
            }
        }

        public void axisChanged(AxisChangeEvent axisChangeEvent) {
            if (axisChangeEvent.getType() != 1) {
                if (axisChangeEvent.getType() == 2) {
                    IlvScale.this.m().m();
                }
                IlvScale.this.af();
            }
            if (!axisChangeEvent.isAdjusting()) {
                IlvScale.this.z();
            }
        }
    }

    final class Title
    implements Serializable {
        transient IlvDoublePoint a;
        int b = 50;
        String c;
        IlvLabelRenderer d;

        public Title(String string, double d2) {
            this.c = string;
            this.d = new IlvLabelRenderer(){

                public void stateChanged() {
                    IlvScale.this.z();
                }
            };
            this.d.setRotation(d2);
            this.b();
        }

        public void setText(String string) {
            this.c = string;
            this.stateChanged();
        }

        public String getText() {
            return this.c;
        }

        public IlvLabelRenderer getLabelRenderer() {
            return this.d;
        }

        public void setPlacement(int n2) {
            if (n2 > 100) {
                n2 = 100;
            } else if (n2 < 0) {
                n2 = 0;
            }
            this.b = n2;
            this.stateChanged();
        }

        public int getPlacement() {
            return this.b;
        }

        public Dimension2D getSize2D(boolean bl) {
            return this.d.getSize2D(IlvScale.this.getChart().getChartArea(), this.c, true, bl);
        }

        void a(Graphics graphics) {
            this.d.paintLabel(IlvScale.this.getChart().getChartArea(), graphics, this.c, this.a.xFloor(), this.a.yFloor());
        }

        void a() {
            if (this.c != null) {
                IlvScale.this.a(this.a);
            }
        }

        Rectangle2D a(Rectangle2D rectangle2D) {
            return this.d.getBounds(IlvScale.this.getChart().getChartArea(), this.a.xFloor(), this.a.yFloor(), this.c, rectangle2D);
        }

        protected void stateChanged() {
            IlvScale.this.z();
        }

        private void b() {
            this.a = new IlvDoublePoint();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.b();
        }
    }

    class RadialSteps
    extends Steps {
        RadialSteps() {
        }

        protected String[] computeLabels() {
            if (((IlvPolarProjector)IlvScale.this.p()).isSymmetric()) {
                IlvDoubleArray ilvDoubleArray = IlvScale.this.g() ? this._subValues : this._values;
                int n2 = ilvDoubleArray.size();
                String[] stringArray = this._labels.length == n2 ? this._labels : new String[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    double d2 = ilvDoubleArray.get(i2);
                    if (d2 < 0.0) {
                        d2 = -d2;
                    }
                    stringArray[i2] = IlvScale.this.computeLabel(d2);
                }
                return stringArray;
            }
            return super.computeLabels();
        }
    }

    class CircularSteps
    extends Steps {
        CircularSteps() {
        }

        void a() {
            double d2;
            super.a();
            int n2 = this._values.size();
            if (n2 > 1 && (d2 = this._values.get(n2 - 1)) == IlvScale.this.getAxis().getVisibleMax()) {
                this._values.remove(n2 - 1, 1);
            }
        }
    }

    class Steps
    implements Serializable {
        protected transient String[] _labels;
        protected transient IlvDoubleArray _values;
        protected transient IlvDoubleArray _subValues;
        protected transient IlvDoublePoints _points;
        protected transient IlvDoublePoints _subPoints;
        private transient double a;
        private transient double b;
        private transient boolean c;
        private transient boolean d;
        private transient boolean e;
        private transient IlvTextRenderer[] f;
        private transient boolean g;
        private transient Font h;

        Steps() {
            this.s();
        }

        boolean a(Graphics graphics) {
            boolean bl = false;
            if (!this.p()) {
                this.a();
                this.b();
                this.c();
                this.d();
                bl = true;
            } else {
                if (!this.r()) {
                    this.b();
                    bl = true;
                }
                if (!this.q()) {
                    this.c();
                    this.d();
                    bl = true;
                } else {
                    boolean bl2 = bl = this.b(false) || bl;
                }
            }
            if (bl) {
                IlvScale.this.ad();
            }
            return bl;
        }

        protected String[] computeLabels() {
            IlvDoubleArray ilvDoubleArray = IlvScale.this.g() ? this._subValues : this._values;
            int n2 = ilvDoubleArray.size();
            String[] stringArray = this._labels.length == n2 ? this._labels : new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                stringArray[i2] = IlvScale.this.computeLabel(ilvDoubleArray.get(i2));
            }
            return stringArray;
        }

        void a() {
            this.c = true;
            IlvScale.this.a(this._values, this._subValues);
        }

        void b() {
            this.d = true;
            this._points = IlvScale.this.a((double[])this._values.data().clone(), this._values.size());
            this._subPoints = IlvScale.this.a((double[])this._subValues.data().clone(), this._subValues.size());
        }

        void c() {
            this._labels = this.computeLabels();
            this.e = true;
        }

        void a(double d2) {
            int n2 = this.f.length;
            while (--n2 >= 0) {
                this.f[n2].setRotation(d2);
            }
        }

        void a(int n2) {
            int n3 = this.f.length;
            while (--n3 >= 0) {
                this.f[n3].setAlignment(n2);
            }
        }

        void a(boolean bl) {
            int n2 = this.f.length;
            while (--n2 >= 0) {
                this.f[n2].setAutoWrapping(bl);
            }
        }

        void a(float f2) {
            int n2 = this.f.length;
            while (--n2 >= 0) {
                this.f[n2].setWrappingWidth(f2);
            }
            IlvScale.this.ad();
        }

        void d() {
            int n2;
            String[] stringArray = this._labels;
            int n3 = stringArray.length;
            int n4 = Math.min(this.f.length, n3);
            IlvTextRenderer[] ilvTextRendererArray = n3 == n4 ? this.f : new IlvTextRenderer[n3];
            for (n2 = 0; n2 < n4; ++n2) {
                ilvTextRendererArray[n2] = this.a(stringArray[n2], this.f[n2]);
            }
            while (n2 < n3) {
                ilvTextRendererArray[n2] = this.a(stringArray[n2], null);
                ++n2;
            }
            this.f = ilvTextRendererArray;
            this.b(true);
        }

        boolean b(boolean bl) {
            int n2;
            boolean bl2;
            boolean bl3 = false;
            Font font = IlvScale.this.getLabelFont();
            boolean bl4 = IlvScale.this.d();
            boolean bl5 = bl || this.g != bl4;
            boolean bl6 = bl2 = bl || this.h == null || !this.h.equals(font);
            if (bl2 || bl5) {
                this.g = bl4;
                this.h = font;
                double d2 = 0.0;
                double d3 = 0.0;
                int n3 = this.f.length;
                while (--n3 >= 0) {
                    Rectangle2D rectangle2D;
                    IlvTextRenderer ilvTextRenderer = this.f[n3];
                    if (bl5) {
                        ilvTextRenderer.setAntiAliased(bl4);
                    }
                    if (bl2) {
                        ilvTextRenderer.setFont(font);
                    }
                    if ((rectangle2D = ilvTextRenderer.getBounds(true)).getWidth() > d2) {
                        d2 = rectangle2D.getWidth();
                    }
                    if (!(rectangle2D.getHeight() > d3)) continue;
                    d3 = rectangle2D.getHeight();
                }
                this.a = d2;
                this.b = d3;
                bl3 = true;
            }
            if (IlvScale.this.isAutoWrapping() && (n2 = this.f.length) > 0) {
                if (n2 > 1) {
                    --n2;
                }
                float f2 = IlvScale.this.x() / n2;
                bl3 = (f2 = Math.max(6.0f, f2 - 4.0f)) != this.f[0].getWrappingWidth();
                this.a(f2);
            }
            return bl3;
        }

        final IlvTextRenderer b(int n2) {
            return this.f[n2];
        }

        IlvTextRenderer a(String string, IlvTextRenderer ilvTextRenderer) {
            if (ilvTextRenderer == null) {
                ilvTextRenderer = new IlvTextRenderer(string);
            } else {
                ilvTextRenderer.setText(string);
            }
            ilvTextRenderer.setAutoWrapping(IlvScale.this.isAutoWrapping());
            ilvTextRenderer.setRotation(IlvScale.this.getLabelRotation());
            ilvTextRenderer.setAlignment(IlvScale.this.getLabelAlignment());
            return ilvTextRenderer;
        }

        final IlvDoubleArray e() {
            return IlvScale.this.g() ? this.g() : this.f();
        }

        final IlvDoubleArray f() {
            return this._values;
        }

        final IlvDoubleArray g() {
            return this._subValues;
        }

        final IlvDoublePoints h() {
            return this._points;
        }

        final IlvDoublePoints i() {
            return this._subPoints;
        }

        final IlvDoublePoints j() {
            return IlvScale.this.g() ? this._subPoints : this._points;
        }

        final double k() {
            return this.a;
        }

        final double l() {
            return this.b;
        }

        void m() {
            this.c = false;
        }

        void n() {
            this.d = false;
        }

        void o() {
            this.e = false;
        }

        final boolean p() {
            return this.c;
        }

        final boolean q() {
            return this.e;
        }

        final boolean r() {
            return this.d && !IlvScale.this.n();
        }

        private void s() {
            this._values = new IlvDoubleArray(0);
            this._subValues = new IlvDoubleArray(0);
            this.f = new IlvTextRenderer[0];
            this._labels = new String[0];
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.s();
        }
    }
}

