/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvCoordinateSystem;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDataWindow;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.IlvPolarProjector;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

class IlvRadarProjector
extends IlvPolarProjector {
    public IlvRadarProjector() {
        this.setSymmetric(false);
        this.setStartingAngle(90.0);
    }

    public Shape getShape(IlvDataWindow ilvDataWindow, Rectangle rectangle, IlvCoordinateSystem ilvCoordinateSystem) {
        if (ilvDataWindow.equals(ilvCoordinateSystem.getVisibleWindow())) {
            double d2 = ilvCoordinateSystem.getYAxis().isReversed() ? ilvDataWindow.getYMin() : ilvDataWindow.getYMax();
            return this.getShape(d2, 2, rectangle, ilvCoordinateSystem);
        }
        return super.getShape(ilvDataWindow, rectangle, ilvCoordinateSystem);
    }

    public Shape getShape(double d2, int n2, Rectangle rectangle, IlvCoordinateSystem ilvCoordinateSystem) {
        if (n2 == 2) {
            IlvDataInterval ilvDataInterval = ilvCoordinateSystem.getXAxis().getVisibleRange();
            return this.getShape(d2, ilvDataInterval, n2, rectangle, ilvCoordinateSystem);
        }
        return super.getShape(d2, n2, rectangle, ilvCoordinateSystem);
    }

    public Shape getShape(double d2, IlvDataInterval ilvDataInterval, int n2, Rectangle rectangle, IlvCoordinateSystem ilvCoordinateSystem) {
        IlvDataInterval ilvDataInterval2;
        if (n2 == 2 && (ilvDataInterval2 = ilvCoordinateSystem.getXAxis().getVisibleRange()).equals(ilvDataInterval)) {
            double d3;
            IlvDoublePoints ilvDoublePoints = new IlvDoublePoints((int)ilvDataInterval2.getLength());
            double d4 = d2;
            for (double d5 = d3 = Math.ceil(ilvDataInterval2.getMin()); d5 <= ilvDataInterval2.getMax(); d5 += 1.0) {
                ilvDoublePoints.add(d5, d4);
            }
            if (ilvDoublePoints.size() == 0) {
                return new Rectangle(0, 0, 0, 0);
            }
            this.toDisplay(ilvDoublePoints, rectangle, ilvCoordinateSystem);
            double[] dArray = ilvDoublePoints.getXValues();
            double[] dArray2 = ilvDoublePoints.getYValues();
            int n3 = ilvDoublePoints.size();
            GeneralPath generalPath = new GeneralPath(1, n3 + 1);
            generalPath.moveTo((float)dArray[0], (float)dArray2[0]);
            for (int i2 = 1; i2 < n3; ++i2) {
                generalPath.lineTo((float)dArray[i2], (float)dArray2[i2]);
            }
            generalPath.closePath();
            return generalPath;
        }
        return super.getShape(d2, ilvDataInterval, n2, rectangle, ilvCoordinateSystem);
    }
}

