/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.feed.toolkit.pool;

import hk.com.realink.feed.toolkit.pool.ObjectFIFO;
import hk.com.realink.feed.toolkit.pool.PoolProcessInterface;
import hk.com.realink.feed.toolkit.pool.ThreadPoolWorker;

public class ThreadPool {
    private ObjectFIFO idleWorkers;
    private ThreadPoolWorker[] workerList;

    public ThreadPool(int numberOfThreads) {
        numberOfThreads = Math.max(1, numberOfThreads);
        this.idleWorkers = new ObjectFIFO(numberOfThreads);
        this.workerList = new ThreadPoolWorker[numberOfThreads];
        for (int i2 = 0; i2 < this.workerList.length; ++i2) {
            this.workerList[i2] = new ThreadPoolWorker(this.idleWorkers);
        }
    }

    public int getIdleSize() {
        return this.idleWorkers.getSize();
    }

    public void execute(PoolProcessInterface target) throws InterruptedException {
        ThreadPoolWorker worker = (ThreadPoolWorker)this.idleWorkers.remove();
        worker.process(target);
    }

    public void stopRequestIdleWorkers() {
        try {
            Object[] idle = this.idleWorkers.removeAll();
            for (int i2 = 0; i2 < idle.length; ++i2) {
                ((ThreadPoolWorker)idle[i2]).stopRequest();
            }
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
        }
    }

    public void stopRequestAllWorkers() {
        this.stopRequestIdleWorkers();
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException x) {
            // empty catch block
        }
        for (int i2 = 0; i2 < this.workerList.length; ++i2) {
            if (!this.workerList[i2].isAlive()) continue;
            this.workerList[i2].stopRequest();
        }
    }
}

