/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.feed.toolkit.pool;

import hk.com.realink.feed.toolkit.pool.ConnectionReaper;
import hk.com.realink.feed.toolkit.pool.JDCConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;

public class JDCConnectionPool {
    private Vector connections;
    private String url;
    private String user;
    private String password;
    private final long timeout = 60000L;
    private ConnectionReaper reaper;
    private final int poolsize = 10;

    public JDCConnectionPool(String url, String user, String password) {
        this.url = url;
        this.user = user;
        this.password = password;
        this.connections = new Vector(10);
        this.reaper = new ConnectionReaper(this);
        this.reaper.start();
    }

    public int getConnectionSize() {
        return this.connections.size();
    }

    public synchronized void reapConnections() {
        long stale = System.currentTimeMillis() - 60000L;
        Enumeration connlist = this.connections.elements();
        while (connlist != null && connlist.hasMoreElements()) {
            JDCConnection conn = (JDCConnection)connlist.nextElement();
            if (!conn.inUse() || stale <= conn.getLastUse() || conn.validate()) continue;
            this.removeConnection(conn);
        }
    }

    public synchronized void closeConnections() {
        Enumeration connlist = this.connections.elements();
        while (connlist != null && connlist.hasMoreElements()) {
            JDCConnection conn = (JDCConnection)connlist.nextElement();
            this.removeConnection(conn);
        }
    }

    private synchronized void removeConnection(JDCConnection conn) {
        this.connections.removeElement(conn);
    }

    public synchronized Connection getConnection() throws SQLException {
        JDCConnection c2;
        for (int i2 = 0; i2 < this.connections.size(); ++i2) {
            c2 = (JDCConnection)this.connections.elementAt(i2);
            if (!c2.lease()) continue;
            return c2;
        }
        Connection conn = DriverManager.getConnection(this.url, this.user, this.password);
        c2 = new JDCConnection(conn, this);
        c2.lease();
        this.connections.addElement(c2);
        return c2;
    }

    public synchronized void returnConnection(JDCConnection conn) {
        conn.expireLease();
    }
}

