/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.feed.toolkit.pool;

import hk.com.realink.feed.toolkit.pool.CachedObject;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class CacheManager {
    private HashMap keysHash = null;
    private int controlSize = 1001;
    private int reductSize = 5;

    public CacheManager() {
        this.keysHash = new HashMap(this.controlSize);
    }

    public CacheManager(int controlSize) {
        this.controlSize = controlSize;
        this.keysHash = new HashMap(this.controlSize);
    }

    public int getCachedSize() {
        return this.keysHash.size();
    }

    public int getControlSize() {
        return this.controlSize;
    }

    public void setCachedSize(int controlSize) {
        this.controlSize = controlSize;
    }

    public void setReductSize(int size) {
        this.reductSize = size;
    }

    public static void main(String[] args) {
        String[] keys = new String[]{"10", "2", "1", "345", "7", "9", "45", "6", "21", "456", "2", "978", "2344", "343", "320", "121", "54", "345", "76", "65", "5645", "4346", "543", "4546", "4535", "9528", "2344", "343", "1320", "45", "656", "345", "88", "659", "465", "535", "254", "455", "2", "9578", "2344", "3334"};
        CacheManager cacheManager = new CacheManager(16);
        for (int i2 = 0; i2 < keys.length; ++i2) {
            Object[] rmKeys = cacheManager.addCacheObjKey(keys[i2]);
            System.out.println("request key : " + keys[i2]);
            if (rmKeys != null) {
                System.out.println("remove keys : " + Arrays.asList(rmKeys));
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        System.out.println("current cached keys : " + Arrays.asList(cacheManager.getCashedKeys()));
    }

    public Object[] getCashedKeys() {
        return this.keysHash.keySet().toArray();
    }

    public Object[] addCacheObjKey(Object key) {
        this.keysHash.put(key, new CachedObject(key));
        int keysSize = this.keysHash.size();
        if (keysSize > this.controlSize && keysSize > 5) {
            ArrayList chObjList = new ArrayList(this.keysHash.values());
            Collections.sort(chObjList);
            int tmpReductSize = this.reductSize;
            if (keysSize < tmpReductSize) {
                tmpReductSize = 1;
            }
            ArrayList rmList = new ArrayList(((AbstractList)chObjList).subList(0, tmpReductSize));
            Iterator rmIter = ((AbstractList)rmList).iterator();
            ArrayList<Object> keysList = new ArrayList<Object>(rmList.size());
            while (rmIter.hasNext()) {
                Object rmKey = ((CachedObject)rmIter.next()).getKey();
                this.keysHash.remove(rmKey);
                keysList.add(rmKey);
            }
            return keysList.toArray();
        }
        return null;
    }
}

