/*
 * Decompiled with CFR 0.152.
 */
package omni.obj.client;

import hk.com.realink.feed.toolkit.b;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import omni.db.RecMarketItem;
import omni.obj.client.Dataizable;
import omni.obj.client.Series;

public class MarketMap
implements Dataizable {
    public TreeMap marketMap = new TreeMap();

    public MarketMap() {
        this.load();
    }

    public final void load() {
        Object object = new ArrayList<RecMarketItem>();
        ((ArrayList)object).add(new RecMarketItem(1, "CHH", "CHH FUTURES"));
        ((ArrayList)object).add(new RecMarketItem(2, "SFU2", "STOCK FUTURES, DEC=2"));
        ((ArrayList)object).add(new RecMarketItem(3, "EF3", "3-Y EXCHANGE FUND NOTES FUTURES"));
        ((ArrayList)object).add(new RecMarketItem(8, "COM", "COM FUTURES"));
        ((ArrayList)object).add(new RecMarketItem(16, "MHI", "MHI FUTURES"));
        ((ArrayList)object).add(new RecMarketItem(20, "SOM", "STOCK OPTIONS"));
        ((ArrayList)object).add(new RecMarketItem(24, "HIB", "HIBOR FUTURES"));
        ((ArrayList)object).add(new RecMarketItem(27, "DJI", "DJI FUTURES"));
        ((ArrayList)object).add(new RecMarketItem(34, "HSI", "HSI FUTURES"));
        ((ArrayList)object).add(new RecMarketItem(35, "XHS", "XHS OPTIONS"));
        ((ArrayList)object).add(new RecMarketItem(37, "XHH", "XHH OPTIONS"));
        ((ArrayList)object).add(new RecMarketItem(38, "HHI", "HHI FUTURES"));
        ((ArrayList)object).add(new RecMarketItem(51, "VOL", "VOL FUTURES"));
        ((ArrayList)object).add(new RecMarketItem(60, "FXC", "FXC FUTURES"));
        ((ArrayList)object).add(new RecMarketItem(70, "CNY", "CNY FUTURES"));
        ((ArrayList)object).add(new RecMarketItem(90, "RSO", "RSO FUTURES"));
        ((ArrayList)object).add(new RecMarketItem(93, "SI1", "SI1 FUTURES"));
        ((ArrayList)object).add(new RecMarketItem(96, "SI2", "SI2 FUTURES"));
        ((ArrayList)object).add(new RecMarketItem(99, "SI3", "SI3 FUTURES"));
        ((ArrayList)object).add(new RecMarketItem(100, "SI4", "SI4 FUTURES"));
        ((ArrayList)object).add(new RecMarketItem(102, "MCX", "MCX FUTURES"));
        ((ArrayList)object).add(new RecMarketItem(120, "LRF", "LRF FUTURES"));
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            RecMarketItem recMarketItem = (RecMarketItem)object.next();
            this.marketMap.put(recMarketItem.series.getMarketKey(), recMarketItem);
        }
        b.warning(null, "[MARKET]marketMap.size()=" + this.marketMap.size() + " loaded.");
    }

    public void readExternal(DataInput dataInput) throws IOException {
        int n2 = dataInput.readInt();
        for (int i2 = 0; i2 < n2; ++i2) {
            RecMarketItem recMarketItem = new RecMarketItem();
            recMarketItem.readExternal(dataInput);
            this.marketMap.put(recMarketItem.series.getKey(), recMarketItem);
        }
    }

    public void writeExternal(DataOutput dataOutput) throws IOException {
        Iterator iterator = this.marketMap.values().iterator();
        dataOutput.writeInt(this.marketMap.size());
        while (iterator.hasNext()) {
            RecMarketItem recMarketItem = (RecMarketItem)iterator.next();
            recMarketItem.writeExternal(dataOutput);
        }
    }

    public RecMarketItem getRecMarket(Series series2) {
        return (RecMarketItem)this.marketMap.get(series2.getMarketKey());
    }

    public RecMarketItem[] getRecMarkets() {
        return this.marketMap.values().toArray(new RecMarketItem[0]);
    }

    public String toString() {
        return this.marketMap.toString();
    }
}

