/*
 * Decompiled with CFR 0.152.
 */
package omni.db;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TreeMap;
import omni.db.RecInstrumentItem;
import omni.obj.client.Dataizable;
import omni.obj.client.STATUS;
import omni.obj.client.Series;

public class RecUnderlyingItem
implements Dataizable {
    public Series series = new Series();
    public int underlying_id;
    public String com_id;
    public String isin_code;
    public int dec_in_price;
    public String date_release;
    public String date_termination;
    public String date_dated;
    public String name;
    public String base_cur;
    public int deliverable;
    public int coupon_frequency;
    public int nominal_value;
    public int day_count;
    public int days_in_interest_year;
    public int coupon_interest;
    public int coupon_settlement_days;
    public int underlying_type;
    public int price_unit;
    public int dec_in_nominal;
    public int fixed_income_type;
    public int items;
    public TreeMap instrumentMap = new TreeMap();

    public RecUnderlyingItem dataClone() throws IOException {
        Closeable closeable = new ByteArrayOutputStream();
        Object object = new DataOutputStream((OutputStream)closeable);
        this.writeExternal((DataOutput)object);
        ((DataOutputStream)object).flush();
        closeable = new ByteArrayInputStream(closeable.toByteArray());
        closeable = new DataInputStream((InputStream)closeable);
        object = new RecUnderlyingItem();
        ((RecUnderlyingItem)object).readExternal((DataInput)((Object)closeable));
        return object;
    }

    public void writeExternal(DataOutput dataOutput) throws IOException {
        this.series.writeExternal(dataOutput);
        dataOutput.writeInt(this.underlying_id);
        dataOutput.writeUTF(this.com_id);
        dataOutput.writeUTF(this.isin_code);
        dataOutput.writeInt(this.dec_in_price);
        dataOutput.writeUTF(this.date_release);
        dataOutput.writeUTF(this.date_termination);
        dataOutput.writeUTF(this.date_dated);
        dataOutput.writeUTF(this.name);
        dataOutput.writeUTF(this.base_cur);
        dataOutput.writeInt(this.deliverable);
        dataOutput.writeInt(this.coupon_frequency);
        dataOutput.writeInt(this.nominal_value);
        dataOutput.writeInt(this.day_count);
        dataOutput.writeInt(this.days_in_interest_year);
        dataOutput.writeInt(this.coupon_interest);
        dataOutput.writeInt(this.coupon_settlement_days);
        dataOutput.writeInt(this.underlying_type);
        dataOutput.writeInt(this.price_unit);
        dataOutput.writeInt(this.dec_in_nominal);
        dataOutput.writeInt(this.fixed_income_type);
        dataOutput.writeInt(this.items);
        dataOutput.writeInt(this.instrumentMap.size());
        for (RecInstrumentItem recInstrumentItem : this.instrumentMap.values()) {
            recInstrumentItem.writeExternal(dataOutput);
        }
    }

    public void readExternal(DataInput dataInput) throws IOException {
        this.series = new Series();
        this.series.readExternal(dataInput);
        this.underlying_id = dataInput.readInt();
        this.com_id = dataInput.readUTF();
        this.isin_code = dataInput.readUTF();
        this.dec_in_price = dataInput.readInt();
        this.date_release = dataInput.readUTF();
        this.date_termination = dataInput.readUTF();
        this.date_dated = dataInput.readUTF();
        this.name = dataInput.readUTF();
        this.base_cur = dataInput.readUTF();
        this.deliverable = dataInput.readInt();
        this.coupon_frequency = dataInput.readInt();
        this.nominal_value = dataInput.readInt();
        this.day_count = dataInput.readInt();
        this.days_in_interest_year = dataInput.readInt();
        this.coupon_interest = dataInput.readInt();
        this.coupon_settlement_days = dataInput.readInt();
        this.underlying_type = dataInput.readInt();
        this.price_unit = dataInput.readInt();
        this.dec_in_nominal = dataInput.readInt();
        this.fixed_income_type = dataInput.readInt();
        this.items = dataInput.readInt();
        int n2 = dataInput.readInt();
        for (int i2 = 0; i2 < n2; ++i2) {
            RecInstrumentItem recInstrumentItem = new RecInstrumentItem();
            recInstrumentItem.readExternal(dataInput);
            this.instrumentMap.put(recInstrumentItem.series.getInstrumentGroupKey(), recInstrumentItem);
        }
    }

    public RecInstrumentItem getRecInstrumentItem(Series series2) {
        return (RecInstrumentItem)this.instrumentMap.get(series2.getInstrumentGroupKey());
    }

    public RecInstrumentItem putRecInstrumentItem(Series series2, RecInstrumentItem recInstrumentItem) {
        return this.instrumentMap.put(series2.getInstrumentGroupKey(), recInstrumentItem);
    }

    public RecInstrumentItem[] getRecInstrumentItems() {
        return this.instrumentMap.values().toArray(new RecInstrumentItem[0]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[RecUnderlyingItem]");
        stringBuffer.append(STATUS.LF);
        stringBuffer.append("series=" + this.series.toString() + ", com_id=" + this.com_id + ", name=" + this.name);
        stringBuffer.append(STATUS.LF);
        for (RecInstrumentItem recInstrumentItem : this.instrumentMap.values()) {
            stringBuffer.append(recInstrumentItem.toString());
            stringBuffer.append(STATUS.LF);
        }
        stringBuffer.append("[RecUnderlyingItem]");
        return stringBuffer.toString();
    }
}

