/*
 * Decompiled with CFR 0.152.
 */
package omni.db;

import hk.com.realink.feed.toolkit.d;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.LinkedHashMap;
import omni.db.ComboLeg;
import omni.obj.client.Dataizable;
import omni.obj.client.Series;

public class RecSeriesItem
implements Dataizable {
    public Series series = new Series();
    public int upper_country;
    public int upper_market;
    public int upper_instrument_group;
    public int upper_modifier;
    public int upper_commodity;
    public int upper_expiration_date;
    public int upper_strike_price;
    public int contract_size;
    public String ins_id = "";
    public String isin_code = "";
    public int suspended;
    public String date_last_trading = "";
    public String time_last_trading = "";
    public String settlement_date = "";
    public String start_date = "";
    public String end_date = "";
    public String date_delivery_start = "";
    public String date_delivery_stop = "";
    public int status;
    public String base_cur = "";
    public short dec_strike;
    public short dec_contr_size;
    public byte db_op;
    public String eff_exp_date = "";
    public LinkedHashMap<String, ComboLeg> comboLegsMap = new LinkedHashMap();
    public static final byte DB_OP_INSERT = 1;
    public static final byte DB_OP_UPDATE = 2;
    public static final byte DB_OP_REMOVE = 3;
    public static final int STATUS_ACTIVE = 1;
    public static final int STATUS_SUSPEND = 2;
    public static final int STATUS_ISSUED = 3;
    public static final int STATUS_DELIST = 4;
    public static float verNum = 1.0f;

    public void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.contract_size);
        dataOutput.writeUTF(this.date_delivery_start);
        dataOutput.writeUTF(this.date_delivery_stop);
        dataOutput.writeUTF(this.date_last_trading);
        dataOutput.writeUTF(this.end_date);
        dataOutput.writeUTF(this.ins_id);
        dataOutput.writeUTF(this.isin_code);
        this.series.writeExternal(dataOutput);
        dataOutput.writeUTF(this.settlement_date);
        dataOutput.writeUTF(this.start_date);
        dataOutput.writeInt(this.status);
        dataOutput.writeInt(this.suspended);
        dataOutput.writeUTF(this.time_last_trading);
        if (verNum < 0.0f) {
            return;
        }
        dataOutput.writeUTF(this.base_cur);
        dataOutput.writeShort(this.dec_strike);
        dataOutput.writeShort(this.dec_contr_size);
        dataOutput.writeByte(this.db_op);
        dataOutput.writeShort(this.comboLegsMap.size());
        for (ComboLeg comboLeg : this.comboLegsMap.values()) {
            comboLeg.writeExternal(dataOutput);
        }
        dataOutput.writeUTF(this.eff_exp_date);
    }

    public void readExternal(DataInput dataInput) throws IOException {
        this.contract_size = dataInput.readInt();
        this.date_delivery_start = dataInput.readUTF();
        this.date_delivery_stop = dataInput.readUTF();
        this.date_last_trading = dataInput.readUTF();
        this.end_date = dataInput.readUTF();
        this.ins_id = dataInput.readUTF();
        this.isin_code = dataInput.readUTF();
        this.series.readExternal(dataInput);
        this.settlement_date = dataInput.readUTF();
        this.start_date = dataInput.readUTF();
        this.status = dataInput.readInt();
        this.suspended = dataInput.readInt();
        this.time_last_trading = dataInput.readUTF();
        if (verNum < 0.0f) {
            return;
        }
        this.base_cur = dataInput.readUTF();
        this.dec_strike = dataInput.readShort();
        this.dec_contr_size = dataInput.readShort();
        this.db_op = dataInput.readByte();
        int n2 = dataInput.readShort();
        for (int i2 = 0; i2 < n2; ++i2) {
            ComboLeg comboLeg = new ComboLeg();
            comboLeg.readExternal(dataInput);
            this.comboLegsMap.put(comboLeg.series.getKey(), comboLeg);
        }
        this.eff_exp_date = dataInput.readUTF();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ins_id=").append(this.ins_id).append(", ");
        stringBuilder.append(", isin_code=").append(this.isin_code).append(", ");
        stringBuilder.append(this.series.getKey()).append("], ");
        stringBuilder.append(this.series.toString());
        stringBuilder.append(", base_cur=").append(this.base_cur);
        stringBuilder.append(", dec_strike=").append(this.dec_strike);
        stringBuilder.append(", dec_contr_size=").append(this.dec_contr_size);
        stringBuilder.append(", date_last_trading=").append(this.date_last_trading);
        stringBuilder.append(", time_last_trading=").append(this.time_last_trading);
        stringBuilder.append(", eff_exp_date=").append(this.eff_exp_date);
        ComboLeg[] comboLegArray = this.comboLegsMap.values().toArray(new ComboLeg[0]);
        if (comboLegArray.length > 0) {
            for (int i2 = 0; i2 < comboLegArray.length; ++i2) {
                stringBuilder.append(d.LR);
                stringBuilder.append("[COMBO_LEG][").append(i2).append("]").append(comboLegArray[i2].paramString());
            }
        } else {
            stringBuilder.append(", [COMBO_LEG]size=0");
        }
        return stringBuilder.toString();
    }
}

