/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.multiWindows.queueBrokerColor;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import leaseLineQuote.f;

public class BrokerColorChecker {
    private static final BrokerColorChecker instance = new BrokerColorChecker();
    private final Map<Short, Color> fixSetting = new HashMap<Short, Color>();
    private final Map<Short, Color> custSetting = new HashMap<Short, Color>();
    private final Map<Short, Color> checkList = new HashMap<Short, Color>();

    public static final BrokerColorChecker getInstance() {
        return instance;
    }

    private BrokerColorChecker() {
        this.updateColor();
    }

    public boolean isFixBroker(short s) {
        return this.fixSetting.containsKey(s);
    }

    public Map<Short, Color> getCustSetting() {
        return this.custSetting;
    }

    public void setCustSetting(Map<Short, Color> map) {
        if (map != null) {
            this.custSetting.clear();
            this.custSetting.putAll(map);
            this.checkList.clear();
            this.checkList.putAll(map);
            this.updateColor();
        }
    }

    public void remove(short s) {
        if (this.custSetting.remove(s) != null) {
            this.checkList.remove(s);
        }
    }

    public boolean set(short s, Color color) {
        if (!this.fixSetting.containsKey(s)) {
            this.custSetting.put(s, color);
            this.checkList.put(s, color);
            return true;
        }
        return false;
    }

    public void updateColor() {
        this.fixSetting.put((short)4830, f.aA);
        this.fixSetting.put((short)4836, f.aA);
        this.fixSetting.put((short)4838, f.aA);
        this.fixSetting.put((short)4839, f.aA);
        this.checkList.putAll(this.fixSetting);
    }

    public Color getColor(short s) {
        return this.checkList.get(s);
    }
}

