/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.multiWindows.proxy;

import java.util.Properties;
import leaseLineQuote.multiWindows.util.Persistence;

public class ConnectionSetting {
    public static final int PROXY_DEFAULT = 0;
    public static final int PROXY_NO_PROXY = 1;
    public static final int PROXY_SOCKS = 2;
    public static final int PROXY_HTTP_PROXY = 3;
    private static final String SETTINGNAME = "ConnectionSetting";
    private static final String SETTING_PROXYSETTING = "ProxySetting";
    private static final String SETTING_SOCKSHOST = "SocksHost";
    private static final String SETTING_SOCKSPORT = "SocksPort";
    private static final String SETTING_HTTPPROXYHOST = "HttpProxyHost";
    private static final String SETTING_HTTPPROXYPORT = "HttpProxyPort";
    private static final String SETTING_HTTPPROXYUSER = "HttpProxyUser";
    private static final String SETTING_HTTPPROXYPWD = "HttpProxyPwd";
    private static int proxySetting = 1;
    private static String socksHost = "";
    private static int socksPort = 0;
    private static String httpProxyHost = "";
    private static int httpProxyPort = 0;
    private static String httpProxyUser = null;
    private static String httpProxyPwd = null;
    private static Properties setting = new Properties();

    private ConnectionSetting() {
    }

    public static void loadSetting() {
        if (Persistence.isPersistence()) {
            Object object;
            Properties properties = Persistence.getValue(SETTINGNAME);
            if (properties != null) {
                object = properties.propertyNames();
                while (object.hasMoreElements()) {
                    String string = (String)object.nextElement();
                    setting.setProperty(string, properties.getProperty(string));
                }
            }
            try {
                object = setting.getProperty(SETTING_PROXYSETTING);
                if (object != null) {
                    proxySetting = Integer.parseInt((String)object);
                }
            }
            catch (Exception exception) {}
            socksHost = setting.getProperty(SETTING_SOCKSHOST, "");
            try {
                object = setting.getProperty(SETTING_SOCKSPORT);
                if (object != null) {
                    socksPort = Integer.parseInt((String)object);
                }
            }
            catch (Exception exception) {}
            httpProxyHost = setting.getProperty(SETTING_HTTPPROXYHOST, "");
            try {
                object = setting.getProperty(SETTING_HTTPPROXYPORT);
                if (object != null) {
                    httpProxyPort = Integer.parseInt((String)object);
                }
            }
            catch (Exception exception) {}
            httpProxyUser = setting.getProperty(SETTING_HTTPPROXYUSER, null);
            httpProxyPwd = setting.getProperty(SETTING_HTTPPROXYPWD, null);
            if (httpProxyUser != null && httpProxyUser.length() == 0) {
                httpProxyUser = null;
            }
            if (httpProxyPwd != null && httpProxyPwd.length() == 0) {
                httpProxyPwd = null;
            }
        }
    }

    public static void saveSetting() {
        boolean bl = false;
        if (Persistence.isPersistence()) {
            setting.setProperty(SETTING_PROXYSETTING, Integer.toString(proxySetting));
            setting.setProperty(SETTING_SOCKSHOST, socksHost);
            setting.setProperty(SETTING_SOCKSPORT, Integer.toString(socksPort));
            setting.setProperty(SETTING_HTTPPROXYHOST, httpProxyHost);
            setting.setProperty(SETTING_HTTPPROXYPORT, Integer.toString(httpProxyPort));
            if (httpProxyUser == null || httpProxyUser.trim().length() == 0) {
                setting.setProperty(SETTING_HTTPPROXYUSER, "");
            } else {
                setting.setProperty(SETTING_HTTPPROXYUSER, httpProxyUser);
            }
            if (httpProxyPwd == null || httpProxyPwd.trim().length() == 0) {
                setting.setProperty(SETTING_HTTPPROXYPWD, "");
            } else {
                setting.setProperty(SETTING_HTTPPROXYPWD, httpProxyPwd);
            }
            bl = Persistence.setValue(SETTINGNAME, setting);
        }
        if (bl) {
            System.out.println("Success save Connection Setting");
            return;
        }
        System.out.println("Fail save Connection Setting");
    }

    public static void setDefaultProxy() {
        proxySetting = 0;
        ConnectionSetting.saveSetting();
    }

    public static void setForceNoProxy() {
        proxySetting = 1;
        ConnectionSetting.saveSetting();
    }

    public static void setSocksProxy(String string, int n2) {
        proxySetting = 2;
        socksHost = string;
        socksPort = n2;
        ConnectionSetting.saveSetting();
    }

    public static void setHttpProxy(String string, int n2) {
        ConnectionSetting.setHttpProxy(string, n2, null, null);
    }

    public static void setHttpProxy(String string, int n2, String string2, String string3) {
        proxySetting = 3;
        httpProxyHost = string;
        httpProxyPort = n2;
        httpProxyUser = string2;
        httpProxyPwd = string3;
        ConnectionSetting.saveSetting();
    }

    public static int getProxySetting() {
        return proxySetting;
    }

    public static String getSocksHost() {
        return socksHost;
    }

    public static int getSocksPort() {
        return socksPort;
    }

    public static String getHttpProxyHost() {
        return httpProxyHost;
    }

    public static int getHttpProxyPort() {
        return httpProxyPort;
    }

    public static String getHttpProxyUser() {
        return httpProxyUser;
    }

    public static String getHttpProxyPwd() {
        return httpProxyPwd;
    }

    static {
        ConnectionSetting.loadSetting();
    }
}

