/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.multiWindows.control;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.RootPaneContainer;
import leaseLineQuote.multiWindows.control.FontResizeAble;

public class FontResizer {
    private double minRowHeight = 16.0;
    private int minFontSize = 10;
    private int maxRow = 10;
    private int gap = 6;
    private boolean isScaleGap = true;
    private int lastCalAreaHeight = 10;
    private FontResizeAble fontResizeAble;

    public FontResizer(int n2, int n3) {
        this(n2, n3, true);
    }

    public FontResizer(FontResizeAble fontResizeAble, int n2, int n3) {
        this(fontResizeAble, n2, n3, true);
    }

    public FontResizer(int n2, int n3, boolean bl) {
        this(null, n2, n3, bl);
    }

    public FontResizer(FontResizeAble object, int n2, int n3, boolean bl) {
        this.setMinFontSize(n2);
        this.maxRow = n3;
        this.isScaleGap = bl;
        this.fontResizeAble = object;
        if (object != null && (object = object.getResizeEventComponent()) != null) {
            ComponentAdapter componentAdapter = new ComponentAdapter(this){
                private /* synthetic */ FontResizer a;
                {
                    this.a = fontResizer;
                }

                @Override
                public final void componentResized(ComponentEvent componentEvent) {
                    this.a.setLastCalAreaHeight(this.a.fontResizeAble.getResizeAreaHeight());
                    this.a.fontResizeAble.fontResize(this.a.calFontSize());
                }
            };
            if (object instanceof RootPaneContainer) {
                ((RootPaneContainer)object).getContentPane().addComponentListener(componentAdapter);
                return;
            }
            ((Component)object).addComponentListener(componentAdapter);
        }
    }

    public void setLastCalAreaHeight(int n2) {
        this.lastCalAreaHeight = n2;
    }

    public int calFontSize() {
        int n2 = (int)((double)this.lastCalAreaHeight / this.minRowHeight);
        if (n2 <= this.maxRow) {
            return this.minFontSize;
        }
        n2 = this.lastCalAreaHeight / this.maxRow;
        n2 = this.isScaleGap ? (int)this.calRowHeight(n2) : (n2 -= 3);
        int n3 = n2;
        n2 = n3 - n3 % 2;
        if (n2 < this.minFontSize) {
            return this.minFontSize;
        }
        return n2;
    }

    public void setMinFontSize(int n2) {
        this.minFontSize = n2;
        this.minRowHeight = this.calRowHeight(n2);
    }

    public void setMaxRow(int n2) {
        this.maxRow = n2;
    }

    private double calRowHeight(int n2) {
        double d2 = (double)n2 - (((double)n2 - 10.0) / 10.0 + 1.0) * (double)this.gap;
        return d2;
    }
}

