/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.multiWindows.control;

import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JPanel;
import leaseLineQuote.multiWindows.MultiWindowsControl;

public class FontControl {
    private static final String DEF_CHI = "\u7d30\u660e\u9ad4";
    private static final String DEF_ENG = "Arial";
    private static String chineseFont = "\u7d30\u660e\u9ad4";
    private static String englishFont = "Arial";
    private static final Map<String, Font> fontCache = new WeakHashMap<String, Font>();

    private FontControl() {
    }

    public static void setChineseFont(String string) {
        System.out.println("!!! chineseFont : " + string);
        try {
            Font font = new Font(string, 0, 12);
            if (font.canDisplay('\u4e2d')) {
                chineseFont = string;
                fontCache.clear();
                MultiWindowsControl.getInstance().refreshFont();
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static final Font getFontBold(int n2, int n3) {
        return FontControl.getFont(n2, FontStyle.BOLD, n3);
    }

    public static final Font getFont(int n2, int n3) {
        return FontControl.getFont(n2, FontStyle.PLAIN, n3);
    }

    public static final Font getFont(int n2, FontStyle fontStyle, int n3) {
        return FontControl.getFont(FontControl.getFontName(n2), fontStyle, n3);
    }

    public static final Font getFont(String string, FontStyle fontStyle, int n2) {
        String string2 = string + " - " + fontStyle.style + " - " + n2;
        Font font = fontCache.get(string2);
        if (font == null) {
            font = new Font(string, fontStyle.style, n2);
            fontCache.put(string2, font);
        }
        return font;
    }

    public static final Font getFont(String string, int n2) {
        return FontControl.getFont(string, FontStyle.PLAIN, n2);
    }

    public static final String getFontName(int n2) {
        switch (n2) {
            case 0: {
                return chineseFont;
            }
        }
        return englishFont;
    }

    public static void setFontInPanel(JPanel componentArray, Font font) {
        for (Component component : componentArray.getComponents()) {
            if (component instanceof JPanel) {
                FontControl.setFontInPanel((JPanel)component, font);
                continue;
            }
            component.setFont(font);
        }
    }

    static {
        Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (int i2 = 0; i2 < fontArray.length; ++i2) {
            if (fontArray[i2].getName().equals("FZShuSong-Z01")) {
                chineseFont = "FZShuSong-Z01";
            }
            if (!fontArray[i2].getName().equals("Dialog")) continue;
            englishFont = "Dialog";
        }
    }

    public static enum FontStyle {
        PLAIN(0),
        BOLD(1),
        ITALIC(2),
        BOLD_ITALIC(3);

        public final int style;

        private FontStyle(int n3) {
            this.style = n3;
        }
    }
}

