/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.multiWindows.control;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;
import leaseLineQuote.multiWindows.MultiWindowsControl;

public class DragControl
implements MouseListener,
MouseMotionListener {
    private final Component componentA;
    private Point lastMousePoint = new Point();
    private Point lastWinPoint = new Point();
    private int count = 0;
    private boolean isDraging = false;

    public DragControl(Component component) {
        this.componentA = component;
    }

    public void putListener(Component component) {
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        ++this.count;
    }

    public int getListenerCount() {
        return this.count;
    }

    private boolean isFrozeWin() {
        try {
            return MultiWindowsControl.getInstance().isFrozenWin() && !this.componentA.getClass().getName().equals("leaseLineQuote.multiWindows.CandleIFrame");
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        try {
            if (!this.isFrozeWin() && mouseEvent.getButton() == 1) {
                this.isDraging = true;
                this.lastMousePoint = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(this.lastMousePoint, mouseEvent.getComponent());
                this.lastWinPoint = this.componentA.getLocation();
                ((Component)mouseEvent.getSource()).setCursor(Cursor.getPredefinedCursor(13));
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!MultiWindowsControl.getInstance().isFrozenWin() && this.isDraging) {
            this.isDraging = false;
            ((Component)mouseEvent.getSource()).setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.isFrozeWin() && this.isDraging) {
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
            int n2 = this.lastWinPoint.x + (point.x - this.lastMousePoint.x);
            int n3 = this.lastWinPoint.y + (point.y - this.lastMousePoint.y);
            n2 = Math.max(n2, 0);
            n3 = Math.max(n3, 0);
            this.componentA.setLocation(n2, n3);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

