/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.multiWindows;

import hk.com.realink.quot.ams.DynamiRoot;
import hk.com.realink.quot.ams.StaticRoot;
import hk.com.realink.quot.mdf.XfEqt;
import hk.com.realink.quot.mdf.XfWnt;
import hk.com.realink.quot.mdf.XsWnt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import leaseLineQuote.StyledFont;
import leaseLineQuote.StyledFrame;
import leaseLineQuote.b.a;
import leaseLineQuote.b.b;
import leaseLineQuote.f;
import leaseLineQuote.multiWindows.GUI.FlashControl.FlashController;
import leaseLineQuote.multiWindows.GUI.FlashControl.UpDownBackgroundFlashHandler1;
import leaseLineQuote.multiWindows.GUI.FontSizePanel;
import leaseLineQuote.multiWindows.ImageLoader;
import leaseLineQuote.multiWindows.util.IntegerConverter;
import leaseLineQuote.multiWindows.util.StockUtil;
import leaseLineQuote.tradeonly.h;

public class SctyMainFrame
extends StyledFrame
implements Runnable {
    private final NumberFormat nf = NumberFormat.getNumberInstance();
    private static final int MODE_EQTY = 0;
    private static final int MODE_WRNT = 1;
    private static final int MODE_ELI = 2;
    private static final int MODE_TRST = 3;
    private static final int MODE_BWRT = 4;
    private Color upColor = f.aB;
    private Color balColor = f.aA;
    private Color downColor = f.aC;
    private int lastSctyCode = 0;
    private DynamiRoot inputDynamicRoot = new DynamiRoot();
    private float nominal = 0.0f;
    private float nominalChange = 0.0f;
    private float nominalChangeInPerc = 0.0f;
    private float high = 0.0f;
    private float low = 0.0f;
    private long volume = 0L;
    private long turnover = 0L;
    private String updateTime = "--";
    private StaticRoot inputStaticRoot = new StaticRoot();
    private String chineseName = "";
    private String engName = "";
    private float prevClose = 0.0f;
    private int lot = 0;
    private float callPrice = 0.0f;
    private String marketCode = "";
    private boolean isSuspend = false;
    private boolean isSctyChanged = true;
    private Color nominalChangeColor = this.balColor;
    private Color hiChangeColor = this.balColor;
    private Color loChangeColor = this.balColor;
    private int displayType = 0;
    private int lang_flag = 0;
    private ImageIcon refreshIcon = null;
    private ImageIcon refreshOnIcon = null;
    private FontSizePanel fontSizePanel = null;
    private JLabel CallPriceInfo;
    private JLabel CallPriceText;
    private JLabel ChangeInPercInfo;
    private JLabel ChangeInPercText;
    private JLabel ChangeInfo;
    private JPanel ChangePanel;
    private JLabel ChangeText;
    private JLabel CurrentInfo;
    private JPanel CurrentPanel;
    private JLabel CurrentText;
    private JLabel Day52RangeInfo;
    private JLabel Day52RangeText;
    private JLabel DayRangeInfo;
    private JLabel DayRangeText;
    private JLabel EPSInfo;
    private JLabel EPSText;
    private JLabel ExpiryInfo;
    private JLabel ExpiryText;
    private JLabel LogInfo;
    private JLabel LogText;
    private JPanel MainPanel;
    private JLabel MktValueInfo;
    private JLabel MktValueText;
    private JLabel PEInfo;
    private JLabel PEText;
    private JLabel ParentPriceInfo;
    private JLabel ParentPriceText;
    private JLabel RefreshButton;
    private JLabel SctyCodeInfo;
    private JPanel SctyKeyPanel;
    private JLabel SctyNameInfo;
    private JPanel SpacePanel;
    private JLabel SuspendInfo;
    private JLabel TurnInfo;
    private JLabel TurnText;
    private JPanel UpdatePanel;
    private JLabel UpdateTimeInfo;
    private JLabel VolInfo;
    private JLabel VolText;
    private JLabel YieldInfo;
    private JLabel YieldText;
    private JPanel topPanel;

    public SctyMainFrame() {
        this.initComponents();
        this.setResizable(true);
        try {
            this.refreshIcon = this.createImageIcon("/icons/re.gif", 0.7f, 0.7f);
            this.refreshOnIcon = this.createImageIcon("/icons/re_on.gif", 0.7f, 0.7f);
            this.RefreshButton.setIcon(this.refreshIcon);
            this.SuspendInfo.setIcon(this.createImageIcon("/icons/suspend.gif", 0.8f, 0.8f));
            this.fontSizePanel = new FontSizePanel();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private ImageIcon createImageIcon(String object, float f2, float f3) {
        try {
            object = ImageLoader.loadImage((String)object);
            if (((ImageIcon)object).getImageLoadStatus() == 8) {
                object = this.createBufferedImage((ImageIcon)object, f2, f3);
                return new ImageIcon((Image)object);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private BufferedImage createBufferedImage(ImageIcon object, float f2, float f3) {
        BufferedImage bufferedImage = new BufferedImage(((ImageIcon)object).getIconWidth(), ((ImageIcon)object).getIconHeight(), 2);
        bufferedImage.getGraphics().drawImage(((ImageIcon)object).getImage(), 0, 0, ((ImageIcon)object).getIconWidth(), ((ImageIcon)object).getIconHeight(), null);
        object = new AffineTransform();
        ((AffineTransform)object).scale(f2, f3);
        object = new AffineTransformOp((AffineTransform)object, 2);
        bufferedImage = ((AffineTransformOp)object).filter(bufferedImage, null);
        return bufferedImage;
    }

    public JPanel getPanel() {
        this.MainPanel.setName("SctyMainFrame.MainPanel");
        return this.MainPanel;
    }

    public void updateStatic(StaticRoot staticRoot) {
        new Throwable().printStackTrace();
        Object object = this.getClass().getName() + ".updateStatic";
        object = h.a();
        this.inputStaticRoot = staticRoot;
        this.refreshStaticData();
    }

    protected void refreshStaticData() {
        this.displayType = SctyMainFrame.checkDisplayType(this.inputStaticRoot);
        this.chineseName = this.inputStaticRoot.xsGeneral.chineseCharCodeBig5.trim();
        this.chineseName = this.chineseName.replaceAll("\u3000", "");
        this.engName = this.inputStaticRoot.xsGeneral.sctyShortName;
        this.prevClose = this.inputStaticRoot.xm.prevClosingPrice;
        this.lot = this.inputStaticRoot.xsGeneral.lotSize;
        this.isSuspend = this.inputStaticRoot.xsGeneral.suspensionFlag == 'y' || this.inputStaticRoot.xsGeneral.suspensionFlag == 'Y';
        try {
            if (this.inputStaticRoot.xm.freeTexts != null && this.inputStaticRoot.xm.freeTexts.length > 0 && this.inputStaticRoot.xm.freeTexts[0].startsWith("CP=")) {
                String string = this.inputStaticRoot.xm.freeTexts[0].substring(3).trim();
                if (string.endsWith("*")) {
                    string = string.substring(0, string.length() - 1);
                }
                this.callPrice = new Float(string).floatValue();
            } else {
                this.callPrice = 0.0f;
            }
        }
        catch (Exception exception) {
            this.callPrice = 0.0f;
        }
        if (this.inputStaticRoot.xm.sctyCode != this.lastSctyCode) {
            this.setFlashable(false);
            this.isSctyChanged = true;
            this.lastSctyCode = this.inputStaticRoot.xm.sctyCode;
            this.inputDynamicRoot = new DynamiRoot();
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateSuspendField();
            return;
        }
        SwingUtilities.invokeLater(new Runnable(this){
            private /* synthetic */ SctyMainFrame a;
            {
                this.a = sctyMainFrame;
            }

            @Override
            public final void run() {
                this.a.updateSuspendField();
            }
        });
    }

    private void updateSuspendField() {
        this.SuspendInfo.setVisible(this.isSuspend);
    }

    private void setFlashable(boolean bl) {
        FlashController.setFlashable(this.CurrentInfo, bl);
    }

    public void updateDynamic(DynamiRoot dynamiRoot) {
        Object object = this.getClass().getName() + ".updateDynamic";
        object = h.a();
        this.inputDynamicRoot = dynamiRoot;
        this.refreshDynamicData();
        this.updateText();
    }

    protected void refreshDynamicData() {
        float f2 = this.nominal;
        this.nominal = (float)this.inputDynamicRoot.xn.nominalPrice_d3 / 1000.0f;
        this.high = this.inputDynamicRoot.xt.highestTradePrice;
        this.low = this.inputDynamicRoot.xt.lowestTradePrice;
        this.volume = this.inputDynamicRoot.xt.sharesTraded;
        this.turnover = this.inputDynamicRoot.xt.turnover;
        if (f2 > this.nominal) {
            FlashController.setFlashComponentStatus(this.CurrentInfo, UpDownBackgroundFlashHandler1.STATUS_DOWN);
        } else {
            FlashController.setFlashComponentStatus(this.CurrentInfo, UpDownBackgroundFlashHandler1.STATUS_UP);
        }
        this.nominalChangeColor = this.nominal > this.prevClose ? this.upColor : (this.nominal < this.prevClose ? this.downColor : this.balColor);
        this.hiChangeColor = this.high > 0.0f && this.high > this.inputStaticRoot.dbInfo.weeksHigh52 ? this.upColor : this.balColor;
        this.loChangeColor = this.low > 0.0f && this.low < this.inputStaticRoot.dbInfo.weeksLow52 ? this.downColor : this.balColor;
        this.nominalChange = StockUtil.calDollarChange(this.nominal, this.prevClose);
        this.nominalChangeInPerc = StockUtil.calPercentChange(this.nominal, this.prevClose);
        this.updateTime = a.d(this.inputDynamicRoot.timeHHMMSS24);
        this.updateGUI();
    }

    public void updateGUI() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
            return;
        }
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void run() {
        try {
            this.GUI_Update_BaseInfo();
            switch (this.displayType) {
                case 0: {
                    this.GUI_Update_EQTYInfo();
                    break;
                }
                case 1: {
                    this.GUI_Update_WRNTInfo();
                    break;
                }
                case 2: {
                    assert (false) : "Not Implements ELI";
                    break;
                }
                case 3: {
                    this.GUI_Update_TRSRInfo();
                    break;
                }
                case 4: {
                    assert (false) : "Not Implements MODE_BWRT";
                    break;
                }
                default: {
                    assert (false) : "Unknown Display Type";
                    this.GUI_Update_DefInfo();
                    break;
                }
            }
        }
        catch (Exception exception) {}
        if (this.isSctyChanged) {
            this.setFlashable(true);
            this.isSctyChanged = false;
        }
        this.MainPanel.repaint();
    }

    private void GUI_Update_BaseInfo() {
        this.SctyCodeInfo.setText(IntegerConverter.toString(this.lastSctyCode));
        this.CurrentInfo.setText("0.0");
        this.ChangeInfo.setText("0.0");
        this.ChangeInPercInfo.setText("0.0");
        if (this.lang_flag == 0) {
            this.SctyNameInfo.setText(this.chineseName);
            this.TurnInfo.setText(b.a(this.turnover));
            this.VolInfo.setText(b.a(this.volume));
        } else {
            this.SctyNameInfo.setText(this.engName);
            this.TurnInfo.setText(b.b(this.turnover));
            this.VolInfo.setText(b.b(this.volume));
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            this.DayRangeInfo.setText(stringBuilder.append(b.e(this.low)).append(" - ").append(b.e(this.high)).toString());
        }
        catch (Exception exception) {
            this.DayRangeInfo.setText("-");
        }
        stringBuilder.setLength(0);
        try {
            this.Day52RangeInfo.setText(stringBuilder.append(b.e(this.inputStaticRoot.dbInfo.weeksLow52)).append(" - ").append(b.e(this.inputStaticRoot.dbInfo.weeksHigh52)).toString());
        }
        catch (Exception exception) {
            this.Day52RangeInfo.setText("-");
        }
        this.UpdateTimeInfo.setText(this.updateTime);
    }

    private void GUI_Update_EQTYInfo() {
        Object object = this.getClass().getName() + ".GUI_Update_EQTYInfo";
        object = h.a();
        this.LogInfo.setText(IntegerConverter.toString(this.lot));
        float f2 = this.nominal * (float)this.inputStaticRoot.dbInfo.issuedShare;
        switch (this.lang_flag) {
            case 0: {
                this.MktValueInfo.setText(b.a(f2));
                break;
            }
            default: {
                this.MktValueInfo.setText(b.b(f2));
            }
        }
        f2 = this.inputStaticRoot.dbInfo.prevDiv;
        String string = f2 == 0.0f | this.nominal == 0.0f ? "-" : b.a(f2 / this.nominal * 100.0f, 1) + "%";
        String string2 = "-";
        String string3 = "-";
        try {
            XfEqt xfEqt = (XfEqt)this.inputDynamicRoot.xfGeneral;
            string2 = "" + xfEqt.peRatio;
            string3 = xfEqt.peRatio == 0.0f ? "N/A" : "" + this.nominal / xfEqt.peRatio;
        }
        catch (ClassCastException classCastException) {
        }
        catch (NullPointerException nullPointerException) {}
        this.PEInfo.setText(a.b(string2));
        this.EPSInfo.setText(a.b(string3));
        this.YieldInfo.setText(string);
        this.CallPriceInfo.setText("");
        this.ParentPriceInfo.setText("");
        this.ExpiryInfo.setText("");
    }

    private void GUI_Update_WRNTInfo() {
        Object object = this.getClass().getName() + ".GUI_Update_WRNTInfo";
        object = h.a();
        this.PEInfo.setText(IntegerConverter.toString(this.lot));
        try {
            object = (XsWnt)this.inputStaticRoot.xsGeneral;
            this.LogInfo.setText(StockUtil.mapCallPut(((XsWnt)object).callPutFlag));
        }
        catch (ClassCastException classCastException) {
        }
        catch (NullPointerException nullPointerException) {}
        try {
            object = (XfWnt)this.inputDynamicRoot.xfGeneral;
            this.ParentPriceInfo.setText(b.e(((XfWnt)object).parentSctyPrice));
            if (!this.inputStaticRoot.dbInfo.stockType.equals("SPW")) {
                this.MktValueInfo.setText(b.e(((XfWnt)object).warrantPremium * 100.0f) + "%");
                this.EPSInfo.setText(b.e(((XfWnt)object).gearingRatio));
            } else {
                this.MktValueInfo.setText("-");
                this.EPSInfo.setText("-");
            }
        }
        catch (ClassCastException classCastException) {
        }
        catch (NullPointerException nullPointerException) {}
        this.YieldInfo.setText(b.e(this.inputStaticRoot.dbInfo.strikePrice));
        this.CallPriceInfo.setText(this.callPrice == 0.0f ? "N/A" : b.e(this.callPrice));
        this.ExpiryInfo.setText(this.inputStaticRoot.dbInfo.expiryDate);
    }

    private void GUI_Update_TRSRInfo() {
        Object object = this.getClass().getName() + ".GUI_Update_TRSRInfo";
        object = h.a();
        this.PEInfo.setText("N/A");
        this.LogInfo.setText(IntegerConverter.toString(this.lot));
        float f2 = this.nominal * (float)this.inputStaticRoot.dbInfo.issuedShare;
        switch (this.lang_flag) {
            case 0: {
                this.MktValueInfo.setText(b.a(f2));
                break;
            }
            default: {
                this.MktValueInfo.setText(b.b(f2));
            }
        }
        this.EPSInfo.setText("N/A");
        this.YieldInfo.setText("N/A");
        this.CallPriceInfo.setText("");
        this.ParentPriceInfo.setText("");
        this.ExpiryInfo.setText("");
    }

    private void GUI_Update_DefInfo() {
        Object object = this.getClass().getName() + ".GUI_Update_DefInfo";
        object = h.a();
        this.PEInfo.setText("");
        this.LogInfo.setText("");
        this.MktValueInfo.setText("");
        this.EPSInfo.setText("");
        this.YieldInfo.setText("");
        this.CallPriceInfo.setText("");
        this.ParentPriceInfo.setText("");
        this.ExpiryInfo.setText("");
    }

    private static final int checkDisplayType(StaticRoot object) {
        String string = ((StaticRoot)object).xsGeneral.instrumentType;
        if ("EQTY".equals(string)) {
            return 0;
        }
        if ("WRNT".equals(string)) {
            object = ((StaticRoot)object).dbInfo.stockType;
            if (((String)object).equals("EL1") || ((String)object).equals("EL2") || ((String)object).equals("EL3")) {
                return 2;
            }
            return 1;
        }
        if ("BWRT".equals(string)) {
            return 4;
        }
        if ("TRST".equals(string)) {
            return 3;
        }
        if ("BOND".equals(string)) {
            return 3;
        }
        return 0;
    }

    public void updateText() {
        if (this.lang_flag == 0) {
            switch (this.displayType) {
                case 0: 
                case 3: {
                    this.PEText.setText("\u5e02\u76c8\u7387(\u500d)");
                    this.LogText.setText("\u6bcf\u624b\u80a1\u6578");
                    this.MktValueText.setText("\u5e02\u503c");
                    this.EPSText.setText("\u6bcf\u80a1\u76c8\u5229");
                    this.YieldText.setText("\u6536\u76ca\u7387");
                    this.CallPriceText.setText("");
                    this.ParentPriceText.setText("");
                    this.ExpiryText.setText("");
                    return;
                }
                case 1: {
                    this.PEText.setText("\u6bcf\u624b\u80a1\u6578");
                    this.LogText.setText("\u985e\u5225");
                    this.MktValueText.setText("\u6ea2\u50f9");
                    this.EPSText.setText("\u69d3\u687f\u6bd4\u7387");
                    this.YieldText.setText("\u884c\u4f7f\u50f9");
                    this.CallPriceText.setText("\u6536\u56de\u50f9");
                    this.ParentPriceText.setText("\u6b63\u80a1\u50f9\u4f4d");
                    this.ExpiryText.setText("\u5230\u671f\u65e5");
                    return;
                }
                case 2: {
                    return;
                }
                case 4: {
                    return;
                }
            }
            return;
        }
        switch (this.displayType) {
            case 0: 
            case 3: {
                this.PEText.setText("P/E Ratio");
                this.LogText.setText("Lot Size");
                this.MktValueText.setText("Market Cap");
                this.EPSText.setText("EPS");
                this.YieldText.setText("Yield");
                this.CallPriceText.setText("");
                this.ParentPriceText.setText("");
                this.ExpiryText.setText("");
                return;
            }
            case 1: {
                this.PEText.setText("Lot Size");
                this.LogText.setText("Type");
                this.MktValueText.setText("Premium");
                this.EPSText.setText("Gearing");
                this.YieldText.setText("Strike");
                this.CallPriceText.setText("Call Price");
                this.ParentPriceText.setText("Spot Price");
                this.ExpiryText.setText("Expiry Date");
            }
        }
    }

    public void setChinese() {
        this.lang_flag = 0;
        SctyMainFrame sctyMainFrame = this;
        sctyMainFrame.updateStatic(sctyMainFrame.inputStaticRoot);
        SctyMainFrame sctyMainFrame2 = this;
        sctyMainFrame2.updateDynamic(sctyMainFrame2.inputDynamicRoot);
        this.SctyNameInfo.setFont(StyledFont.BIG_BOLD_CHINESE);
        this.SctyCodeInfo.setFont(StyledFont.BIG_BOLD_CHINESE);
        this.CurrentText.setFont(StyledFont.PLAIN_CHINESE);
        this.CurrentText.setText("\u73fe\u50f9");
        this.CurrentInfo.setFont(StyledFont.BIG_BOLD_CHINESE);
        this.ChangeText.setFont(StyledFont.PLAIN_CHINESE);
        this.ChangeText.setText("\u5347\u8dcc");
        this.ChangeInfo.setFont(StyledFont.BOLD_PLAINFONT);
        this.ChangeInPercText.setFont(StyledFont.PLAIN_CHINESE);
        this.ChangeInPercText.setText("\u5347\u8dcc(%)");
        this.ChangeInPercInfo.setFont(StyledFont.BOLD_PLAINFONT);
        this.VolText.setFont(StyledFont.PLAIN_CHINESE);
        this.VolText.setText("\u6210\u4ea4\u91cf");
        this.VolInfo.setFont(StyledFont.BOLD_CHINESE);
        this.TurnText.setFont(StyledFont.PLAIN_CHINESE);
        this.TurnText.setText("\u6210\u4ea4\u91d1\u984d ");
        this.TurnInfo.setFont(StyledFont.BOLD_CHINESE);
        this.DayRangeText.setFont(StyledFont.PLAIN_CHINESE);
        this.DayRangeText.setText("\u4eca\u65e5\u6ce2\u5e45");
        this.Day52RangeText.setFont(StyledFont.PLAIN_CHINESE);
        this.Day52RangeText.setText("52\u9031\u6ce2\u5e45");
        this.PEText.setFont(StyledFont.PLAIN_CHINESE);
        this.LogText.setFont(StyledFont.PLAIN_CHINESE);
        this.MktValueText.setFont(StyledFont.PLAIN_CHINESE);
        this.MktValueInfo.setFont(StyledFont.BOLD_CHINESE);
        this.EPSText.setFont(StyledFont.PLAIN_CHINESE);
        this.YieldText.setFont(StyledFont.PLAIN_CHINESE);
        this.CallPriceText.setFont(StyledFont.PLAIN_CHINESE);
        this.ParentPriceText.setFont(StyledFont.PLAIN_CHINESE);
        this.ExpiryText.setFont(StyledFont.PLAIN_CHINESE);
    }

    public void setEnglish() {
        this.lang_flag = 1;
        SctyMainFrame sctyMainFrame = this;
        sctyMainFrame.updateStatic(sctyMainFrame.inputStaticRoot);
        SctyMainFrame sctyMainFrame2 = this;
        sctyMainFrame2.updateDynamic(sctyMainFrame2.inputDynamicRoot);
        this.SctyNameInfo.setFont(StyledFont.BIG_BOLD_PLAINFONT);
        this.SctyCodeInfo.setFont(StyledFont.BIG_BOLD_PLAINFONT);
        this.CurrentText.setFont(StyledFont.PLAINFONT);
        this.CurrentText.setText("Last");
        this.CurrentInfo.setFont(StyledFont.BIG_BOLD_PLAINFONT);
        this.ChangeText.setFont(StyledFont.PLAINFONT);
        this.ChangeText.setText("Chg");
        this.ChangeInfo.setFont(StyledFont.BOLD_PLAINFONT);
        this.ChangeInPercText.setFont(StyledFont.PLAINFONT);
        this.ChangeInPercText.setText("Chg(%)");
        this.ChangeInPercInfo.setFont(StyledFont.BOLD_PLAINFONT);
        this.VolText.setFont(StyledFont.PLAINFONT);
        this.VolText.setText("Volume");
        this.VolInfo.setFont(StyledFont.BOLD_PLAINFONT);
        this.TurnText.setFont(StyledFont.PLAINFONT);
        this.TurnText.setText("Turnover");
        this.TurnInfo.setFont(StyledFont.BOLD_PLAINFONT);
        this.DayRangeText.setFont(StyledFont.PLAINFONT);
        this.DayRangeText.setText("Today's Range");
        this.Day52RangeText.setFont(StyledFont.PLAINFONT);
        this.Day52RangeText.setText("52 Week Range");
        this.PEText.setFont(StyledFont.PLAINFONT);
        this.LogText.setFont(StyledFont.PLAINFONT);
        this.MktValueText.setFont(StyledFont.PLAINFONT);
        this.MktValueInfo.setFont(StyledFont.BOLD_PLAINFONT);
        this.EPSText.setFont(StyledFont.PLAINFONT);
        this.YieldText.setFont(StyledFont.PLAINFONT);
        this.CallPriceText.setFont(StyledFont.PLAINFONT);
        this.ParentPriceText.setFont(StyledFont.PLAINFONT);
        this.ExpiryText.setFont(StyledFont.PLAINFONT);
    }

    private void initComponents() {
        this.MainPanel = new JPanel();
        this.topPanel = new JPanel();
        this.SctyKeyPanel = new JPanel();
        this.SctyNameInfo = new JLabel();
        this.SctyCodeInfo = new JLabel();
        this.SuspendInfo = new JLabel();
        this.CurrentPanel = new JPanel();
        this.CurrentText = new JLabel();
        this.CurrentInfo = new JLabel();
        this.ChangePanel = new JPanel();
        this.ChangeText = new JLabel();
        this.ChangeInfo = new JLabel();
        this.ChangeInPercText = new JLabel();
        this.ChangeInPercInfo = new JLabel();
        this.VolText = new JLabel();
        this.VolInfo = new JLabel();
        this.MktValueText = new JLabel();
        this.MktValueInfo = new JLabel();
        this.TurnText = new JLabel();
        this.TurnInfo = new JLabel();
        this.EPSText = new JLabel();
        this.EPSInfo = new JLabel();
        this.PEText = new JLabel();
        this.PEInfo = new JLabel();
        this.YieldText = new JLabel();
        this.YieldInfo = new JLabel();
        this.LogInfo = new JLabel();
        this.CallPriceText = new JLabel();
        this.DayRangeText = new JLabel();
        this.DayRangeInfo = new JLabel();
        this.Day52RangeText = new JLabel();
        this.Day52RangeInfo = new JLabel();
        this.LogText = new JLabel();
        this.CallPriceInfo = new JLabel();
        this.ParentPriceText = new JLabel();
        this.ParentPriceInfo = new JLabel();
        this.ExpiryText = new JLabel();
        this.ExpiryInfo = new JLabel();
        this.UpdatePanel = new JPanel();
        this.RefreshButton = new JLabel();
        this.SpacePanel = new JPanel();
        this.UpdateTimeInfo = new JLabel();
        this.setDefaultCloseOperation(2);
        this.addComponentListener(new ComponentAdapter(this){
            private /* synthetic */ SctyMainFrame a;
            {
                this.a = sctyMainFrame;
            }

            @Override
            public final void componentResized(ComponentEvent componentEvent) {
                this.a.formComponentResized(componentEvent);
            }
        });
        this.MainPanel.setMaximumSize(new Dimension(0, 15));
        this.MainPanel.setMinimumSize(new Dimension(0, 15));
        this.MainPanel.setPreferredSize(new Dimension(0, 15));
        this.MainPanel.setLayout(new GridBagLayout());
        this.topPanel.setLayout(new GridBagLayout());
        this.SctyKeyPanel.setBackground(new Color(129, 98, 184));
        this.SctyKeyPanel.setLayout(new GridBagLayout());
        this.SctyNameInfo.setText("\u532f\u8c50\u63a7\u80a1");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        this.SctyKeyPanel.add((Component)this.SctyNameInfo, gridBagConstraints);
        this.SctyCodeInfo.setBackground(new Color(255, 255, 204));
        this.SctyCodeInfo.setHorizontalAlignment(4);
        this.SctyCodeInfo.setText("00005.HK");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.SctyKeyPanel.add((Component)this.SctyCodeInfo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.SctyKeyPanel.add((Component)this.SuspendInfo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 1);
        this.topPanel.add((Component)this.SctyKeyPanel, gridBagConstraints);
        this.CurrentPanel.setBackground(new Color(204, 153, 255));
        this.CurrentPanel.setLayout(new GridBagLayout());
        this.CurrentText.setText("\u73fe\u50f9");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        this.CurrentPanel.add((Component)this.CurrentText, gridBagConstraints);
        this.CurrentInfo.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 1, 12));
        this.CurrentInfo.setHorizontalAlignment(4);
        this.CurrentInfo.setText("80.800");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        this.CurrentPanel.add((Component)this.CurrentInfo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.topPanel.add((Component)this.CurrentPanel, gridBagConstraints);
        this.ChangePanel.setLayout(new GridBagLayout());
        this.ChangeText.setBackground(new Color(204, 153, 255));
        this.ChangeText.setText(" \u5347\u8dcc ");
        this.ChangeText.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 1, 0);
        this.ChangePanel.add((Component)this.ChangeText, gridBagConstraints);
        this.ChangeInfo.setBackground(new Color(204, 153, 255));
        this.ChangeInfo.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 1, 12));
        this.ChangeInfo.setHorizontalAlignment(4);
        this.ChangeInfo.setText("0.05 ");
        this.ChangeInfo.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 1, 0);
        this.ChangePanel.add((Component)this.ChangeInfo, gridBagConstraints);
        this.ChangeInPercText.setBackground(new Color(204, 153, 255));
        this.ChangeInPercText.setText(" \u5347\u8dcc(%) ");
        this.ChangeInPercText.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.ChangePanel.add((Component)this.ChangeInPercText, gridBagConstraints);
        this.ChangeInPercInfo.setBackground(new Color(204, 153, 255));
        this.ChangeInPercInfo.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 1, 12));
        this.ChangeInPercInfo.setHorizontalAlignment(4);
        this.ChangeInPercInfo.setText("0.062% ");
        this.ChangeInPercInfo.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.ChangePanel.add((Component)this.ChangeInPercInfo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 0);
        this.topPanel.add((Component)this.ChangePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 8.0;
        gridBagConstraints.weighty = 2.0;
        this.MainPanel.add((Component)this.topPanel, gridBagConstraints);
        this.VolText.setBackground(new Color(133, 133, 208));
        this.VolText.setText("\u6210\u4ea4\u91cf");
        this.VolText.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        this.MainPanel.add((Component)this.VolText, gridBagConstraints);
        this.VolInfo.setBackground(new Color(133, 133, 208));
        this.VolInfo.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 1, 12));
        this.VolInfo.setHorizontalAlignment(4);
        this.VolInfo.setText("1.38\u5343\u842c\u80a1 ");
        this.VolInfo.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 1);
        this.MainPanel.add((Component)this.VolInfo, gridBagConstraints);
        this.MktValueText.setBackground(new Color(133, 133, 208));
        this.MktValueText.setText("\u5e02\u503c");
        this.MktValueText.setMaximumSize(new Dimension(0, 15));
        this.MktValueText.setMinimumSize(new Dimension(0, 15));
        this.MktValueText.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 0);
        this.MainPanel.add((Component)this.MktValueText, gridBagConstraints);
        this.MktValueInfo.setBackground(new Color(133, 133, 208));
        this.MktValueInfo.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 1, 12));
        this.MktValueInfo.setHorizontalAlignment(4);
        this.MktValueInfo.setText("14,422.84\u5104 ");
        this.MktValueInfo.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        this.MainPanel.add((Component)this.MktValueInfo, gridBagConstraints);
        this.TurnText.setBackground(new Color(133, 133, 208));
        this.TurnText.setText("\u6210\u4ea4\u91d1\u984d ");
        this.TurnText.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        this.MainPanel.add((Component)this.TurnText, gridBagConstraints);
        this.TurnInfo.setBackground(new Color(133, 133, 208));
        this.TurnInfo.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 1, 12));
        this.TurnInfo.setHorizontalAlignment(4);
        this.TurnInfo.setText("11.20\u5104 ");
        this.TurnInfo.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 1);
        this.MainPanel.add((Component)this.TurnInfo, gridBagConstraints);
        this.EPSText.setBackground(new Color(133, 133, 208));
        this.EPSText.setText("\u6bcf\u80a1\u76c8\u5229");
        this.EPSText.setMaximumSize(new Dimension(0, 15));
        this.EPSText.setMinimumSize(new Dimension(0, 15));
        this.EPSText.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 0);
        this.MainPanel.add((Component)this.EPSText, gridBagConstraints);
        this.EPSInfo.setBackground(new Color(133, 133, 208));
        this.EPSInfo.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 1, 12));
        this.EPSInfo.setHorizontalAlignment(4);
        this.EPSInfo.setText("2.652 ");
        this.EPSInfo.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        this.MainPanel.add((Component)this.EPSInfo, gridBagConstraints);
        this.PEText.setBackground(new Color(133, 133, 208));
        this.PEText.setText("\u5e02\u76c8\u7387(\u500d) ");
        this.PEText.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        this.MainPanel.add((Component)this.PEText, gridBagConstraints);
        this.PEInfo.setBackground(new Color(133, 133, 208));
        this.PEInfo.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 1, 12));
        this.PEInfo.setHorizontalAlignment(4);
        this.PEInfo.setText("30.75 ");
        this.PEInfo.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 1);
        this.MainPanel.add((Component)this.PEInfo, gridBagConstraints);
        this.YieldText.setBackground(new Color(133, 133, 208));
        this.YieldText.setText("\u6536\u76ca\u7387");
        this.YieldText.setMaximumSize(new Dimension(0, 15));
        this.YieldText.setMinimumSize(new Dimension(0, 15));
        this.YieldText.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 0);
        this.MainPanel.add((Component)this.YieldText, gridBagConstraints);
        this.YieldInfo.setBackground(new Color(133, 133, 208));
        this.YieldInfo.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 1, 12));
        this.YieldInfo.setHorizontalAlignment(4);
        this.YieldInfo.setText("3.23% ");
        this.YieldInfo.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        this.MainPanel.add((Component)this.YieldInfo, gridBagConstraints);
        this.LogInfo.setBackground(new Color(133, 133, 208));
        this.LogInfo.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 1, 12));
        this.LogInfo.setHorizontalAlignment(4);
        this.LogInfo.setText("400 ");
        this.LogInfo.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 1);
        this.MainPanel.add((Component)this.LogInfo, gridBagConstraints);
        this.CallPriceText.setBackground(new Color(133, 133, 208));
        this.CallPriceText.setText("\u6536\u56de\u50f9");
        this.CallPriceText.setMaximumSize(new Dimension(0, 15));
        this.CallPriceText.setMinimumSize(new Dimension(0, 15));
        this.CallPriceText.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 0);
        this.MainPanel.add((Component)this.CallPriceText, gridBagConstraints);
        this.DayRangeText.setBackground(new Color(204, 204, 255));
        this.DayRangeText.setText("\u4eca\u65e5\u6ce2\u5e45");
        this.DayRangeText.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 4.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 1);
        this.MainPanel.add((Component)this.DayRangeText, gridBagConstraints);
        this.DayRangeInfo.setBackground(new Color(204, 204, 255));
        this.DayRangeInfo.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 1, 12));
        this.DayRangeInfo.setHorizontalAlignment(4);
        this.DayRangeInfo.setText("80.550 - 81.600 ");
        this.DayRangeInfo.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 4.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 0);
        this.MainPanel.add((Component)this.DayRangeInfo, gridBagConstraints);
        this.Day52RangeText.setBackground(new Color(204, 204, 255));
        this.Day52RangeText.setText("52\u9031\u6ce2\u5e45");
        this.Day52RangeText.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 4.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 1);
        this.MainPanel.add((Component)this.Day52RangeText, gridBagConstraints);
        this.Day52RangeInfo.setBackground(new Color(204, 204, 255));
        this.Day52RangeInfo.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 1, 12));
        this.Day52RangeInfo.setHorizontalAlignment(4);
        this.Day52RangeInfo.setText("68.950 - 92.800 ");
        this.Day52RangeInfo.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 4.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 0);
        this.MainPanel.add((Component)this.Day52RangeInfo, gridBagConstraints);
        this.LogText.setBackground(new Color(133, 133, 208));
        this.LogText.setText("\u6bcf\u624b\u80a1\u6578 ");
        this.LogText.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        this.MainPanel.add((Component)this.LogText, gridBagConstraints);
        this.CallPriceInfo.setBackground(new Color(133, 133, 208));
        this.CallPriceInfo.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 1, 12));
        this.CallPriceInfo.setHorizontalAlignment(4);
        this.CallPriceInfo.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        this.MainPanel.add((Component)this.CallPriceInfo, gridBagConstraints);
        this.ParentPriceText.setBackground(new Color(204, 204, 255));
        this.ParentPriceText.setText("\u6b63\u80a1\u50f9\u4f4d");
        this.ParentPriceText.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        this.MainPanel.add((Component)this.ParentPriceText, gridBagConstraints);
        this.ParentPriceInfo.setBackground(new Color(204, 204, 255));
        this.ParentPriceInfo.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 1, 12));
        this.ParentPriceInfo.setHorizontalAlignment(4);
        this.ParentPriceInfo.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 1);
        this.MainPanel.add((Component)this.ParentPriceInfo, gridBagConstraints);
        this.ExpiryText.setBackground(new Color(204, 204, 255));
        this.ExpiryText.setText("\u5230\u671f\u65e5");
        this.ExpiryText.setMaximumSize(new Dimension(0, 15));
        this.ExpiryText.setMinimumSize(new Dimension(0, 15));
        this.ExpiryText.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 0);
        this.MainPanel.add((Component)this.ExpiryText, gridBagConstraints);
        this.ExpiryInfo.setBackground(new Color(204, 204, 255));
        this.ExpiryInfo.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 1, 12));
        this.ExpiryInfo.setHorizontalAlignment(4);
        this.ExpiryInfo.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        this.MainPanel.add((Component)this.ExpiryInfo, gridBagConstraints);
        this.UpdatePanel.setLayout(new GridLayout(1, 0));
        this.RefreshButton.setBackground(new Color(204, 204, 255));
        this.RefreshButton.setHorizontalAlignment(4);
        this.RefreshButton.setCursor(new Cursor(12));
        this.RefreshButton.addMouseListener(new MouseAdapter(this){
            private /* synthetic */ SctyMainFrame a;
            {
                this.a = sctyMainFrame;
            }

            @Override
            public final void mouseClicked(MouseEvent mouseEvent) {
                this.a.RefreshButtonMouseClicked(mouseEvent);
            }

            @Override
            public final void mouseEntered(MouseEvent mouseEvent) {
                this.a.RefreshButtonMouseEntered(mouseEvent);
            }

            @Override
            public final void mouseExited(MouseEvent mouseEvent) {
                this.a.RefreshButtonMouseExited(mouseEvent);
            }

            @Override
            public final void mousePressed(MouseEvent mouseEvent) {
                this.a.RefreshButtonMousePressed(mouseEvent);
            }
        });
        this.UpdatePanel.add(this.RefreshButton);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 4.0;
        gridBagConstraints.weighty = 1.0;
        this.MainPanel.add((Component)this.UpdatePanel, gridBagConstraints);
        this.SpacePanel.setLayout(new GridLayout(1, 0));
        this.UpdateTimeInfo.setBackground(new Color(204, 204, 255));
        this.UpdateTimeInfo.setHorizontalAlignment(4);
        this.UpdateTimeInfo.setHorizontalTextPosition(2);
        this.UpdateTimeInfo.setMaximumSize(new Dimension(58, 20));
        this.UpdateTimeInfo.setMinimumSize(new Dimension(58, 20));
        this.UpdateTimeInfo.setPreferredSize(new Dimension(58, 20));
        this.SpacePanel.add(this.UpdateTimeInfo);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 4.0;
        gridBagConstraints.weighty = 1.0;
        this.MainPanel.add((Component)this.SpacePanel, gridBagConstraints);
        this.getContentPane().add((Component)this.MainPanel, "Center");
        this.pack();
    }

    private void formComponentResized(ComponentEvent componentEvent) {
        this.MainPanel.revalidate();
    }

    private void RefreshButtonMouseClicked(MouseEvent mouseEvent) {
        h.a().a(true, "" + this.lastSctyCode);
    }

    private void RefreshButtonMouseEntered(MouseEvent mouseEvent) {
        this.RefreshButton.setIcon(this.refreshOnIcon);
    }

    private void RefreshButtonMouseExited(MouseEvent mouseEvent) {
        this.RefreshButton.setIcon(this.refreshIcon);
    }

    private void RefreshButtonMousePressed(MouseEvent mouseEvent) {
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                new SctyMainFrame().setVisible(true);
            }
        });
    }
}

