/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.multiWindows;

import hk.com.realink.quot.ams.StaticRoot;
import hk.com.realink.quot.typeimple.PlotGraph;
import hk.com.realink.quot.typeimple.multiwin.MultiWinSctyRes;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import leaseLineQuote.b.b;
import leaseLineQuote.f;
import leaseLineQuote.f.c;
import leaseLineQuote.f.e;
import leaseLineQuote.multiWindows.GUI.ColorSchemeSupport;
import leaseLineQuote.multiWindows.GUI.NewSty2JInternalFrame;
import leaseLineQuote.multiWindows.GraphCalc;
import leaseLineQuote.multiWindows.control.DragControl;
import leaseLineQuote.multiWindows.control.FontControl;
import leaseLineQuote.multiWindows.messageHandler.MultiWinSctyResReceiver;
import leaseLineQuote.multiWindows.messageHandler.PlotGraphReceiver;
import leaseLineQuote.multiWindows.messageHandler.StaticRootReceiver;

public class NewSty2GraphicPanel
extends NewSty2JInternalFrame
implements c,
ColorSchemeSupport,
MultiWinSctyResReceiver,
PlotGraphReceiver,
StaticRootReceiver {
    private final DragControl dc = new DragControl(this);
    private PlotGraph graphData = null;
    private float preClose = 0.0f;
    private final GraphCalc gc = new GraphCalc();
    private boolean isChanged = true;
    private Font font = FontControl.getFont("Arial", FontControl.FontStyle.PLAIN, 10);
    private FontMetrics fm = this.getFontMetrics(this.font);
    private int fontSize = 10;
    private BufferedImage offscreenImage;
    private BufferedImage onscreenImage;
    private Graphics2D offscreen = null;
    private Graphics2D onscreen = null;
    private ImageIcon icon = null;
    private static final BasicStroke chartStroke = new BasicStroke(1.0f);
    private static final BasicStroke previewCloseStroke = new BasicStroke(1.0f, 0, 0, 15.0f, new float[]{5.0f, 5.0f}, 0.0f);
    private int start1Idx = 15;
    private int start2Idx = 166;
    private int endIdx = 256;
    private String start1TimeString = "10:00";
    private String start2TimeString = "02:30";
    private String endTimeString = "04:00";
    private int mainOffset = 0;
    private static final String leftSample = "999.9";
    private static final String downSample = "99:99 99:99 99:99 ";
    private String lastLeftSample = "999.9";
    private final GeneralPath gp = new GeneralPath();
    private JLabel graphLabel;

    public NewSty2GraphicPanel() {
        this.initComponents();
        this.dc.putListener(this.graphLabel);
        NewSty2GraphicPanel newSty2GraphicPanel = this;
        newSty2GraphicPanel.graphicResize(newSty2GraphicPanel.graphLabel.getWidth(), this.graphLabel.getHeight(), true);
        this.setResizable(true);
        this.setVisible(true);
    }

    @Override
    public void marketTimeUpdate(leaseLineQuote.f.b b2) {
        if (b2 != null) {
            Object object = b2.a();
            e e2 = b2.a((String)object, 0);
            e e3 = b2.a((String)object, 1);
            object = b2.a((String)object, 2);
            if (e2 != e.a && e3 != e.a && object != e.a) {
                this.start1Idx = e2.a();
                this.start2Idx = e3.a();
                this.endIdx = ((e)object).a();
                this.start1TimeString = e2.b();
                this.start2TimeString = e3.b();
                this.endTimeString = ((e)object).b();
                this.mainOffset = b2.b();
                this.reCalc();
                this.isChanged = true;
                this.graphicRepaint();
            }
        }
    }

    private void updateGraph(PlotGraph plotGraph) {
        this.graphData = plotGraph;
        if (!NewSty2GraphicPanel.plotGraphCheck(this.graphData)) {
            this.graphData = null;
        }
        boolean bl = false;
        if (this.graphData != null) {
            String string = b.a(this.graphData.highestValue, 2);
            String string2 = b.a(this.graphData.highestValue, 2);
            if (string.length() > this.lastLeftSample.length()) {
                bl = true;
            } else if (string2.length() > this.lastLeftSample.length()) {
                bl = true;
            }
        }
        this.reCalc();
        this.isChanged = true;
        if (bl) {
            NewSty2GraphicPanel newSty2GraphicPanel = this;
            newSty2GraphicPanel.graphicResize(newSty2GraphicPanel.graphLabel.getWidth(), this.graphLabel.getHeight(), true);
            return;
        }
        this.graphicRepaint();
        this.updateToolTip();
    }

    @Override
    public void updateGraph(PlotGraph plotGraph, float f2) {
        this.preClose = f2;
        this.updateGraph(plotGraph);
    }

    @Override
    public void notExist(String string) {
        this.reset();
    }

    public void reset() {
        this.graphData = null;
        this.preClose = 0.0f;
        this.graphLabel.setToolTipText(null);
        this.isChanged = true;
        this.graphicRepaint();
    }

    @Override
    public void updateStatic(StaticRoot staticRoot) {
        this.preClose = staticRoot.xm.prevClosingPrice;
        this.reCalc();
        this.updateToolTip();
        this.isChanged = true;
        this.graphicRepaint();
    }

    @Override
    public void updateMultiWinSctyRes(MultiWinSctyRes multiWinSctyRes) {
        if (multiWinSctyRes.isDataExist(8192)) {
            this.updateGraph(multiWinSctyRes.getPlotGraph());
        }
    }

    private void updateToolTip() {
        if (this.graphData != null) {
            int n2 = Math.max(this.fontSize / 3 - 3, -2);
            StringBuilder stringBuilder = new StringBuilder(80);
            stringBuilder.append("<html><body bgColor =\"ffffff\"><table><tr><td><font color=\"005000\" size=\"").append(n2).append("\">Today High: </td><td> <font color=\"005000\" size=\"").append(n2).append("\">").append(b.e(this.graphData.highestValue)).append("</td></tr><tr><td><font color=\"990000\" size=\"" + n2 + "\">Today Low:</td><td> <font color=\"990000\" size=\"" + n2 + "\">").append(b.e(this.graphData.lowestValue)).append("</td></tr><tr><td><font color=\"000099\" size=\"" + n2 + "\">Previous Closing:  </td><td><font color=\"000099\" size=\"" + n2 + "\">").append(b.e(this.preClose)).append("</font></table></body></html>");
            this.graphLabel.setToolTipText(stringBuilder.toString());
            return;
        }
        this.graphLabel.setToolTipText(null);
    }

    private void reCalc() {
        if (this.graphData != null) {
            double d2;
            double d3 = 0.0;
            double d4 = 99999.0;
            if (this.graphData != null) {
                d3 = Math.max(this.graphData.highestValue, 0.0);
                if (this.graphData.lowestValue > 0.0) {
                    d4 = Math.min(this.graphData.lowestValue, 99999.0);
                }
            }
            d4 = this.preClose > 0.0f ? Math.min(d4, (double)this.preClose) : d4;
            d3 = Math.max(d3, (double)this.preClose);
            double d5 = 0.05;
            if (d3 > 100.0) {
                d5 = 0.1;
            } else if (d3 < 0.1) {
                d5 = 0.001;
            } else if (d3 < 0.5) {
                d5 = 0.005;
            }
            double d6 = d3 - d4;
            if (d6 == 0.0) {
                d6 = d5;
            }
            double d7 = d3 + d6 * 0.1;
            double d8 = d4 - d6 * 0.1;
            double d9 = d7 = d7 % d5 > 0.0 ? d7 + (d5 - d7 % d5) : d7;
            if (d8 % d5 > 0.0) {
                double d10 = d8;
                d2 = d10 - d10 % d5;
            } else {
                d2 = d8;
            }
            d8 = d2;
            this.gc.setYMax(d7, d3);
            this.gc.setYMin(d8, d4);
            this.gc.setXMin(0.0, this.start1Idx);
            this.gc.setXMax((int)((double)this.endIdx * 1.1), this.endIdx);
            this.gc.recalc();
        }
    }

    private static final boolean plotGraphLowCheck(PlotGraph plotGraph) {
        if (plotGraph.lowestValue <= 0.0) {
            try {
                if (plotGraph.valueList.size() > 0) {
                    Iterator iterator = plotGraph.valueList.iterator();
                    while (iterator.hasNext()) {
                        float f2;
                        float f3 = ((Float)iterator.next()).floatValue();
                        if (!(f2 > 0.0f)) continue;
                        if (plotGraph.lowestValue > 0.0) {
                            plotGraph.lowestValue = Math.min((double)f3, plotGraph.lowestValue);
                            continue;
                        }
                        plotGraph.lowestValue = f3;
                    }
                }
            }
            catch (Exception exception) {}
        }
        return plotGraph.lowestValue > 0.0;
    }

    private static final boolean plotGraphHighCheck(PlotGraph plotGraph) {
        if (plotGraph.highestValue <= 0.0) {
            try {
                Iterator iterator = plotGraph.valueList.iterator();
                while (iterator.hasNext()) {
                    float f2;
                    float f3 = ((Float)iterator.next()).floatValue();
                    if (!(f2 > 0.0f)) continue;
                    plotGraph.highestValue = Math.max((double)f3, plotGraph.highestValue);
                }
            }
            catch (Exception exception) {}
        }
        return plotGraph.highestValue > 0.0;
    }

    private static final boolean plotGraphCheck(PlotGraph plotGraph) {
        return plotGraph != null && NewSty2GraphicPanel.plotGraphLowCheck(plotGraph) && NewSty2GraphicPanel.plotGraphHighCheck(plotGraph);
    }

    /*
     * WARNING - void declaration
     */
    private void graphicResize(double d2, double d3, boolean bl) {
        Font font;
        void var5_5;
        Object object;
        if (d2 == 0.0 || d3 == 0.0) {
            return;
        }
        double d4 = d2 * 0.14;
        double font2 = d3 * 0.14;
        double d5 = d3 * 0.05;
        double d6 = d2 - d4;
        double d7 = d3 - font2 - d5;
        int n2 = 8;
        this.lastLeftSample = leftSample;
        if (this.graphData != null) {
            String d9 = b.a(this.graphData.highestValue, 2);
            object = b.a(this.graphData.highestValue, 2);
            if (d9.length() > this.lastLeftSample.length()) {
                this.lastLeftSample = d9;
            }
            if (((String)object).length() > this.lastLeftSample.length()) {
                this.lastLeftSample = object;
            }
        }
        while (true) {
            FontMetrics fontMetrics;
            font = FontControl.getFont("Arial", FontControl.FontStyle.PLAIN, (int)(var5_5 + true));
            object = this.getFontMetrics(font);
            if (!((double)fontMetrics.stringWidth(this.lastLeftSample) <= d4) || !((double)((FontMetrics)object).stringWidth(downSample) <= d6) || !((double)((FontMetrics)object).getHeight() * 2.5 < d7)) break;
            ++var5_5;
        }
        font = FontControl.getFont("Arial", FontControl.FontStyle.PLAIN, (int)var5_5);
        this.fm = object = this.getFontMetrics(font);
        this.fontSize = var5_5;
        this.font = font;
        d4 = (double)((FontMetrics)object).stringWidth(this.lastLeftSample) * 1.1;
        double d8 = (double)((FontMetrics)object).getHeight() * 1.1;
        d6 = d2 - d4;
        d7 = d3 - d8 - d5;
        this.gc.setChartSize(d6, d7);
        this.gc.setChartOffset(d4, d5);
        this.gc.recalc();
        this.offscreenImage = new BufferedImage((int)d2, (int)d3, 1);
        this.onscreenImage = new BufferedImage((int)d2, (int)d3, 1);
        if (this.offscreen != null) {
            this.offscreen.dispose();
        }
        this.offscreen = this.offscreenImage.createGraphics();
        if (this.onscreen != null) {
            this.onscreen.dispose();
        }
        this.onscreen = this.onscreenImage.createGraphics();
        if (this.icon == null) {
            this.icon = new ImageIcon(this.onscreenImage);
            this.graphLabel.setIcon(this.icon);
        } else {
            this.icon.setImage(this.onscreenImage);
        }
        this.isChanged = true;
        this.updateToolTip();
        this.graphicRepaint();
    }

    @Override
    public void refreshColor() {
        this.isChanged = true;
        this.setBorder(BorderFactory.createLineBorder(f.aD, 1));
        this.graphicRepaint();
    }

    public void graphicRepaint() {
        if (SwingUtilities.isEventDispatchThread()) {
            this._graphicRepaint();
            return;
        }
        SwingUtilities.invokeLater(new Runnable(this){
            private /* synthetic */ NewSty2GraphicPanel a;
            {
                this.a = newSty2GraphicPanel;
            }

            @Override
            public final void run() {
                this.a._graphicRepaint();
            }
        });
    }

    private void _graphicRepaint() {
        if (this.offscreen != null && this.isChanged) {
            NewSty2GraphicPanel newSty2GraphicPanel = this;
            newSty2GraphicPanel.drawBG(newSty2GraphicPanel.offscreen);
            if (this.graphData != null) {
                NewSty2GraphicPanel newSty2GraphicPanel2 = this;
                newSty2GraphicPanel2.drawChart(newSty2GraphicPanel2.offscreen);
            }
            this.onscreen.drawImage((Image)this.offscreenImage, 0, 0, null);
            this.isChanged = false;
            this.graphLabel.repaint();
        }
    }

    private void drawBG(Graphics2D graphics2D) {
        int n2;
        graphics2D.setColor(f.L);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.setColor(f.Q);
        double d2 = this.gc.getStartX();
        double d3 = this.gc.getStartY();
        double d4 = this.gc.getEndX();
        double d5 = this.gc.getEndY();
        graphics2D.drawLine((int)d2, (int)d3, (int)d2, (int)d5);
        graphics2D.drawLine((int)d2, (int)d5, (int)d4, (int)d5);
        graphics2D.setColor(f.P);
        double d6 = (d5 - d3) / 5.0;
        for (n2 = 0; n2 < 5; ++n2) {
            graphics2D.drawLine((int)(d2 + 1.0), (int)(d3 + (double)n2 * d6), (int)d4, (int)(d3 + (double)n2 * d6));
        }
        n2 = (int)this.gc.dataToChartX(this.start1Idx);
        int n3 = (int)(d3 + 1.0);
        int n4 = (int)(d5 - 1.0);
        graphics2D.drawLine(n2, n3, n2, n4);
        n2 = (int)this.gc.dataToChartX(this.start2Idx);
        graphics2D.drawLine(n2, n3, n2, n4);
        n2 = (int)this.gc.dataToChartX(this.endIdx);
        graphics2D.drawLine(n2, n3, n2, n4);
    }

    private void drawChart(Graphics2D graphics2D) {
        double d2 = this.gc.getStartX();
        double d3 = this.gc.getStartY();
        double d4 = this.gc.getEndX();
        double d5 = this.gc.getEndY();
        int n2 = this.fm.getHeight();
        graphics2D.setFont(this.font);
        graphics2D.setColor(f.O);
        double d6 = this.gc.dataToChartX(this.start2Idx);
        int n3 = (int)(d5 + (double)n2);
        graphics2D.drawString(this.start1TimeString, (int)d2, n3);
        graphics2D.drawString(this.start2TimeString, (int)(d6 - (double)this.fm.stringWidth(this.start2TimeString) / 2.0), n3);
        graphics2D.drawString(this.endTimeString, (int)(d4 - (double)this.fm.stringWidth(this.endTimeString)), n3);
        PlotGraph plotGraph = this.graphData;
        if (plotGraph != null) {
            if (plotGraph.lowestValue > 0.0) {
                graphics2D.drawString(b.e(this.gc.getData_y_max()), 0, (int)d3 + n2);
                graphics2D.drawString(b.e(this.gc.getData_y_min()), 0, (int)d5);
            } else {
                graphics2D.drawString(b.e(this.gc.getData_y_max()), 0, (int)d3 + n2);
            }
            if (this.preClose > 0.0f) {
                graphics2D.setColor(f.M);
                graphics2D.setStroke(previewCloseStroke);
                double d7 = this.gc.dataToChartY(this.preClose);
                graphics2D.drawLine((int)(d2 + 1.0), (int)d7, (int)d4, (int)d7);
            }
            graphics2D.setStroke(chartStroke);
            graphics2D.setColor(f.N);
            ArrayList arrayList = plotGraph.valueList;
            int n4 = arrayList.size();
            this.gp.reset();
            try {
                boolean bl = false;
                for (int i2 = 0; i2 < n4; ++i2) {
                    double d8;
                    double d9 = ((Float)arrayList.get(i2)).doubleValue();
                    if (!(d8 > 0.0)) continue;
                    double d10 = this.gc.dataToChartX(i2 + this.mainOffset);
                    double d11 = this.gc.dataToChartY(d9);
                    if (bl) {
                        this.gp.lineTo(d10, d11);
                        continue;
                    }
                    bl = true;
                    this.gp.moveTo(d10, d11);
                }
            }
            catch (Exception exception) {}
            graphics2D.draw(this.gp);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.removeAll();
        this.graphLabel.setIcon(null);
        this.graphLabel = null;
        this.offscreenImage = null;
        this.onscreenImage = null;
        if (this.offscreen != null) {
            try {
                this.offscreen.dispose();
            }
            catch (Exception exception) {}
            this.offscreen = null;
        }
        if (this.onscreen != null) {
            try {
                this.onscreen.dispose();
            }
            catch (Exception exception) {}
            this.onscreen = null;
        }
        this.graphData = null;
        this.font = null;
    }

    private void initComponents() {
        this.graphLabel = new JLabel();
        this.graphLabel.setRequestFocusEnabled(false);
        this.graphLabel.addComponentListener(new ComponentAdapter(this){
            private /* synthetic */ NewSty2GraphicPanel a;
            {
                this.a = newSty2GraphicPanel;
            }

            @Override
            public final void componentResized(ComponentEvent componentEvent) {
                this.a.graphLabelComponentResized(componentEvent);
            }
        });
        this.getContentPane().add((Component)this.graphLabel, "Center");
        this.pack();
    }

    private void graphLabelComponentResized(ComponentEvent componentEvent) {
        NewSty2GraphicPanel newSty2GraphicPanel = this;
        newSty2GraphicPanel.graphicResize(newSty2GraphicPanel.graphLabel.getWidth(), this.graphLabel.getHeight(), true);
    }
}

