/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.multiWindows.GUI;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import leaseLineQuote.multiWindows.GUI.CustomLayoutSettingInterface;
import leaseLineQuote.multiWindows.GUI.MiniVersionSupport;
import leaseLineQuote.multiWindows.GUI.NewSty2JInternalFrame;
import leaseLineQuote.multiWindows.NewSty2StockFrame;

public class LayoutControl {
    private JDesktopPane desktop = null;
    private Map<String, Component> componentList = new HashMap<String, Component>();

    public LayoutControl() {
    }

    public LayoutControl(JDesktopPane jDesktopPane) {
        this.desktop = jDesktopPane;
    }

    public void setCloseButtonVisible(boolean bl) {
        for (Component component : this.componentList.values()) {
            if (!(component instanceof NewSty2JInternalFrame) || !component.isVisible()) continue;
            component = (NewSty2JInternalFrame)component;
            ((NewSty2JInternalFrame)component).setCloseButtonVisible(bl);
            ((JInternalFrame)component).setResizable(bl);
        }
    }

    public void add(Object object) {
        if (object instanceof Component) {
            this.add((Component)object);
        }
    }

    public void add(Component component) {
        String string = component.getName();
        if (string == null || string.length() == 0) {
            string = component.getClass().getName();
        }
        this.componentList.put(string, component);
    }

    public void moveAll2NearZero() {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Component component : this.componentList.values()) {
            if (!(component instanceof NewSty2JInternalFrame) || !component.isVisible()) continue;
            arrayList.add(component);
        }
        LayoutControl.moveAll2NearZero(arrayList);
    }

    public static final void moveAll2NearZero(Collection<Component> collection) {
        Point point;
        new Point(0, 0);
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        for (Component component : collection) {
            point = component.getLocation();
            if (point.x < n2) {
                n2 = point.x;
            }
            if (point.y >= n3) continue;
            n3 = point.y;
        }
        if (n2 > 0 || n3 > 0) {
            for (Component component : collection) {
                point = component.getLocation();
                component.setLocation(point.x - n2, point.y - n3);
            }
        }
    }

    public Dimension getMaxSize() {
        Dimension dimension = null;
        for (String string : this.componentList.keySet()) {
            Component component;
            if (string.equals("stockFrame") || (component = this.componentList.get(string)) == null || !component.isVisible()) continue;
            if (dimension == null) {
                dimension = new Dimension();
                new Dimension().width = component.getSize().width + component.getLocation().x;
                dimension.height = component.getSize().height + component.getLocation().y;
                continue;
            }
            if (component.getSize().width + component.getLocation().x > dimension.width) {
                dimension.width = component.getSize().width + component.getLocation().x;
            }
            if (component.getSize().height + component.getLocation().y <= dimension.height) continue;
            dimension.height = component.getSize().height + component.getLocation().y;
        }
        dimension.width += 4;
        dimension.height += 30;
        return dimension;
    }

    public Map<String, Map<String, Object>> getSetting() {
        HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>();
        for (String string : this.componentList.keySet()) {
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            Component component = this.componentList.get(string);
            if (!string.equals("stockFrame")) {
                int n2;
                hashMap2.put("Bounds", component.getBounds());
                hashMap2.put("Visable", component.isVisible());
                if (this.desktop != null && (n2 = this.desktop.getComponentZOrder(component)) != -1) {
                    hashMap2.put("ZOrder", n2);
                }
                if (component instanceof JInternalFrame) {
                    try {
                        hashMap2.put("Position", ((JInternalFrame)component).getLayeredPane().getPosition(component));
                    }
                    catch (Exception exception) {}
                }
                if (component instanceof MiniVersionSupport) {
                    hashMap2.put("Mini", ((MiniVersionSupport)((Object)component)).isMini());
                }
                if (component instanceof CustomLayoutSettingInterface) {
                    hashMap2.put("CustomLayoutSetting", ((CustomLayoutSettingInterface)((Object)component)).getCustomLayoutSetting());
                }
            } else {
                hashMap2.put("Size", component.getSize());
                if (component instanceof NewSty2StockFrame) {
                    hashMap2.put("FontSize", ((NewSty2StockFrame)component).getFontSize());
                }
            }
            hashMap.put(string, hashMap2);
        }
        return hashMap;
    }

    public void applySetting(Map<String, Map<String, Object>> map) {
        if (map != null) {
            for (String string : map.keySet()) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Map<String, Object> map2;
                Component component = this.componentList.get(string);
                if (component == null || (map2 = map.get(string)) == null) continue;
                if (component instanceof MiniVersionSupport && (object6 = map2.get("Mini")) != null && object6 instanceof Boolean) {
                    ((MiniVersionSupport)((Object)component)).setMini((Boolean)object6);
                }
                if (component instanceof CustomLayoutSettingInterface && (object5 = map2.get("CustomLayoutSetting")) != null && object5 instanceof Map) {
                    ((CustomLayoutSettingInterface)((Object)component)).setCustomLayoutSetting((Map)object5);
                }
                if ((object4 = map2.get("Size")) != null && object4 instanceof Dimension) {
                    component.setSize((Dimension)object4);
                }
                if ((object3 = map2.get("Bounds")) != null && object3 instanceof Rectangle) {
                    component.setBounds((Rectangle)object3);
                }
                if (component instanceof JInternalFrame) {
                    Integer n2;
                    Object object7 = map2.get("Position");
                    if (object7 != null && object7 instanceof Integer) {
                        try {
                            ((JInternalFrame)component).getLayeredPane().setPosition(component, (Integer)object7);
                        }
                        catch (Exception exception) {}
                    }
                    if ((n2 = (Integer)map2.get("ZOrder")) != null) {
                        try {
                            this.desktop.setComponentZOrder(component, n2);
                        }
                        catch (Exception exception) {}
                    }
                }
                if ((object2 = map2.get("Visable")) != null && object2 instanceof Boolean) {
                    component.setVisible((Boolean)object2);
                }
                if (!(component instanceof NewSty2StockFrame) || (object = map2.get("FontSize")) == null || !(object instanceof Integer)) continue;
                ((NewSty2StockFrame)component).setFontSize((Integer)object);
            }
        }
    }
}

