/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.socketagent;

import hk.com.realink.socketagent.AgentContent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;

public class AgentMessage
implements Externalizable {
    static final long serialVersionUID = 7701322313746484690L;
    private transient String clientKey = "";
    private transient String channelInfoKey = "";
    private transient String subClientKey = "";
    private transient byte[] contentBytes = null;
    private transient Object contentObj = null;
    private transient int accessMode;
    private transient int sourceId;
    public static final byte FLOW_SYSTEM = 0;
    public static final byte FLOW_REQUEST = 1;
    public static final byte FLOW_RESPONSE = 2;
    private transient byte flow = 0;

    public AgentMessage() {
    }

    public AgentMessage(AgentContent agentContent, byte by) {
        this.contentObj = agentContent;
        this.setFlow(by);
    }

    public AgentMessage(String string, AgentContent agentContent, byte by) {
        this.setClientKey(string);
        this.contentObj = agentContent;
        this.setFlow(by);
    }

    public AgentMessage(String string, Object object) {
        this.setClientKey(string);
        this.contentObj = object;
        this.setFlow((byte)0);
    }

    public int getFlow() {
        return this.flow;
    }

    public void setFlow(byte by) {
        this.flow = by;
        if (this.contentObj instanceof AgentContent) {
            AgentContent agentContent = (AgentContent)this.contentObj;
            agentContent.setFlow(by);
        }
        this.serialContent();
    }

    public int getSourceId() {
        return this.sourceId;
    }

    public void setAccessMode(int n2) {
        this.accessMode = n2;
    }

    public int getAccessMode() {
        return this.accessMode;
    }

    public void setClientKey(String string) {
        if (string != null) {
            this.clientKey = string;
        }
    }

    public String getClientKey() {
        return this.clientKey;
    }

    public void setSubClientKey(String string) {
        if (string != null) {
            this.subClientKey = string;
        }
    }

    public String getSubClientKey() {
        return this.subClientKey;
    }

    public void setChannelInfoKey(String string) {
        this.channelInfoKey = string;
    }

    public String getChannelInfoKey() {
        return this.channelInfoKey;
    }

    private void serialContent() {
        this.sourceId = this.contentObj.getClass().getPackage().hashCode();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this.contentObj);
            objectOutputStream.flush();
            this.contentBytes = byteArrayOutputStream.toByteArray();
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            this.contentBytes = null;
            return;
        }
    }

    public Object getContent() {
        try {
            InputStream inputStream = new ByteArrayInputStream(this.contentBytes);
            inputStream = new ObjectInputStream(inputStream);
            this.contentObj = ((ObjectInputStream)inputStream).readObject();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            this.contentObj = null;
        }
        return this.contentObj;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.channelInfoKey = objectInput.readUTF();
        this.clientKey = objectInput.readUTF();
        this.accessMode = objectInput.readByte();
        this.contentBytes = (byte[])objectInput.readObject();
        this.flow = objectInput.readByte();
        this.sourceId = objectInput.readInt();
        this.subClientKey = objectInput.readUTF();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.channelInfoKey);
        objectOutput.writeUTF(this.clientKey);
        objectOutput.writeByte(this.accessMode);
        objectOutput.writeObject(this.contentBytes);
        objectOutput.writeByte(this.flow);
        objectOutput.writeInt(this.sourceId);
        objectOutput.writeUTF(this.subClientKey);
    }

    public String paramString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("[AGENT_MESSAGE]");
        stringBuffer.append("clientKey=" + this.clientKey + ", ");
        stringBuffer.append("subClientKey=" + this.subClientKey + ", ");
        stringBuffer.append("channelInfoKey=" + this.channelInfoKey + ", ");
        stringBuffer.append("sourceId=" + this.sourceId + ", ");
        stringBuffer.append("flow=" + this.flow + ", ");
        stringBuffer.append("content=[" + string);
        stringBuffer.append(this.getContent());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

