/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.socketagent;

import hk.com.realink.socketagent.AccessModeType;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;
import java.util.TreeSet;

public class AgentContent
implements Externalizable {
    static final long serialVersionUID = -6277154050858492421L;
    public static byte LISTEN_PUSH = 1;
    public static byte LISTEN_PULL = (byte)2;
    public static byte LISTEN_LEAVE = (byte)4;
    private transient TreeMap accessBitSetMap = new TreeMap();
    private transient TreeMap accessMap = new TreeMap();
    private static final byte[] LISTEN_LIST = new byte[]{LISTEN_PUSH, LISTEN_PULL, LISTEN_LEAVE};
    private transient Integer[] ACCESS_LIST = new Integer[0];
    private transient TreeSet accessListMap = new TreeSet();
    private int accessBitSet = 0;
    private transient byte flow = 0;
    private ArrayList accessArray = new ArrayList();

    protected AgentContent() {
    }

    public void register(AccessModeType accessModeType) throws Exception {
        accessModeType.setClassInfo(this);
        for (int i2 = 0; i2 < this.ACCESS_LIST.length; ++i2) {
            this.accessListMap.add(this.ACCESS_LIST[i2]);
        }
        this.accessListMap.add(new Integer(accessModeType.getAccessMode()));
        this.ACCESS_LIST = this.accessListMap.toArray(new Integer[0]);
    }

    private void addAccessBitSet(AccessModeType accessModeType) {
        int n2 = accessModeType.getAccessMode();
        this.accessBitSet |= n2;
        Byte by = (Byte)this.accessBitSetMap.get(n2);
        if (by == null) {
            by = new Byte(accessModeType.getListenMode());
            this.accessBitSetMap.put(n2, by);
            return;
        }
        byte by2 = by;
        by2 = (byte)(by2 | accessModeType.getListenMode());
        this.accessBitSetMap.put(n2, by2);
    }

    public void addAccessMode(AccessModeType serializable) {
        if (!this.accessArray.contains(serializable)) {
            try {
                serializable.setClassInfo(this);
                this.accessArray.add(serializable);
                return;
            }
            catch (Exception exception) {
                serializable = exception;
                exception.printStackTrace();
            }
        }
    }

    private void sortAccessMode(AccessModeType accessModeType) {
        ArrayList<AccessModeType> arrayList;
        this.addAccessBitSet(accessModeType);
        TreeMap treeMap = (TreeMap)this.accessMap.get(new Integer(accessModeType.getAccessMode()));
        if (treeMap == null) {
            treeMap = new TreeMap();
            this.accessMap.put(new Integer(accessModeType.getAccessMode()), treeMap);
        }
        if ((arrayList = (ArrayList<AccessModeType>)treeMap.get(new Integer(accessModeType.getListenMode()))) == null) {
            arrayList = new ArrayList<AccessModeType>();
            treeMap.put(new Integer(accessModeType.getListenMode()), arrayList);
        }
        if (!arrayList.contains(accessModeType)) {
            arrayList.add(accessModeType);
        }
    }

    public void addAccessMode(AccessModeType[] accessModeTypeArray) {
        for (int i2 = 0; i2 < accessModeTypeArray.length; ++i2) {
            this.addAccessMode(accessModeTypeArray[i2]);
        }
    }

    public List getAccessModeList() {
        return this.accessArray;
    }

    public void setFlow(byte by) {
        this.flow = by;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        ListIterator listIterator = this.accessArray.listIterator();
        while (listIterator.hasNext()) {
            this.sortAccessMode((AccessModeType)listIterator.next());
        }
        objectOutput.writeInt(this.accessBitSet);
        for (int i2 = 0; i2 < this.ACCESS_LIST.length; ++i2) {
            TreeMap treeMap = (TreeMap)this.accessMap.get(this.ACCESS_LIST[i2]);
            if (treeMap == null) continue;
            Byte by = (Byte)this.accessBitSetMap.get(this.ACCESS_LIST[i2]);
            objectOutput.writeByte(by.byteValue());
            for (int i3 = 0; i3 < LISTEN_LIST.length; ++i3) {
                ArrayList arrayList = (ArrayList)treeMap.get(new Integer(LISTEN_LIST[i3]));
                if (arrayList == null) continue;
                int n2 = arrayList.size();
                objectOutput.writeInt(n2);
                for (int i4 = 0; i4 < n2; ++i4) {
                    AccessModeType accessModeType = (AccessModeType)arrayList.get(i4);
                    accessModeType.setFlow(this.flow);
                    objectOutput.writeObject(accessModeType);
                }
            }
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.accessBitSet = objectInput.readInt();
        for (int i2 = 0; i2 < this.ACCESS_LIST.length; ++i2) {
            if ((this.accessBitSet & this.ACCESS_LIST[i2]) <= 0) continue;
            byte by = objectInput.readByte();
            for (int i3 = 0; i3 < LISTEN_LIST.length; ++i3) {
                if ((by & LISTEN_LIST[i3]) <= 0) continue;
                int n2 = objectInput.readInt();
                for (int i4 = 0; i4 < n2; ++i4) {
                    AccessModeType accessModeType = (AccessModeType)objectInput.readObject();
                    accessModeType.setListenMode(LISTEN_LIST[i3]);
                    try {
                        accessModeType.setClassInfo(this);
                        this.accessArray.add(accessModeType);
                        continue;
                    }
                    catch (Exception exception) {
                        throw new IOException(exception);
                    }
                }
            }
        }
    }
}

