/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.quot.typeimple.multiwin;

import hk.com.realink.quot.typeimple.b;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class MultiWinSctyReq
implements b,
Externalizable {
    private static final long serialVersionUID = -321035207993295628L;
    protected static final int NONE = 0;
    public static final int REQUEST_TYPE_MAINFRAME = 2;
    public static final int REQUEST_TYPE_ORDERFRAME = 4;
    public static final int REQUEST_TYPE_ORDERFRAME_5 = 512;
    public static final int REQUEST_TYPE_QUEUEFRAME = 8;
    public static final int REQUEST_TYPE_TRADEFRAME = 16;
    public static final int REQUEST_TYPE_GRAPHICFRAME = 32;
    public static final int REQUEST_TYPE_RELATEDFRAME = 64;
    public static final int REQUEST_TYPE_NOTEFRAME = 128;
    public static final int REQUEST_TYPE_SCTYNEWSFRAME = 256;
    private final int[] FULL_FRAME_LIST = new int[]{2, 4, 512, 8, 16, 32, 64, 128, 256};
    private int sctyCode = 0;
    private String sctyCodeStr = "";
    private int requestItems = 0;
    private int listenMode = 2;

    public MultiWinSctyReq() {
    }

    public MultiWinSctyReq(int n2, int n3) {
        this.setSctyCode(n2);
        this.setListenMode(n3);
    }

    public MultiWinSctyReq(String string, int n2) {
        this.setSctyCodeStr(string);
        this.setListenMode(n2);
    }

    public void setSctyCode(int n2) {
        this.sctyCode = n2;
        this.sctyCodeStr = Integer.toString(n2);
    }

    public int getSctyCode() {
        return this.sctyCode;
    }

    public void setSctyCodeStr(String string) {
        this.sctyCodeStr = string;
        try {
            this.sctyCode = Integer.parseInt(string);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public String getSctyCodeString() {
        return this.sctyCodeStr;
    }

    public void setListenMode(int n2) {
        this.listenMode = n2;
    }

    public int getListenMode() {
        return this.listenMode;
    }

    public void addFrame(int n2) {
        this.requestItems |= n2;
        if (4 == n2) {
            this.removeFrame(512);
            return;
        }
        if (512 == n2) {
            this.removeFrame(4);
        }
    }

    private void removeFrame(int n2) {
        if (this.isRequestFrame(n2)) {
            this.requestItems ^= n2;
        }
    }

    public boolean isRequestFrame(int n2) {
        return MultiWinSctyReq.isRequestFrame(this.requestItems, n2);
    }

    public static boolean isRequestFrame(int n2, int n3) {
        return (n2 & n3) > 0;
    }

    public boolean haveRequestFrame() {
        return this.requestItems != 0;
    }

    public int getRequestedItems() {
        return this.requestItems;
    }

    public int[] getRequestedFrameList() {
        int[] nArray = new int[this.FULL_FRAME_LIST.length];
        int n2 = 0;
        for (int i2 = 0; i2 < this.FULL_FRAME_LIST.length; ++i2) {
            MultiWinSctyReq multiWinSctyReq = this;
            if (!multiWinSctyReq.isRequestFrame(multiWinSctyReq.FULL_FRAME_LIST[i2])) continue;
            nArray[n2++] = this.FULL_FRAME_LIST[i2];
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    public void reset() {
        this.sctyCode = 0;
        this.requestItems = 0;
        this.listenMode = 2;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.sctyCode);
        objectOutput.writeInt(this.requestItems);
        objectOutput.writeInt(this.listenMode);
        objectOutput.writeUTF(this.sctyCodeStr);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.sctyCode = objectInput.readInt();
        this.requestItems = objectInput.readInt();
        this.listenMode = objectInput.readInt();
        try {
            this.sctyCodeStr = objectInput.readUTF();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        object = (MultiWinSctyReq)object;
        return this.sctyCode == ((MultiWinSctyReq)object).sctyCode && this.requestItems == ((MultiWinSctyReq)object).requestItems && this.listenMode == ((MultiWinSctyReq)object).listenMode && this.sctyCodeStr.equals(((MultiWinSctyReq)object).sctyCodeStr);
    }

    public int hashCode() {
        int n2 = 155 + this.sctyCode;
        n2 = n2 * 31 + this.requestItems;
        n2 = n2 * 31 + this.listenMode;
        n2 = n2 * 31 + this.sctyCodeStr.hashCode();
        return n2;
    }
}

