/*
 * Decompiled with CFR 0.152.
 */
package framework.exception;

import framework.architecture.BasicTRX;
import framework.util.DAOUtil;
import framework.util.DateUtil;
import hk.com.realink.feed.toolkit.b;
import java.util.Date;

public class AppException
extends Exception {
    public String errorMsgType = null;
    public Exception exception = null;
    public String errorMsgDetail = null;
    public Date throwDatetime = null;

    public AppException(String object, Exception exception) {
        if (exception != null) {
            if (exception instanceof AppException) {
                object = (AppException)exception;
                this.errorMsgType = ((AppException)object).errorMsgType;
                this.errorMsgDetail = ((AppException)object).errorMsgDetail;
                this.exception = ((AppException)object).exception;
            } else {
                if (object != null && !((String)object).equals("")) {
                    this.errorMsgType = object;
                    b.warning(null, (String)object);
                }
                this.exception = exception;
                b.exception(exception);
            }
        }
        this.throwDatetime = new Date();
    }

    public AppException(String string, String string2) {
        if (string != null && !string.equals("")) {
            this.errorMsgType = string;
            b.warning(null, string);
        }
        if (string2 != null && !string2.equals("")) {
            this.errorMsgDetail = string2;
            b.warning(null, string2);
        }
        this.throwDatetime = new Date();
    }

    public AppException(String object, Exception exception, String string) {
        if (exception != null) {
            if (exception instanceof AppException) {
                object = (AppException)exception;
                this.errorMsgType = ((AppException)object).errorMsgType;
                this.errorMsgDetail = ((AppException)object).errorMsgDetail;
                this.exception = ((AppException)object).exception;
            } else {
                if (object != null && !((String)object).equals("")) {
                    this.errorMsgType = object;
                    b.warning(null, (String)object);
                }
                if (string != null && !string.equals("")) {
                    this.errorMsgDetail = string;
                    b.warning(null, string);
                }
                this.exception = exception;
                b.exception(exception);
            }
        }
        this.throwDatetime = new Date();
    }

    public AppException(String string, String string2, boolean bl) {
        if (string != null && !string.equals("")) {
            this.errorMsgType = string;
        }
        if (string2 != null && !string2.equals("")) {
            this.errorMsgDetail = string2;
        }
        this.throwDatetime = new Date();
        if (bl) {
            b.warning(null, string);
            this.logException();
        }
    }

    public void printStackTrace() {
        b.output("[Exception Type] " + this.errorMsgType);
        b.output("[Exception Detail] " + this.errorMsgDetail);
        b.output(this.exception.getMessage());
    }

    public void logException() {
        if (this.isUsefulException()) {
            BasicTRX basicTRX = new BasicTRX();
            try {
                Object object;
                basicTRX.startTrx();
                String string = "N/A";
                String string2 = "N/A";
                if (this.exception != null) {
                    string = this.exception.toString() + "\n";
                    object = this.exception.getStackTrace();
                    for (int i2 = 0; i2 < ((StackTraceElement[])object).length; ++i2) {
                        string = string + "> " + object[i2] + "\n";
                    }
                }
                if (this.errorMsgDetail != null) {
                    string2 = this.errorMsgDetail;
                }
                object = "INSERT INTO AppException (errorMsgType, exception, errorMsgDetail, throwDatetime) VALUES ('" + this.errorMsgType.replace("'", "\\'") + "', '" + string.replace("'", "\\'") + "', '" + string2.replace("'", "\\'") + "', '" + DateUtil.getSQLDateTime((Date)this.throwDatetime) + "')";
                DAOUtil.getInstance().executeUpdate(basicTRX, (String)object);
                basicTRX.endTrx();
                return;
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                b.exception(exception);
            }
        }
    }

    public boolean isUsefulException() {
        if (this.errorMsgType.equals("Error 5238: [CustPagerServiceService] Failed to sychronize pager bundle") && this.errorMsgDetail.contains("no custPlan can be retrieved")) {
            return false;
        }
        if (this.errorMsgType.equals("Error 1004: [DAO] Failed to execute query") && this.errorMsgDetail.contains("wait_timeout")) {
            return false;
        }
        return !this.errorMsgType.equals("Error 2035: [FileUtil] Cannot get text file content") || !this.errorMsgDetail.contains("seven.txt") || !DateUtil.isSatOrSun();
    }
}

