/*
 * Decompiled with CFR 0.152.
 */
package ats.client;

import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SeriesConvert {
    public static final char[] EXPF = new char[]{'F', 'G', 'H', 'J', 'K', 'M', 'N', 'Q', 'U', 'V', 'X', 'Z'};
    public static final char[] EXPOC = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L'};
    public static final char[] EXPOP = new char[]{'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X'};
    public static final String TRADEPRODUCT = "(HSI|HHI|MHI|MCH|CUS|HTI)[0-9]*\\.?[0-9]*[A-Z][0-9]";
    public static final String TRADEPRODUCTWK = "(HSI|HHI|MHI|MCH|CUS|HTI)[0-9]*\\.?[0-9]*[A-Z][0-9]W\\d+";
    public static final String WEEKLYOPT = "[A-Z0-9]{3,5}[0-9]+\\.?[0-9]*[A-Z][0-9]W\\d+";

    public static String gem_to_id(String string, String string2, int n2, char c2) {
        if (string.equals("HS")) {
            string = "HSI";
        } else if (string.equals("MH")) {
            string = "MHI";
        } else if (string.equals("HC")) {
            string = "HHI";
        } else if (string.equals("DJ")) {
            string = "DJI";
        } else if (string.equals("FX")) {
            string = "FXC";
        } else if (string.equals("MC")) {
            string = "MCH";
        } else if (string.equals("CUS")) {
            string = "CUS";
        } else if (string.equals("HTI")) {
            string = "HTI";
        }
        if (n2 > 0) {
            string = string + n2;
        }
        n2 = Integer.parseInt(string2.substring(0, 4)) % 10;
        int n3 = Integer.parseInt(string2.substring(4));
        switch (c2) {
            case '-': {
                string = string + EXPF[n3 - 1] + String.valueOf(n2);
                break;
            }
            case 'C': {
                string = string + EXPOC[n3 - 1] + String.valueOf(n2);
                break;
            }
            case 'P': {
                string = string + EXPOP[n3 - 1] + String.valueOf(n2);
            }
        }
        return string;
    }

    public static String gem_to_id(String string, String string2, String string3, char c2) {
        if (string.equals("HS")) {
            string = "HSI";
        } else if (string.equals("MH")) {
            string = "MHI";
        } else if (string.equals("HC")) {
            string = "HHI";
        } else if (string.equals("DJ")) {
            string = "DJI";
        } else if (string.equals("FX")) {
            string = "FXC";
        } else if (string.equals("MC")) {
            string = "MCH";
        } else if (string.equals("CUS")) {
            string = "CUS";
        } else if (string.equals("HTI")) {
            string = "HTI";
        }
        string = string + string3;
        int n2 = Integer.parseInt(string2.substring(0, 4)) % 10;
        int n3 = Integer.parseInt(string2.substring(4));
        switch (c2) {
            case '-': {
                string = string + EXPF[n3 - 1] + String.valueOf(n2);
                break;
            }
            case 'C': {
                string = string + EXPOC[n3 - 1] + String.valueOf(n2);
                break;
            }
            case 'P': {
                string = string + EXPOP[n3 - 1] + String.valueOf(n2);
            }
        }
        return string;
    }

    public static String gem_to_id(String string, String string2, int n2, char c2, char c3, int n3) {
        string = SeriesConvert.gem_to_id(string, string2, n2, c2);
        if (n3 > 0) {
            string = string + c3 + String.valueOf(n3);
        }
        return string;
    }

    public static String gem_to_id(String string, String string2, String string3, char c2, char c3, int n2) {
        string = SeriesConvert.gem_to_id(string, string2, string3, c2);
        if (n2 > 0) {
            string = string + c3 + String.valueOf(n2);
        }
        return string;
    }

    public static String[] id_to_gem(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf("/") > 0) {
            return null;
        }
        if (string.matches(WEEKLYOPT)) {
            System.out.println("------> sc.id_to_gem : weekly option ");
            String[] stringArray = string.substring(0, string.lastIndexOf(87));
            stringArray = SeriesConvert.id_to_gem2((String)stringArray);
            if (stringArray == null) {
                return null;
            }
            int n2 = stringArray.length;
            String[] stringArray2 = new String[n2 + 2];
            System.arraycopy(stringArray, 0, stringArray2, 0, n2);
            stringArray2[n2] = "W";
            String string2 = string;
            stringArray2[n2 + 1] = string2.substring(string2.lastIndexOf(87) + 1);
            return stringArray2;
        }
        return SeriesConvert.id_to_gem2(string);
    }

    public static String[] id_to_gem2(String string) {
        if (string.matches(TRADEPRODUCT)) {
            return SeriesConvert.id_to_gem3(string);
        }
        return SeriesConvert.id_to_gem4(string);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] id_to_gem4(String string) {
        void var2_4;
        if (string == null) {
            return null;
        }
        if (string.trim().length() < 5) {
            return null;
        }
        if (string.indexOf("/") > 0) {
            return null;
        }
        String[] stringArray = new String[4];
        int c2 = (int)(Math.rint(Math.floor(Calendar.getInstance().get(1) / 10)) * 10.0);
        String string2 = string;
        int object = c2 + Integer.parseInt(string2.substring(string2.length() - 1));
        while (var2_4 < Calendar.getInstance().get(1)) {
            var2_4 += 10;
        }
        stringArray[1] = String.valueOf((int)var2_4);
        String string3 = string;
        char c3 = string3.charAt(string3.length() - 2);
        if (SeriesConvert.isFuture(string)) {
            if (SeriesConvert.futmonth(c3) == 0) {
                return null;
            }
            stringArray[1] = SeriesConvert.futmonth(c3) < 10 ? stringArray[1] + "0" + String.valueOf(SeriesConvert.futmonth(c3)) : stringArray[1] + String.valueOf(SeriesConvert.futmonth(c3));
            stringArray[0] = string.substring(0, string.length() - 2);
            stringArray[2] = "-";
            stringArray[3] = "0";
        } else {
            int[] nArray = SeriesConvert.optmonth(c3);
            if (nArray[1] == 0) {
                return null;
            }
            stringArray[1] = nArray[1] < 10 ? stringArray[1] + "0" + String.valueOf(nArray[1]) : stringArray[1] + String.valueOf(nArray[1]);
            stringArray[2] = nArray[0] == 0 ? "C" : "P";
            Pattern pattern = Pattern.compile("[0-9\\.]");
            Matcher matcher = pattern.matcher(string);
            int n2 = -1;
            if (matcher.find()) {
                n2 = matcher.start();
            }
            if (n2 < 3 || n2 >= string.length() - 2) {
                return null;
            }
            stringArray[0] = string.substring(0, n2);
            stringArray[3] = string.substring(n2, string.length() - 2);
        }
        return stringArray;
    }

    public static String[] id_to_gem3(String charSequence) {
        if (charSequence == null) {
            return null;
        }
        if (((String)charSequence).indexOf("/") > 0) {
            return null;
        }
        String[] stringArray = new String[4];
        String string = ((String)charSequence).substring(0, 3);
        if (string.equals("HSI")) {
            stringArray[0] = "HS";
        } else if (string.equals("MHI")) {
            stringArray[0] = "MH";
        } else if (string.equals("HHI")) {
            stringArray[0] = "HC";
        } else if (string.equals("DJI")) {
            stringArray[0] = "DJ";
        } else if (string.equals("FXC")) {
            stringArray[0] = "FX";
        } else if (string.equals("MCH")) {
            stringArray[0] = "MC";
        } else if (string.equals("CUS")) {
            stringArray[0] = "CUS";
        } else if (string.equals("HTI")) {
            stringArray[0] = "HTI";
        } else {
            return null;
        }
        charSequence = new StringBuffer(((String)charSequence).substring(3));
        int n2 = (int)(Math.rint(Math.floor(Calendar.getInstance().get(1) / 10)) * 10.0);
        if (Character.isLetter(((StringBuffer)charSequence).charAt(0))) {
            n2 += Integer.parseInt(((StringBuffer)charSequence).substring(1));
            while (n2 < Calendar.getInstance().get(1)) {
                n2 += 10;
            }
            stringArray[1] = String.valueOf(n2);
            if (SeriesConvert.futmonth(((StringBuffer)charSequence).charAt(0)) == 0) {
                return null;
            }
            stringArray[1] = SeriesConvert.futmonth(((StringBuffer)charSequence).charAt(0)) < 10 ? stringArray[1] + "0" + String.valueOf(SeriesConvert.futmonth(((StringBuffer)charSequence).charAt(0))) : stringArray[1] + String.valueOf(SeriesConvert.futmonth(((StringBuffer)charSequence).charAt(0)));
            stringArray[2] = "-";
            stringArray[3] = "0";
        } else {
            int n3 = 0;
            for (int i2 = 1; i2 < ((StringBuffer)charSequence).length(); ++i2) {
                if (!Character.isLetter(((StringBuffer)charSequence).charAt(i2))) continue;
                n3 = i2;
                break;
            }
            n2 += Integer.parseInt(((StringBuffer)charSequence).substring(n3 + 1));
            while (n2 < Calendar.getInstance().get(1)) {
                n2 += 10;
            }
            stringArray[1] = String.valueOf(n2);
            int[] nArray = SeriesConvert.optmonth(((StringBuffer)charSequence).charAt(n3));
            if (nArray[1] == 0) {
                return null;
            }
            stringArray[1] = nArray[1] < 10 ? stringArray[1] + "0" + String.valueOf(nArray[1]) : stringArray[1] + String.valueOf(nArray[1]);
            stringArray[2] = nArray[0] == 0 ? "C" : "P";
            stringArray[3] = ((StringBuffer)charSequence).substring(0, n3);
        }
        return stringArray;
    }

    private static int futmonth(char c2) {
        switch (c2) {
            case 'F': {
                return 1;
            }
            case 'G': {
                return 2;
            }
            case 'H': {
                return 3;
            }
            case 'J': {
                return 4;
            }
            case 'K': {
                return 5;
            }
            case 'M': {
                return 6;
            }
            case 'N': {
                return 7;
            }
            case 'Q': {
                return 8;
            }
            case 'U': {
                return 9;
            }
            case 'V': {
                return 10;
            }
            case 'X': {
                return 11;
            }
            case 'Z': {
                return 12;
            }
        }
        return 0;
    }

    private static int[] optmonth(char c2) {
        int[] nArray = new int[2];
        switch (c2) {
            case 'A': {
                nArray[0] = 0;
                nArray[1] = 1;
                return nArray;
            }
            case 'B': {
                nArray[0] = 0;
                nArray[1] = 2;
                return nArray;
            }
            case 'C': {
                nArray[0] = 0;
                nArray[1] = 3;
                return nArray;
            }
            case 'D': {
                nArray[0] = 0;
                nArray[1] = 4;
                return nArray;
            }
            case 'E': {
                nArray[0] = 0;
                nArray[1] = 5;
                return nArray;
            }
            case 'F': {
                nArray[0] = 0;
                nArray[1] = 6;
                return nArray;
            }
            case 'G': {
                nArray[0] = 0;
                nArray[1] = 7;
                return nArray;
            }
            case 'H': {
                nArray[0] = 0;
                nArray[1] = 8;
                return nArray;
            }
            case 'I': {
                nArray[0] = 0;
                nArray[1] = 9;
                return nArray;
            }
            case 'J': {
                nArray[0] = 0;
                nArray[1] = 10;
                return nArray;
            }
            case 'K': {
                nArray[0] = 0;
                nArray[1] = 11;
                return nArray;
            }
            case 'L': {
                nArray[0] = 0;
                nArray[1] = 12;
                return nArray;
            }
            case 'M': {
                nArray[0] = 1;
                nArray[1] = 1;
                return nArray;
            }
            case 'N': {
                nArray[0] = 1;
                nArray[1] = 2;
                return nArray;
            }
            case 'O': {
                nArray[0] = 1;
                nArray[1] = 3;
                return nArray;
            }
            case 'P': {
                nArray[0] = 1;
                nArray[1] = 4;
                return nArray;
            }
            case 'Q': {
                nArray[0] = 1;
                nArray[1] = 5;
                return nArray;
            }
            case 'R': {
                nArray[0] = 1;
                nArray[1] = 6;
                return nArray;
            }
            case 'S': {
                nArray[0] = 1;
                nArray[1] = 7;
                return nArray;
            }
            case 'T': {
                nArray[0] = 1;
                nArray[1] = 8;
                return nArray;
            }
            case 'U': {
                nArray[0] = 1;
                nArray[1] = 9;
                return nArray;
            }
            case 'V': {
                nArray[0] = 1;
                nArray[1] = 10;
                return nArray;
            }
            case 'W': {
                nArray[0] = 1;
                nArray[1] = 11;
                return nArray;
            }
            case 'X': {
                nArray[0] = 1;
                nArray[1] = 12;
                return nArray;
            }
        }
        nArray[0] = 0;
        nArray[1] = 0;
        return nArray;
    }

    public static String gem_to_commodity(String string) {
        if (string.equals("HS")) {
            return "HSI";
        }
        if (string.equals("MH")) {
            return "MHI";
        }
        if (string.equals("HC")) {
            return "HHI";
        }
        if (string.equals("DJ")) {
            return "DJI";
        }
        if (string.equals("FX")) {
            return "FXC";
        }
        if (string.equals("MC")) {
            return "MCH";
        }
        if (string.equals("CUS")) {
            return "CUS";
        }
        if (string.equals("HTI")) {
            return "HTI";
        }
        return string;
    }

    protected static boolean isFuture(String string) {
        if (string.length() <= 7) {
            return true;
        }
        if (string.indexOf(46) >= 0) {
            return false;
        }
        return false;
    }

    public static String commodity(String stringArray) {
        if (stringArray == null) {
            return null;
        }
        if (stringArray.matches(TRADEPRODUCT) || stringArray.matches(TRADEPRODUCTWK)) {
            return stringArray.substring(0, 3);
        }
        if ((stringArray = SeriesConvert.id_to_gem((String)stringArray)) == null) {
            return null;
        }
        return SeriesConvert.gem_to_commodity(stringArray[0]);
    }

    public static String commodity(String string, boolean bl) {
        string = SeriesConvert.commodity(string);
        if (!bl && string == null) {
            return "";
        }
        return string;
    }
}

