/*
 * Decompiled with CFR 0.152.
 */
package ats.client;

import ats.client.NoNetDownMargin;
import blackscholes.ParamFile;
import blackscholes.Parameter;
import blackscholes.util.Margin;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import omnet.object.client.FODeal;

public class NoNetDown {
    protected double optratio = 1.0;
    protected Parameter param = null;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
    private Date cutoff = null;
    protected boolean debug = false;
    public Hashtable<String, NoNetDownMargin> records = new Hashtable();

    public NoNetDown() {
        this.init();
    }

    protected void init() {
        NoNetDownMargin noNetDownMargin = new NoNetDownMargin();
        new NoNetDownMargin().client = "COMPANY";
        this.records.put(noNetDownMargin.client, noNetDownMargin);
    }

    public void setOptRatio(double d2) {
        this.optratio = d2;
    }

    public void setParamFile(ParamFile paramFile) {
        this.param = (Parameter)paramFile;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public String getCutOff() {
        if (this.cutoff == null) {
            return null;
        }
        return this.sdf.format(this.cutoff).substring(8);
    }

    public void setCutOff(String string) {
        if (string == null) {
            this.cutoff = null;
            return;
        }
        try {
            Date date = new Date();
            this.cutoff = this.sdf.parse(this.sdf.format(date).substring(0, 8).concat(string));
            if (this.cutoff.after(date)) {
                this.cutoff = new Date(this.cutoff.getTime() - 86400000L);
            }
            return;
        }
        catch (Exception exception) {
            System.err.println("NoNetDown.setCutOff Failure");
            if (this.debug) {
                exception.printStackTrace();
            }
            this.cutoff = null;
            return;
        }
    }

    public Date getExactCutOff() {
        return this.cutoff;
    }

    public Hashtable<String, NoNetDownMargin> margin(FODeal fODeal, Hashtable<String, NoNetDownMargin> hashtable) {
        block22: {
            try {
                if (this.cutoff == null || this.sdf.parse(fODeal.created_time).after(this.cutoff)) {
                    NoNetDownMargin noNetDownMargin;
                    Object object = fODeal.series_id.substring(0, 3);
                    boolean bl = false;
                    if (fODeal.series_id.length() <= 7) {
                        bl = true;
                    }
                    if ((object = Parameter.b((String)object)) == null) {
                        return hashtable;
                    }
                    NoNetDownMargin noNetDownMargin2 = hashtable.get(fODeal.client);
                    if (noNetDownMargin2 == null) {
                        noNetDownMargin2 = new NoNetDownMargin();
                    }
                    if ((noNetDownMargin = hashtable.get("COMPANY")) == null) {
                        noNetDownMargin = new NoNetDownMargin();
                    }
                    if (fODeal.tx_type == 1 || fODeal.tx_type == 3) {
                        if (fODeal.bs == 'B') {
                            noNetDownMargin2.longQ += fODeal.deal_qty;
                            noNetDownMargin.longQ += fODeal.deal_qty;
                            if (bl) {
                                noNetDownMargin2.longM += (double)fODeal.deal_qty * ((Margin)object).a * Parameter.b;
                                noNetDownMargin.longM += (double)fODeal.deal_qty * ((Margin)object).a * Parameter.b;
                            } else {
                                noNetDownMargin2.longM += (double)(fODeal.deal_qty * fODeal.deal_price);
                                noNetDownMargin.longM += (double)(fODeal.deal_qty * fODeal.deal_price);
                            }
                        } else {
                            noNetDownMargin2.shortQ += fODeal.deal_qty;
                            noNetDownMargin.shortQ += fODeal.deal_qty;
                            if (bl) {
                                noNetDownMargin2.shortM += (double)fODeal.deal_qty * ((Margin)object).a * Parameter.b;
                                noNetDownMargin.shortM += (double)fODeal.deal_qty * ((Margin)object).a * Parameter.b;
                            } else {
                                noNetDownMargin2.shortM += (double)fODeal.deal_qty * ((Margin)object).a * this.optratio * Parameter.b;
                                noNetDownMargin.shortM += (double)fODeal.deal_qty * ((Margin)object).a * this.optratio * Parameter.b;
                            }
                        }
                    } else if (fODeal.tx_type == 4) {
                        if (fODeal.bs == 'B') {
                            noNetDownMargin2.shortQ -= fODeal.deal_qty;
                            noNetDownMargin.shortQ -= fODeal.deal_qty;
                            if (bl) {
                                noNetDownMargin2.shortM -= (double)fODeal.deal_qty * ((Margin)object).a * Parameter.b;
                                noNetDownMargin.shortM -= (double)fODeal.deal_qty * ((Margin)object).a * Parameter.b;
                            } else {
                                noNetDownMargin2.shortM -= (double)fODeal.deal_qty * ((Margin)object).a * this.optratio * Parameter.b;
                                noNetDownMargin.shortM -= (double)fODeal.deal_qty * ((Margin)object).a * this.optratio * Parameter.b;
                            }
                        } else {
                            noNetDownMargin2.longQ -= fODeal.deal_qty;
                            noNetDownMargin.longQ -= fODeal.deal_qty;
                            if (bl) {
                                noNetDownMargin2.longM -= (double)fODeal.deal_qty * ((Margin)object).a * Parameter.b;
                                noNetDownMargin.longM -= (double)fODeal.deal_qty * ((Margin)object).a * Parameter.b;
                            } else {
                                noNetDownMargin2.longM -= (double)(fODeal.deal_qty * fODeal.deal_price);
                                noNetDownMargin.longM -= (double)(fODeal.deal_qty * fODeal.deal_price);
                            }
                        }
                    }
                    hashtable.put(fODeal.client, noNetDownMargin2);
                    hashtable.put("COMPANY", noNetDownMargin);
                }
            }
            catch (Exception exception) {
                if (!this.debug) break block22;
                exception.printStackTrace();
            }
        }
        return hashtable;
    }

    public Hashtable<String, NoNetDownMargin> margin(Hashtable<String, FODeal> object, Hashtable<String, NoNetDownMargin> hashtable) {
        if (object == null || ((Hashtable)object).size() == 0) {
            return hashtable;
        }
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        for (FODeal fODeal : ((Hashtable)object).values()) {
            hashtable = this.margin(fODeal, hashtable);
        }
        return hashtable;
    }

    public void margin(FODeal fODeal) {
        this.records = this.margin(fODeal, this.records);
    }

    public void margin(Hashtable<String, FODeal> hashtable) {
        this.records = this.margin(hashtable, this.records);
    }

    public void clear() {
        this.records.clear();
        this.init();
    }
}

